/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.client;

import com.feed_the_beast.ftbl.FTBLibModCommon;
import com.feed_the_beast.ftbl.api.IFTBLibClientRegistry;
import com.feed_the_beast.ftbl.api.IFTBLibPlugin;
import com.feed_the_beast.ftbl.api.INotification;
import com.feed_the_beast.ftbl.api.config.IConfigFile;
import com.feed_the_beast.ftbl.api.config.IConfigKey;
import com.feed_the_beast.ftbl.api.config.IConfigValue;
import com.feed_the_beast.ftbl.api.gui.IGuiProvider;
import com.feed_the_beast.ftbl.api.gui.ISidebarButton;
import com.feed_the_beast.ftbl.api_impl.FTBLibAPI_Impl;
import com.feed_the_beast.ftbl.client.ClientNotifications;
import com.feed_the_beast.ftbl.client.EnumNotificationDisplay;
import com.feed_the_beast.ftbl.client.FTBLibActions;
import com.feed_the_beast.ftbl.client.FTBLibClientConfig;
import com.feed_the_beast.ftbl.client.FTBLibClientEventHandler;
import com.feed_the_beast.ftbl.lib.SidebarButton;
import com.feed_the_beast.ftbl.lib.client.FTBLibClient;
import com.feed_the_beast.ftbl.lib.client.ParticleColoredDust;
import com.feed_the_beast.ftbl.lib.config.ConfigFile;
import com.feed_the_beast.ftbl.lib.config.ConfigKey;
import com.feed_the_beast.ftbl.lib.gui.PlayerHeadImage;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiConfigs;
import com.feed_the_beast.ftbl.lib.gui.misc.GuiInfo;
import com.feed_the_beast.ftbl.lib.info.InfoPage;
import com.feed_the_beast.ftbl.lib.internal.FTBLibFinals;
import com.feed_the_beast.ftbl.lib.internal.FTBLibIntegrationInternal;
import com.feed_the_beast.ftbl.lib.net.MessageLM;
import com.feed_the_beast.ftbl.lib.util.LMColorUtils;
import com.feed_the_beast.ftbl.lib.util.LMStringUtils;
import com.feed_the_beast.ftbl.lib.util.LMUtils;
import com.mojang.authlib.GameProfile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.toposort.TopologicalSort;

public class FTBLibModClient
extends FTBLibModCommon
implements IFTBLibClientRegistry {
    private IConfigFile clientConfig;
    private static final Map<String, ISidebarButton> SIDEBAR_BUTTON_MAP = new HashMap<String, ISidebarButton>();
    private static final List<ISidebarButton> SIDEBAR_BUTTONS = new ArrayList<ISidebarButton>();
    private static final ISidebarButton DBUTTON_BEFORE_ALL = new SidebarButton.Dummy(new ResourceLocation("before_all"));
    private static final ISidebarButton DBUTTON_AFTER_ALL = new SidebarButton.Dummy(new ResourceLocation("after_all"));
    private static final ISidebarButton DBUTTON_BEFORE = new SidebarButton.Dummy(new ResourceLocation("before"));
    private static final ISidebarButton DBUTTON_AFTER = new SidebarButton.Dummy(new ResourceLocation("after"));
    private static final Map<ResourceLocation, IGuiProvider> GUI_PROVIDERS = new HashMap<ResourceLocation, IGuiProvider>();

    @Override
    public void preInit() {
        super.preInit();
        this.clientConfig = new ConfigFile((ITextComponent)new TextComponentTranslation("sidebar_button." + FTBLibActions.SETTINGS.func_176610_l(), new Object[0]), () -> new File(LMUtils.folderLocal, "client_config.json"));
        this.addClientConfig("ftbl", "item_ore_names", FTBLibClientConfig.ITEM_ORE_NAMES, new int[0]);
        this.addClientConfig("ftbl", "action_buttons_on_top", FTBLibClientConfig.ACTION_BUTTONS_ON_TOP, new int[0]);
        this.addClientConfig("ftbl", "notifications", FTBLibClientConfig.NOTIFICATIONS, new int[0]);
        this.addClientConfig("ftbl", "gui.info.border_width", GuiConfigs.INFO_BORDER_WIDTH, 8);
        this.addClientConfig("ftbl", "gui.info.border_height", GuiConfigs.INFO_BORDER_HEIGHT, 8);
        this.addClientConfig("ftbl", "gui.info.color_background", GuiConfigs.INFO_BACKGROUND, new int[0]);
        this.addClientConfig("ftbl", "gui.info.color_text", GuiConfigs.INFO_TEXT, new int[0]);
        this.addClientConfig("ftbl", "gui.enable_chunk_selector_depth", GuiConfigs.ENABLE_CHUNK_SELECTOR_DEPTH, new int[0]);
        this.addSidebarButton(FTBLibActions.TEAMS_GUI);
        this.addSidebarButton(FTBLibActions.SETTINGS);
        this.addSidebarButton(FTBLibActions.MY_SERVER_SETTINGS);
        for (IFTBLibPlugin iFTBLibPlugin : FTBLibIntegrationInternal.API.getAllPlugins()) {
            iFTBLibPlugin.registerClient(this);
        }
        SIDEBAR_BUTTON_MAP.forEach((key, button) -> {
            IConfigValue value = button.getConfig();
            if (value != null) {
                this.clientConfig.add(new ConfigKey("sidebar_button." + button.func_176610_l(), value.copy()), value);
            }
        });
        TopologicalSort.DirectedGraph sidebarButtonGraph = new TopologicalSort.DirectedGraph();
        sidebarButtonGraph.addNode((Object)DBUTTON_BEFORE_ALL);
        sidebarButtonGraph.addNode((Object)DBUTTON_BEFORE);
        sidebarButtonGraph.addNode((Object)DBUTTON_AFTER_ALL);
        sidebarButtonGraph.addNode((Object)DBUTTON_AFTER);
        sidebarButtonGraph.addEdge((Object)DBUTTON_BEFORE, (Object)DBUTTON_AFTER);
        sidebarButtonGraph.addEdge((Object)DBUTTON_BEFORE_ALL, (Object)DBUTTON_BEFORE);
        sidebarButtonGraph.addEdge((Object)DBUTTON_AFTER, (Object)DBUTTON_AFTER_ALL);
        SIDEBAR_BUTTON_MAP.values().forEach(arg_0 -> ((TopologicalSort.DirectedGraph)sidebarButtonGraph).addNode(arg_0));
        for (ISidebarButton button2 : SIDEBAR_BUTTON_MAP.values()) {
            boolean preDepAdded = false;
            boolean postDepAdded = false;
            for (Map.Entry<String, Boolean> entry : button2.getDependencies().entrySet()) {
                if (entry.getValue().booleanValue()) {
                    for (String id : button2.getDependencies().keySet()) {
                        postDepAdded = true;
                        if (id.equals("*")) {
                            sidebarButtonGraph.addEdge((Object)DBUTTON_BEFORE_ALL, (Object)button2);
                            sidebarButtonGraph.addEdge((Object)button2, (Object)DBUTTON_BEFORE);
                            preDepAdded = true;
                            continue;
                        }
                        sidebarButtonGraph.addEdge((Object)button2, (Object)DBUTTON_AFTER);
                        if (!SIDEBAR_BUTTON_MAP.containsKey(id)) continue;
                        sidebarButtonGraph.addEdge((Object)button2, (Object)SIDEBAR_BUTTON_MAP.get(id));
                    }
                    continue;
                }
                preDepAdded = true;
                String id = entry.getKey();
                if (id.equals("*")) {
                    sidebarButtonGraph.addEdge((Object)button2, (Object)DBUTTON_AFTER_ALL);
                    sidebarButtonGraph.addEdge((Object)DBUTTON_AFTER, (Object)button2);
                    postDepAdded = true;
                    continue;
                }
                sidebarButtonGraph.addEdge((Object)DBUTTON_BEFORE, (Object)button2);
                if (!SIDEBAR_BUTTON_MAP.containsKey(id)) continue;
                sidebarButtonGraph.addEdge((Object)SIDEBAR_BUTTON_MAP.get(id), (Object)button2);
            }
            if (!preDepAdded) {
                sidebarButtonGraph.addEdge((Object)DBUTTON_BEFORE, (Object)button2);
            }
            if (postDepAdded) continue;
            sidebarButtonGraph.addEdge((Object)button2, (Object)DBUTTON_AFTER);
        }
        List list = TopologicalSort.topologicalSort((TopologicalSort.DirectedGraph)sidebarButtonGraph);
        list.removeAll(Arrays.asList(DBUTTON_BEFORE_ALL, DBUTTON_BEFORE, DBUTTON_AFTER, DBUTTON_AFTER_ALL));
        SIDEBAR_BUTTONS.clear();
        SIDEBAR_BUTTONS.addAll(list);
        FTBLibFinals.LOGGER.info("Sorted sidebar buttons to " + SIDEBAR_BUTTONS);
        MinecraftForge.EVENT_BUS.register((Object)new FTBLibClientEventHandler());
        GameProfile profile = Minecraft.func_71410_x().func_110432_I().func_148256_e();
        if (profile.getId().equals(LMStringUtils.fromString("5afb9a5b207d480e887967bc848f9a8f"))) {
            LMUtils.userIsLatvianModder = true;
        }
        FTBLibClient.localPlayerHead = new PlayerHeadImage(profile.getName());
    }

    @Override
    public void postInit() {
        super.postInit();
    }

    @Override
    public void spawnDust(World w, double x, double y, double z, int col) {
        float alpha = LMColorUtils.getAlphaF(col);
        float red = LMColorUtils.getRedF(col);
        float green = LMColorUtils.getGreenF(col);
        float blue = LMColorUtils.getBlueF(col);
        if (alpha <= 0.0f) {
            alpha = 1.0f;
        }
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleColoredDust(w, x, y, z, red, green, blue, alpha));
    }

    @Override
    public void loadAllFiles() {
        super.loadAllFiles();
        this.clientConfig.load();
    }

    @Override
    public void saveAllFiles() {
        super.saveAllFiles();
        this.clientConfig.save();
    }

    @Override
    public void addClientConfig(IConfigKey key, IConfigValue value) {
        this.clientConfig.add(key, value);
    }

    @Override
    public void addGui(ResourceLocation id, IGuiProvider provider) {
        GUI_PROVIDERS.put(id, provider);
    }

    @Override
    public void addSidebarButton(ISidebarButton button) {
        SIDEBAR_BUTTON_MAP.put(button.func_176610_l(), button);
    }

    @Override
    public IConfigFile getClientConfig() {
        return this.clientConfig;
    }

    @Override
    public void handleClientMessage(MessageLM<?> message) {
        Minecraft.func_71410_x().func_152344_a(() -> {
            message.onMessage((MessageLM)LMUtils.cast(message), (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            if (FTBLibAPI_Impl.LOG_NET) {
                LMUtils.DEV_LOGGER.info("RX MessageLM: " + message.getClass().getName());
            }
        });
    }

    @Override
    public void displayInfoGui(InfoPage page) {
        new GuiInfo(page).openGui();
    }

    @Override
    public void displayNotification(EnumNotificationDisplay display, INotification n) {
        if (display == EnumNotificationDisplay.SCREEN) {
            ClientNotifications.add(n);
            return;
        }
        List<ITextComponent> list = n.getText();
        if (list.isEmpty()) {
            return;
        }
        if (list.size() > 1) {
            list.get(0).func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, list.get(1)));
        }
        GuiNewChat chat = Minecraft.func_71410_x().field_71456_v.func_146158_b();
        if (display == EnumNotificationDisplay.CHAT) {
            chat.func_146234_a(list.get(0), n.getId().getChatMessageID());
        } else {
            chat.func_146227_a(list.get(0));
        }
    }

    public static List<ISidebarButton> getSidebarButtons(boolean ignoreConfig) {
        if (ignoreConfig) {
            return SIDEBAR_BUTTONS;
        }
        ArrayList<ISidebarButton> list = new ArrayList<ISidebarButton>();
        for (ISidebarButton button : SIDEBAR_BUTTONS) {
            if (!button.isVisible() || button.getConfig() != null && !button.getConfig().getBoolean()) continue;
            list.add(button);
        }
        return list;
    }

    @Nullable
    public static IGuiProvider getGui(ResourceLocation id) {
        return GUI_PROVIDERS.get(id);
    }
}

