/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api;

import com.feed_the_beast.ftbl.api.EnumTeamStatus;
import com.feed_the_beast.ftbl.api.IForgeTeam;
import com.feed_the_beast.ftbl.api.config.IConfigTree;
import com.feed_the_beast.ftbl.api.security.EnumPrivacyLevel;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatisticsManagerServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;

public interface IForgePlayer
extends INBTSerializable<NBTTagCompound> {
    public static final int FLAG_HIDE_TEAM_NOTIFICATION = 1;
    public static final int FLAG_HIDE_NEW_TEAM_MSG_NOTIFICATION = 2;

    public UUID getId();

    public String getName();

    default public GameProfile getProfile() {
        return new GameProfile(this.getId(), this.getName());
    }

    public EntityPlayerMP getPlayer();

    @Nullable
    public INBTSerializable<?> getData(ResourceLocation var1);

    public boolean equalsPlayer(@Nullable IForgePlayer var1);

    public void setTeamID(String var1);

    @Nullable
    public IForgeTeam getTeam();

    default public boolean canInteract(@Nullable IForgePlayer owner, EnumPrivacyLevel level) {
        IForgeTeam team;
        if (level == EnumPrivacyLevel.PUBLIC || owner == null) {
            return true;
        }
        if (owner.equalsPlayer(this)) {
            return true;
        }
        if (level == EnumPrivacyLevel.PRIVATE) {
            return false;
        }
        return level == EnumPrivacyLevel.TEAM && (team = owner.getTeam()) != null && team.hasStatus(this, EnumTeamStatus.ALLY);
    }

    public boolean isOnline();

    public boolean isFake();

    public boolean isOP();

    public StatisticsManagerServer stats();

    public IConfigTree getSettings();

    public NBTTagCompound getPlayerNBT();

    public int getFlags();

    public void setFlags(int var1);
}

