/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbl.api;

import com.feed_the_beast.ftbl.lib.EnumNameMap;
import com.feed_the_beast.ftbl.lib.ILangKeyContainer;
import com.feed_the_beast.ftbl.lib.LangKey;
import java.util.Collection;
import java.util.LinkedHashSet;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.text.TextFormatting;

public enum EnumTeamStatus implements IStringSerializable,
ILangKeyContainer
{
    ENEMY(-10, "enemy", TextFormatting.RED, true),
    NONE(0, "none", TextFormatting.WHITE, true),
    REQUESTING_INVITE(5, "requesting_invite", TextFormatting.WHITE, false),
    INVITED(10, "invited", TextFormatting.DARK_AQUA, true),
    ALLY(30, "ally", TextFormatting.BLUE, true),
    MEMBER(50, "member", TextFormatting.GREEN, false),
    MOD(80, "mod", TextFormatting.DARK_PURPLE, true),
    OWNER(100, "owner", TextFormatting.GOLD, false);

    public static final EnumTeamStatus[] VALUES;
    public static final EnumNameMap<EnumTeamStatus> NAME_MAP;
    public static final Collection<EnumTeamStatus> VALID_VALUES;
    private final String name;
    private final int status;
    private final TextFormatting color;
    private final LangKey langKey;
    private final boolean canBeSet;

    private EnumTeamStatus(int s, String n2, TextFormatting c, boolean cs) {
        this.name = n2;
        this.status = s;
        this.color = c;
        this.langKey = new LangKey("ftbl.lang.team_status." + this.name);
        this.canBeSet = cs;
    }

    public String func_176610_l() {
        return this.name;
    }

    public int getStatus() {
        return this.status;
    }

    public TextFormatting getColor() {
        return this.color;
    }

    @Override
    public LangKey getLangKey() {
        return this.langKey;
    }

    public boolean canBeSet() {
        return this.canBeSet;
    }

    public boolean isNone() {
        return this == NONE;
    }

    public boolean isEqualOrGreaterThan(EnumTeamStatus s) {
        return this.status >= s.status;
    }

    public String toString() {
        return this.func_176610_l();
    }

    static {
        VALUES = EnumTeamStatus.values();
        NAME_MAP = new EnumNameMap((Enum[])VALUES, false);
        VALID_VALUES = new LinkedHashSet<EnumTeamStatus>();
        for (EnumTeamStatus s : VALUES) {
            if (!s.canBeSet) continue;
            VALID_VALUES.add(s);
        }
    }
}

