/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.runtime;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.runtime.GlobalRegistry;
import minetweaker.runtime.IScriptIterator;
import minetweaker.runtime.IScriptProvider;
import minetweaker.runtime.ITweaker;
import minetweaker.runtime.providers.ScriptProviderMemory;
import stanhebben.zenscript.ZenModule;
import stanhebben.zenscript.ZenParsedFile;
import stanhebben.zenscript.ZenTokener;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.parser.ParseException;

public class MTTweaker
implements ITweaker {
    private static boolean DEBUG = false;
    private final List<IUndoableAction> actions = new ArrayList<IUndoableAction>();
    private final Set<IUndoableAction> wereStuck = new LinkedHashSet<IUndoableAction>();
    private final Map<Object, IUndoableAction> stuckOverridable = new HashMap<Object, IUndoableAction>();
    private IScriptProvider scriptProvider;
    private byte[] scriptData;

    @Override
    public byte[] getStagedScriptData() {
        return ScriptProviderMemory.collect(this.scriptProvider);
    }

    @Override
    public void apply(IUndoableAction action) {
        MineTweakerAPI.logInfo(action.describe());
        Object overrideKey = action.getOverrideKey();
        if (this.wereStuck.contains(action)) {
            this.wereStuck.remove(action);
            if (overrideKey != null) {
                this.stuckOverridable.remove(overrideKey);
            }
        } else {
            if (overrideKey != null && this.stuckOverridable.containsKey(overrideKey)) {
                this.wereStuck.remove(this.stuckOverridable.get(overrideKey));
                this.stuckOverridable.remove(overrideKey);
            }
            action.apply();
        }
        this.actions.add(action);
    }

    @Override
    public void remove(IIngredient items) {
        GlobalRegistry.remove(items);
    }

    @Override
    public List<IUndoableAction> rollback() {
        ArrayList<IUndoableAction> stuck = new ArrayList<IUndoableAction>();
        for (int i = this.actions.size() - 1; i >= 0; --i) {
            IUndoableAction action = this.actions.get(i);
            if (action.canUndo()) {
                MineTweakerAPI.logInfo(action.describeUndo());
                action.undo();
                continue;
            }
            MineTweakerAPI.logInfo("[Stuck] 1 " + action.describe());
            MineTweakerAPI.logInfo("[Stuck] 2 " + action.describeUndo());
            MineTweakerAPI.logInfo("[Stuck] 3 " + action.toString());
            stuck.add(0, action);
            this.wereStuck.add(action);
            Object overrideKey = action.getOverrideKey();
            if (overrideKey == null) continue;
            this.stuckOverridable.put(overrideKey, action);
        }
        this.actions.clear();
        return stuck;
    }

    @Override
    public void setScriptProvider(IScriptProvider provider) {
        this.scriptProvider = provider;
    }

    @Override
    public void load() {
        System.out.println("Loading scripts");
        this.scriptData = ScriptProviderMemory.collect(this.scriptProvider);
        HashSet<String> executed = new HashSet<String>();
        Iterator<IScriptIterator> scripts = this.scriptProvider.getScripts();
        while (scripts.hasNext()) {
            IScriptIterator script = scripts.next();
            if (executed.contains(script.getGroupName())) continue;
            executed.add(script.getGroupName());
            HashMap<String, byte[]> classes = new HashMap<String, byte[]>();
            IEnvironmentGlobal environmentGlobal = GlobalRegistry.makeGlobalEnvironment(classes);
            ArrayList<ZenParsedFile> files = new ArrayList<ZenParsedFile>();
            while (script.next()) {
                InputStreamReader reader = null;
                try {
                    reader = new InputStreamReader((InputStream)new BufferedInputStream(script.open()), "UTF-8");
                    String filename = script.getName();
                    String className = ZenModule.extractClassName(filename);
                    ZenTokener parser = new ZenTokener((Reader)reader, environmentGlobal.getEnvironment());
                    ZenParsedFile pfile = new ZenParsedFile(filename, className, parser, environmentGlobal);
                    files.add(pfile);
                }
                catch (IOException ex) {
                    MineTweakerAPI.logError("Could not load script " + script.getName() + ": " + ex.getMessage());
                }
                catch (ParseException ex) {
                    MineTweakerAPI.logError("Error parsing " + ex.getFile().getFileName() + ":" + ex.getLine() + " -- " + ex.getExplanation());
                }
                catch (Exception ex) {
                    MineTweakerAPI.logError("Error loading " + script.getName() + ": " + ex.toString(), ex);
                }
                if (reader == null) continue;
                try {
                    ((Reader)reader).close();
                }
                catch (IOException ex) {}
            }
            try {
                String filename = script.getGroupName();
                System.out.println("MineTweaker: Loading " + filename);
                ZenModule.compileScripts(filename, files, environmentGlobal, DEBUG);
                ZenModule module = new ZenModule(classes, MineTweakerAPI.class.getClassLoader());
                module.getMain().run();
            }
            catch (Throwable ex) {
                MineTweakerAPI.logError("Error executing " + script.getGroupName() + ": " + ex.getMessage(), ex);
            }
        }
        if (this.wereStuck.size() > 0) {
            MineTweakerAPI.logWarning(Integer.toString(this.wereStuck.size()) + " modifications were stuck");
            for (IUndoableAction action : this.wereStuck) {
                MineTweakerAPI.logInfo("Stuck: " + action.describe());
            }
        }
    }

    @Override
    public byte[] getScriptData() {
        return this.scriptData;
    }

    @Override
    public List<IUndoableAction> getActions() {
        return this.actions;
    }

    @Override
    public void enableDebug() {
        DEBUG = true;
    }
}

