/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.tileentity;

import net.malisis.core.block.IBoundingBox;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.multiblock.AABBMultiBlock;
import net.malisis.core.util.syncer.Sync;
import net.malisis.core.util.syncer.Syncable;
import net.malisis.core.util.syncer.Syncer;
import net.malisis.doors.MalisisDoors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@Syncable(value="TileEntity")
public class ForcefieldTileEntity
extends TileEntity {
    private AABBMultiBlock multiBlock;
    private boolean opened = false;

    @Sync(value="opened")
    public boolean isOpened() {
        return this.opened;
    }

    @Sync(value="opened")
    public void setOpened(boolean opened) {
        this.opened = opened;
    }

    public void switchForcefield() {
        this.opened = !this.opened;
        Syncer.sync((Object)((Object)this), (String[])new String[]{"opened"});
    }

    public void setMultiBlock(AABBMultiBlock multiBlock) {
        this.multiBlock = multiBlock;
    }

    public AABBMultiBlock getMultiBlock() {
        return this.multiBlock;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.opened = tag.func_74767_n("opened");
        if (tag.func_74764_b("multiBlock")) {
            tag = tag.func_74775_l("multiBlock");
        }
        if (tag.func_74764_b("minX")) {
            AxisAlignedBB aabb = AABBUtils.readFromNBT((NBTTagCompound)tag);
            this.multiBlock = new AABBMultiBlock((Block)MalisisDoors.Blocks.forcefieldDoor, aabb);
            this.multiBlock.setBulkProcess(true, true);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.multiBlock != null) {
            AABBUtils.writeToNBT((NBTTagCompound)tag, (AxisAlignedBB)this.multiBlock.getBoundingBox());
        }
        tag.func_74757_a("opened", this.opened);
        return tag;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return IBoundingBox.getRenderingBounds((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c);
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

