/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors.block;

import com.google.common.collect.Lists;
import java.util.List;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.renderer.DefaultRenderer;
import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.core.util.multiblock.AABBMultiBlock;
import net.malisis.core.util.multiblock.MultiBlock;
import net.malisis.core.util.multiblock.MultiBlockComponent;
import net.malisis.core.util.raytrace.RaytraceBlock;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.renderer.RustyHatchRenderer;
import net.malisis.doors.tileentity.RustyHatchTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

@MalisisRendered(block=RustyHatchRenderer.class, item=DefaultRenderer.Item.class)
public class RustyHatch
extends MalisisBlock {
    private AABBMultiBlock bottomMultiBlock = new AABBMultiBlock((Block)this, new AxisAlignedBB(-1.0, -2.0, 0.0, 1.0, 1.0, 2.0));
    private AABBMultiBlock topMultiBlock = new AABBMultiBlock((Block)this, new AxisAlignedBB(-1.0, 0.0, 0.0, 1.0, 3.0, 2.0));
    public static PropertyBool TOP = PropertyBool.func_177716_a((String)"top");

    public RustyHatch() {
        super(Material.field_151573_f);
        this.func_149711_c(3.0f);
        this.func_149752_b(10000.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setName("rustyHatch");
        this.func_149647_a(MalisisDoors.tab);
        this.bottomMultiBlock.setBulkProcess(true, true);
        this.topMultiBlock.setBulkProcess(true, true);
        this.addComponent((IComponent)new MultiBlockComponent((world, pos, state, itemStack) -> RustyHatch.isTop(state) ? this.topMultiBlock : this.bottomMultiBlock));
        if (MalisisCore.isClient()) {
            this.addComponent((IComponent)RustyHatchIconProvider.get());
        }
    }

    protected List<IProperty<?>> getProperties() {
        return Lists.newArrayList((Object[])new IProperty[]{TOP});
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.UP || side == EnumFacing.DOWN) {
            return false;
        }
        pos = pos.func_177972_a(side.func_176734_d());
        return world.func_180495_p(pos).isSideSolid((IBlockAccess)world, pos, side);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, ItemStack itemStack) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, itemStack).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf(hitY > 0.5f));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        RustyHatchTileEntity te = RustyHatch.getRustyHatch((IBlockAccess)world, pos);
        if (te == null) {
            return true;
        }
        te.openOrCloseDoor();
        return true;
    }

    public AxisAlignedBB getBoundingBox(IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        AxisAlignedBB aabb;
        RustyHatchTileEntity te = RustyHatch.getRustyHatch(world, pos);
        if (te == null || te.getMovement() == null) {
            return AABBUtils.identity();
        }
        if (te.isMoving()) {
            return null;
        }
        AxisAlignedBB axisAlignedBB = aabb = te.isOpened() ? te.getMovement().getOpenBoundingBox(te, te.isTop(), type) : te.getMovement().getClosedBoundingBox(te, te.isTop(), type);
        if (aabb == null) {
            return null;
        }
        aabb = AABBUtils.rotate((AxisAlignedBB)aabb, (EnumFacing)te.getDirection());
        pos = pos.func_177973_b((Vec3i)te.func_174877_v());
        aabb = aabb.func_72317_d((double)(-pos.func_177958_n()), (double)(-pos.func_177956_o()), (double)(-pos.func_177952_p()));
        if (type == BoundingBoxType.RAYTRACE) {
            pos.func_177977_b();
        }
        if (type == BoundingBoxType.SELECTION) {
            pos.func_177977_b();
        }
        return aabb;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        AxisAlignedBB[] aabbs = this.getBoundingBoxes((IBlockAccess)world, pos, state, BoundingBoxType.COLLISION);
        for (AxisAlignedBB aabb : AABBUtils.offset((BlockPos)pos, (AxisAlignedBB[])aabbs)) {
            if (aabb == null || !mask.func_72326_a(aabb)) continue;
            list.add(aabb);
        }
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        Object[] aabbs = this.getBoundingBoxes((IBlockAccess)world, pos, state, BoundingBoxType.SELECTION);
        if (ArrayUtils.isEmpty((Object[])aabbs) || aabbs[0] == null) {
            return AABBUtils.empty((BlockPos)pos);
        }
        return AABBUtils.offset((BlockPos)pos, (AxisAlignedBB[])aabbs)[0];
    }

    public AxisAlignedBB[] getRayTraceBoundingBox(IBlockAccess world, BlockPos pos, IBlockState state) {
        AxisAlignedBB[] aabbs = this.getBoundingBoxes(world, pos, state, BoundingBoxType.RAYTRACE);
        return aabbs;
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d src, Vec3d dest) {
        return new RaytraceBlock(world, src, dest, pos).trace();
    }

    public boolean hasTileEntity(IBlockState state) {
        return MultiBlockComponent.isOrigin((IBlockState)state);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return MultiBlockComponent.isOrigin((IBlockState)state) ? new RustyHatchTileEntity() : null;
    }

    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a((IProperty)TOP, (Comparable)Boolean.valueOf((meta & 4) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return super.func_176201_c(state) + ((Boolean)state.func_177229_b((IProperty)TOP) != false ? 4 : 0);
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        RustyHatchTileEntity te = RustyHatch.getRustyHatch(world, pos);
        if (te == null) {
            return false;
        }
        return te.shouldLadder(pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public static boolean isTop(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)TOP);
    }

    public static RustyHatchTileEntity getRustyHatch(IBlockAccess world, BlockPos pos) {
        BlockPos origin = MultiBlock.getOrigin((IBlockAccess)world, (BlockPos)pos);
        return (RustyHatchTileEntity)((Object)TileEntityUtils.getTileEntity(RustyHatchTileEntity.class, (IBlockAccess)world, (BlockPos)(origin != null ? origin : pos)));
    }

    public static class RustyHatchIconProvider
    implements IIconProvider {
        private Icon hatchIcon = Icon.from((String)"malisisdoors:blocks/rusty_hatch");
        private Icon handleIcon = Icon.from((String)"malisisdoors:blocks/rusty_hatch_handle");
        private Icon hatchItemIcon = Icon.from((String)"malisisdoors:items/rusty_hatch_item");

        public Icon getIcon() {
            return this.hatchItemIcon;
        }

        public Icon getHandleIcon() {
            return this.handleIcon;
        }

        public Icon getHatchIcon() {
            return this.hatchIcon;
        }

        public static RustyHatchIconProvider get() {
            return new RustyHatchIconProvider();
        }
    }
}

