/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.init;

import cofh.core.render.IModelRegister;
import cofh.lib.util.helpers.EnergyHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.RedstoneArsenal;
import cofh.redstonearsenal.item.ItemMaterial;
import cofh.redstonearsenal.item.armor.ItemArmorRF;
import cofh.redstonearsenal.item.tool.ItemAxeRF;
import cofh.redstonearsenal.item.tool.ItemBattleWrenchRF;
import cofh.redstonearsenal.item.tool.ItemBowRF;
import cofh.redstonearsenal.item.tool.ItemFishingRodRF;
import cofh.redstonearsenal.item.tool.ItemHammerRF;
import cofh.redstonearsenal.item.tool.ItemPickaxeRF;
import cofh.redstonearsenal.item.tool.ItemShieldRF;
import cofh.redstonearsenal.item.tool.ItemShovelRF;
import cofh.redstonearsenal.item.tool.ItemSickleRF;
import cofh.redstonearsenal.item.tool.ItemSwordRF;
import cofh.redstonearsenal.item.tool.ItemWrenchRF;
import java.util.Locale;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RAEquipment {
    public static final ItemArmor.ArmorMaterial ARMOR_MATERIAL_FLUX = EnumHelper.addArmorMaterial((String)"RA:FLUXELECTRUM", (String)"flux_armor", (int)100, (int[])new int[]{3, 6, 8, 3}, (int)20, (SoundEvent)SoundEvents.field_187725_r, (float)2.0f);
    public static final Item.ToolMaterial TOOL_MATERIAL_FLUX = EnumHelper.addToolMaterial((String)"RA:FLUXELECTRUM", (int)4, (int)100, (float)8.0f, (float)0.0f, (int)25);

    private RAEquipment() {
    }

    public static boolean preInit() {
        for (ArmorSet armorSet : ArmorSet.values()) {
            armorSet.preInit();
            RedstoneArsenal.proxy.addIModelRegister(armorSet);
        }
        for (Enum enum_ : ToolSet.values()) {
            ((ToolSet)enum_).preInit();
            RedstoneArsenal.proxy.addIModelRegister((IModelRegister)enum_);
        }
        return true;
    }

    public static boolean initialize() {
        for (ArmorSet armorSet : ArmorSet.values()) {
            armorSet.initialize();
        }
        for (Enum enum_ : ToolSet.values()) {
            ((ToolSet)enum_).initialize();
        }
        return true;
    }

    public static boolean postInit() {
        return true;
    }

    public static enum ToolSet implements IModelRegister
    {
        FLUX("flux", TOOL_MATERIAL_FLUX);

        private final String name;
        private final Item.ToolMaterial TOOL_MATERIAL;
        private float arrowDamage = 1.5f;
        private float arrowSpeed = 0.5f;
        private float zoomMultiplier = 0.35f;
        private int luckModifier = 1;
        private int speedModifier = 1;
        public ItemWrenchRF itemWrench;
        public ItemBattleWrenchRF itemBattleWrench;
        public ItemSwordRF itemSword;
        public ItemShovelRF itemShovel;
        public ItemPickaxeRF itemPickaxe;
        public ItemAxeRF itemAxe;
        public ItemBowRF itemBow;
        public ItemFishingRodRF itemFishingRod;
        public ItemSickleRF itemSickle;
        public ItemHammerRF itemHammer;
        public ItemShieldRF itemShield;
        public ItemStack toolWrench;
        public ItemStack toolBattleWrench;
        public ItemStack toolSword;
        public ItemStack toolShovel;
        public ItemStack toolPickaxe;
        public ItemStack toolAxe;
        public ItemStack toolBow;
        public ItemStack toolFishingRod;
        public ItemStack toolSickle;
        public ItemStack toolHammer;
        public ItemStack toolShield;
        public boolean[] enable = new boolean[11];

        private ToolSet(String name, Item.ToolMaterial material) {
            this.name = name.toLowerCase(Locale.US);
            this.TOOL_MATERIAL = material;
        }

        protected void create() {
            this.itemWrench = new ItemWrenchRF(this.TOOL_MATERIAL);
            this.itemBattleWrench = new ItemBattleWrenchRF(this.TOOL_MATERIAL);
            this.itemSword = new ItemSwordRF(this.TOOL_MATERIAL);
            this.itemShovel = new ItemShovelRF(this.TOOL_MATERIAL);
            this.itemPickaxe = new ItemPickaxeRF(this.TOOL_MATERIAL);
            this.itemAxe = new ItemAxeRF(this.TOOL_MATERIAL);
            this.itemBow = new ItemBowRF(this.TOOL_MATERIAL);
            this.itemFishingRod = new ItemFishingRodRF(this.TOOL_MATERIAL);
            this.itemSickle = new ItemSickleRF(this.TOOL_MATERIAL);
            this.itemHammer = new ItemHammerRF(this.TOOL_MATERIAL);
            this.itemShield = new ItemShieldRF(this.TOOL_MATERIAL);
        }

        protected void preInit() {
            String TOOL = "redstonearsenal.tool." + this.name;
            String category = "Equipment.Tools." + StringHelper.titleCase((String)this.name);
            this.enable[0] = RedstoneArsenal.CONFIG.getConfiguration().get(category, "Wrench", true).getBoolean(true);
            this.enable[1] = RedstoneArsenal.CONFIG.getConfiguration().get(category, "BattleWrench", true).getBoolean(true);
            this.enable[2] = RedstoneArsenal.CONFIG.getConfiguration().get(category, "Sword", true).getBoolean(true);
            this.enable[3] = RedstoneArsenal.CONFIG.getConfiguration().get(category, "Shovel", true).getBoolean(true);
            this.enable[4] = RedstoneArsenal.CONFIG.getConfiguration().get(category, "Pickaxe", true).getBoolean(true);
            this.enable[5] = RedstoneArsenal.CONFIG.getConfiguration().get(category, "Axe", true).getBoolean(true);
            this.enable[6] = RedstoneArsenal.CONFIG.getConfiguration().get(category, "Bow", true).getBoolean(true);
            this.enable[7] = RedstoneArsenal.CONFIG.getConfiguration().get(category, "FishingRod", true).getBoolean(true);
            this.enable[8] = RedstoneArsenal.CONFIG.getConfiguration().get(category, "Sickle", true).getBoolean(true);
            this.enable[9] = RedstoneArsenal.CONFIG.getConfiguration().get(category, "Hammer", true).getBoolean(true);
            this.enable[10] = RedstoneArsenal.CONFIG.getConfiguration().get(category, "Shield", true).getBoolean(true);
            this.create();
            this.itemWrench.func_77655_b(TOOL + "Wrench").func_77637_a(RedstoneArsenal.tabCommon);
            this.itemWrench.setShowInCreative(this.enable[0]);
            this.itemWrench.setRegistryName("tool.wrench_" + this.name);
            GameRegistry.register((IForgeRegistryEntry)this.itemWrench);
            this.itemBattleWrench.func_77655_b(TOOL + "BattleWrench").func_77637_a(RedstoneArsenal.tabCommon);
            this.itemBattleWrench.setShowInCreative(this.enable[1]);
            this.itemBattleWrench.setRegistryName("tool.battlewrench_" + this.name);
            GameRegistry.register((IForgeRegistryEntry)this.itemBattleWrench);
            this.itemSword.func_77655_b(TOOL + "Sword").func_77637_a(RedstoneArsenal.tabCommon);
            this.itemSword.setShowInCreative(this.enable[2]);
            this.itemSword.setRegistryName("tool.sword_" + this.name);
            GameRegistry.register((IForgeRegistryEntry)this.itemSword);
            this.itemShovel.func_77655_b(TOOL + "Shovel").func_77637_a(RedstoneArsenal.tabCommon);
            this.itemShovel.setShowInCreative(this.enable[3]);
            this.itemShovel.setRegistryName("tool.shovel_" + this.name);
            GameRegistry.register((IForgeRegistryEntry)this.itemShovel);
            this.itemPickaxe.func_77655_b(TOOL + "Pickaxe").func_77637_a(RedstoneArsenal.tabCommon);
            this.itemPickaxe.setShowInCreative(this.enable[4]);
            this.itemPickaxe.setRegistryName("tool.pickaxe_" + this.name);
            GameRegistry.register((IForgeRegistryEntry)this.itemPickaxe);
            this.itemAxe.func_77655_b(TOOL + "Axe").func_77637_a(RedstoneArsenal.tabCommon);
            this.itemAxe.setShowInCreative(this.enable[5]);
            this.itemAxe.setRegistryName("tool.axe_" + this.name);
            GameRegistry.register((IForgeRegistryEntry)this.itemAxe);
            this.itemBow.func_77655_b(TOOL + "Bow").func_77637_a(RedstoneArsenal.tabCommon);
            this.itemBow.setArrowDamage(this.arrowDamage).setArrowSpeed(this.arrowSpeed).setZoomMultiplier(this.zoomMultiplier);
            this.itemBow.setShowInCreative(this.enable[6]);
            this.itemBow.setRegistryName("tool.bow_" + this.name);
            GameRegistry.register((IForgeRegistryEntry)this.itemBow);
            this.itemFishingRod.func_77655_b(TOOL + "FishingRod").func_77637_a(RedstoneArsenal.tabCommon);
            this.itemFishingRod.setLuckModifier(this.luckModifier).setSpeedModifier(this.speedModifier);
            this.itemFishingRod.setShowInCreative(this.enable[7]);
            this.itemFishingRod.setRegistryName("tool.fishing_rod_" + this.name);
            GameRegistry.register((IForgeRegistryEntry)this.itemFishingRod);
            this.itemSickle.func_77655_b(TOOL + "Sickle").func_77637_a(RedstoneArsenal.tabCommon);
            this.itemSickle.setShowInCreative(this.enable[8]);
            this.itemSickle.setRegistryName("tool.sickle_" + this.name);
            GameRegistry.register((IForgeRegistryEntry)this.itemSickle);
            this.itemHammer.func_77655_b(TOOL + "Hammer").func_77637_a(RedstoneArsenal.tabCommon);
            this.itemHammer.setShowInCreative(this.enable[9]);
            this.itemHammer.setRegistryName("tool.hammer_" + this.name);
            GameRegistry.register((IForgeRegistryEntry)this.itemHammer);
            this.itemShield.func_77655_b(TOOL + "Shield").func_77637_a(RedstoneArsenal.tabCommon);
            this.itemShield.setShowInCreative(this.enable[10]);
            this.itemShield.setRegistryName("tool.shield_" + this.name);
            GameRegistry.register((IForgeRegistryEntry)this.itemShield);
            this.toolWrench = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemWrench), (int)0);
            this.toolBattleWrench = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemBattleWrench), (int)0);
            this.toolSword = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemSword), (int)0);
            this.toolShovel = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemShovel), (int)0);
            this.toolPickaxe = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemPickaxe), (int)0);
            this.toolAxe = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemAxe), (int)0);
            this.toolBow = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemBow), (int)0);
            this.toolFishingRod = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemFishingRod), (int)0);
            this.toolSickle = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemSickle), (int)0);
            this.toolHammer = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemHammer), (int)0);
            this.toolShield = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemShield), (int)0);
        }

        protected void initialize() {
            if (this.enable[0]) {
                ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolWrench, (Object[])new Object[]{"I I", " R ", " I ", Character.valueOf('I'), "ingotElectrumFlux", Character.valueOf('R'), ItemMaterial.rodObsidianFlux}));
            }
            if (this.enable[1]) {
                ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolBattleWrench, (Object[])new Object[]{"I I", " G ", " R ", Character.valueOf('I'), "ingotElectrumFlux", Character.valueOf('G'), "gearElectrumFlux", Character.valueOf('R'), ItemMaterial.rodObsidianFlux}));
            }
            if (this.enable[2]) {
                ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolSword, (Object[])new Object[]{" I ", " I ", " R ", Character.valueOf('I'), "ingotElectrumFlux", Character.valueOf('R'), ItemMaterial.rodObsidianFlux}));
            }
            if (this.enable[3]) {
                ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolShovel, (Object[])new Object[]{" I ", " R ", " R ", Character.valueOf('I'), "ingotElectrumFlux", Character.valueOf('R'), ItemMaterial.rodObsidianFlux}));
            }
            if (this.enable[4]) {
                ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolPickaxe, (Object[])new Object[]{"III", " R ", " R ", Character.valueOf('I'), "ingotElectrumFlux", Character.valueOf('R'), ItemMaterial.rodObsidianFlux}));
            }
            if (this.enable[5]) {
                ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolAxe, (Object[])new Object[]{"II ", "IR ", " R ", Character.valueOf('I'), "ingotElectrumFlux", Character.valueOf('R'), ItemMaterial.rodObsidianFlux}));
            }
            if (this.enable[6]) {
                ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolBow, (Object[])new Object[]{" IS", "R S", " IS", Character.valueOf('I'), "ingotElectrumFlux", Character.valueOf('R'), ItemMaterial.rodObsidianFlux, Character.valueOf('S'), Items.field_151007_F}));
            }
            if (this.enable[7]) {
                ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolFishingRod, (Object[])new Object[]{"  I", " IS", "R S", Character.valueOf('I'), "ingotElectrumFlux", Character.valueOf('R'), ItemMaterial.rodObsidianFlux, Character.valueOf('S'), Items.field_151007_F}));
            }
            if (this.enable[8]) {
                ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolSickle, (Object[])new Object[]{" I ", "  I", "RI ", Character.valueOf('I'), "ingotElectrumFlux", Character.valueOf('R'), ItemMaterial.rodObsidianFlux}));
            }
            if (this.enable[9]) {
                ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolHammer, (Object[])new Object[]{"III", "IRI", " R ", Character.valueOf('I'), "ingotElectrumFlux", Character.valueOf('R'), ItemMaterial.rodObsidianFlux}));
            }
            if (this.enable[10]) {
                ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.toolShield, (Object[])new Object[]{"IRI", "III", " I ", Character.valueOf('I'), "ingotElectrumFlux", Character.valueOf('R'), "gemCrystalFlux"}));
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void registerModel(Item item, String stackName) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("redstonearsenal:tool/" + stackName, "inventory"));
        }

        @SideOnly(value=Side.CLIENT)
        public void registerModels() {
            this.registerModel((Item)this.itemWrench, "wrench_" + this.name);
            this.registerModel((Item)this.itemBattleWrench, "battle_wrench_" + this.name);
            this.registerModel((Item)this.itemSword, "sword_" + this.name);
            this.registerModel((Item)this.itemShovel, "shovel_" + this.name);
            this.registerModel((Item)this.itemPickaxe, "pickaxe_" + this.name);
            this.registerModel((Item)this.itemAxe, "axe_" + this.name);
            this.registerModel((Item)this.itemBow, "bow_" + this.name);
            this.registerModel((Item)this.itemFishingRod, "fishing_rod_" + this.name);
            this.registerModel((Item)this.itemSickle, "sickle_" + this.name);
            this.registerModel((Item)this.itemHammer, "hammer_" + this.name);
            this.registerModel((Item)this.itemShield, "shield_" + this.name);
        }
    }

    public static enum ArmorSet implements IModelRegister
    {
        FLUX("flux", ARMOR_MATERIAL_FLUX);

        private final String name;
        private final ItemArmor.ArmorMaterial ARMOR_MATERIAL;
        public ItemArmorRF itemHelmet;
        public ItemArmorRF itemPlate;
        public ItemArmorRF itemLegs;
        public ItemArmorRF itemBoots;
        public ItemStack armorHelmet;
        public ItemStack armorPlate;
        public ItemStack armorLegs;
        public ItemStack armorBoots;
        public boolean[] enable = new boolean[4];

        private ArmorSet(String name, ItemArmor.ArmorMaterial material) {
            this.name = name.toLowerCase(Locale.US);
            this.ARMOR_MATERIAL = material;
        }

        protected void create() {
            this.itemHelmet = new ItemArmorRF(this.ARMOR_MATERIAL, EntityEquipmentSlot.HEAD);
            this.itemPlate = new ItemArmorRF(this.ARMOR_MATERIAL, EntityEquipmentSlot.CHEST);
            this.itemLegs = new ItemArmorRF(this.ARMOR_MATERIAL, EntityEquipmentSlot.LEGS);
            this.itemBoots = new ItemArmorRF(this.ARMOR_MATERIAL, EntityEquipmentSlot.FEET);
        }

        protected void preInit() {
            String ARMOR = "redstonearsenal.armor." + this.name;
            String PATH_ARMOR = "redstonearsenal:textures/armor/";
            String[] TEXTURE = new String[]{"redstonearsenal:textures/armor/" + this.name + "_1.png", "redstonearsenal:textures/armor/" + this.name + "_2.png"};
            String category = "Equipment.Armor." + StringHelper.titleCase((String)this.name);
            this.enable[0] = RedstoneArsenal.CONFIG.getConfiguration().get(category, "Helmet", true).getBoolean(true);
            this.enable[1] = RedstoneArsenal.CONFIG.getConfiguration().get(category, "Chestplate", true).getBoolean(true);
            this.enable[2] = RedstoneArsenal.CONFIG.getConfiguration().get(category, "Leggings", true).getBoolean(true);
            this.enable[3] = RedstoneArsenal.CONFIG.getConfiguration().get(category, "Boots", true).getBoolean(true);
            this.create();
            this.itemHelmet.setArmorTextures(TEXTURE).func_77655_b(ARMOR + "Helmet").func_77637_a(RedstoneArsenal.tabCommon);
            this.itemHelmet.setShowInCreative(this.enable[0]);
            this.itemHelmet.setRegistryName("armor.helmet_" + this.name);
            GameRegistry.register((IForgeRegistryEntry)this.itemHelmet);
            this.itemPlate.setArmorTextures(TEXTURE).func_77655_b(ARMOR + "Plate").func_77637_a(RedstoneArsenal.tabCommon);
            this.itemPlate.setShowInCreative(this.enable[1]);
            this.itemPlate.setRegistryName("armor.plate_" + this.name);
            GameRegistry.register((IForgeRegistryEntry)this.itemPlate);
            this.itemLegs.setArmorTextures(TEXTURE).func_77655_b(ARMOR + "Legs").func_77637_a(RedstoneArsenal.tabCommon);
            this.itemLegs.setShowInCreative(this.enable[2]);
            this.itemLegs.setRegistryName("armor.legs_" + this.name);
            GameRegistry.register((IForgeRegistryEntry)this.itemLegs);
            this.itemBoots.setArmorTextures(TEXTURE).func_77655_b(ARMOR + "Boots").func_77637_a(RedstoneArsenal.tabCommon);
            this.itemBoots.setShowInCreative(this.enable[3]);
            this.itemBoots.setRegistryName("armor.boots_" + this.name);
            GameRegistry.register((IForgeRegistryEntry)this.itemBoots);
            this.armorHelmet = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemHelmet), (int)0);
            this.armorPlate = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemPlate), (int)0);
            this.armorLegs = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemLegs), (int)0);
            this.armorBoots = EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this.itemBoots), (int)0);
        }

        protected void initialize() {
            if (this.enable[0]) {
                ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.armorHelmet, (Object[])new Object[]{"III", "I I", Character.valueOf('I'), ItemMaterial.plateFlux}));
            }
            if (this.enable[1]) {
                ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.armorPlate, (Object[])new Object[]{"I I", "III", "III", Character.valueOf('I'), ItemMaterial.plateFlux}));
            }
            if (this.enable[2]) {
                ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.armorLegs, (Object[])new Object[]{"III", "I I", "I I", Character.valueOf('I'), ItemMaterial.plateFlux}));
            }
            if (this.enable[3]) {
                ItemHelper.addRecipe((IRecipe)ItemHelper.ShapedRecipe((ItemStack)this.armorBoots, (Object[])new Object[]{"I I", "I I", Character.valueOf('I'), ItemMaterial.plateFlux}));
            }
        }

        @SideOnly(value=Side.CLIENT)
        public void registerModel(Item item, String stackName) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("redstonearsenal:armor", "type=" + stackName));
        }

        @SideOnly(value=Side.CLIENT)
        public void registerModels() {
            this.registerModel((Item)this.itemHelmet, "helmet_" + this.name);
            this.registerModel((Item)this.itemPlate, "chestplate_" + this.name);
            this.registerModel((Item)this.itemLegs, "leggings_" + this.name);
            this.registerModel((Item)this.itemBoots, "boots_" + this.name);
        }
    }
}

