/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.network;

import io.netty.buffer.ByteBuf;
import java.util.Collection;
import net.malisis.advert.MalisisAdvert;
import net.malisis.advert.advert.Advert;
import net.malisis.advert.advert.ClientAdvert;
import net.malisis.advert.advert.ServerAdvert;
import net.malisis.core.network.IMalisisMessageHandler;
import net.malisis.core.network.MalisisMessage;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

@MalisisMessage
public class AdvertListMessage
implements IMalisisMessageHandler<IMessage, IMessage> {
    public AdvertListMessage() {
        MalisisAdvert.network.registerMessage((IMessageHandler)this, Query.class, Side.SERVER);
        MalisisAdvert.network.registerMessage((IMessageHandler)this, Response.class, Side.CLIENT);
    }

    public void process(IMessage message, MessageContext ctx) {
        if (message instanceof Query && ctx.side == Side.SERVER) {
            ServerAdvert.readListing();
            AdvertListMessage.sendList(ctx.getServerHandler().field_147369_b);
        }
        if (message instanceof Response && ctx.side == Side.CLIENT) {
            ClientAdvert.setAdvertList((ClientAdvert[])((Response)message).ads);
        }
    }

    public static void queryList() {
        MalisisAdvert.network.sendToServer((IMessage)new Query());
    }

    public static void sendList(EntityPlayerMP player) {
        MalisisAdvert.network.sendTo((IMessage)new Response(ServerAdvert.listAdverts()), player);
    }

    public static void sendAdvert(ServerAdvert advert) {
        MalisisAdvert.network.sendToAll((IMessage)new Response(advert));
    }

    public static class Query
    implements IMessage {
        public void fromBytes(ByteBuf buf) {
        }

        public void toBytes(ByteBuf buf) {
        }
    }

    public static class Response
    implements IMessage {
        private Advert[] ads;

        public Response() {
        }

        public Response(Collection<ServerAdvert> listAdverts) {
            this.ads = listAdverts.toArray(new ServerAdvert[0]);
        }

        public Response(ServerAdvert advert) {
            this.ads = new ServerAdvert[]{advert};
        }

        public void fromBytes(ByteBuf buf) {
            int count = buf.readInt();
            this.ads = new ClientAdvert[count];
            for (int i = 0; i < count; ++i) {
                this.ads[i] = ClientAdvert.fromBytes(buf);
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.ads.length);
            for (Advert advert : this.ads) {
                ((ServerAdvert)advert).toBytes(buf);
            }
        }
    }
}

