/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.network;

import io.netty.buffer.ByteBuf;
import net.malisis.advert.MalisisAdvert;
import net.malisis.advert.gui.advertselection.AdvertSelectionGui;
import net.malisis.advert.gui.manager.AdvertManagerGui;
import net.malisis.advert.tileentity.AdvertTileEntity;
import net.malisis.core.network.IMalisisMessageHandler;
import net.malisis.core.network.MalisisMessage;
import net.malisis.core.util.TileEntityUtils;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

@MalisisMessage
public class AdvertGuiMessage
implements IMalisisMessageHandler<Packet, IMessage> {
    public static int ADVERTMANAGER = 1;
    public static int ADVERTSELECTION = 2;

    public AdvertGuiMessage() {
        MalisisAdvert.network.registerMessage((IMessageHandler)this, Packet.class, Side.CLIENT);
    }

    public void process(Packet message, MessageContext ctx) {
        AdvertTileEntity tileEntity;
        if (message.type == ADVERTMANAGER) {
            new AdvertManagerGui().display();
        }
        if (message.type == ADVERTSELECTION && (tileEntity = (AdvertTileEntity)((Object)TileEntityUtils.getTileEntity(AdvertTileEntity.class, (IBlockAccess)IMalisisMessageHandler.getWorld((MessageContext)ctx), (BlockPos)message.pos))) != null) {
            new AdvertSelectionGui(tileEntity).display();
        }
    }

    public static void openManager(EntityPlayerMP player) {
        MalisisAdvert.network.sendTo((IMessage)new Packet(ADVERTMANAGER, null), player);
    }

    public static void openSelection(EntityPlayerMP player, AdvertTileEntity tileEntity) {
        MalisisAdvert.network.sendTo((IMessage)new Packet(ADVERTSELECTION, tileEntity), player);
    }

    public static class Packet
    implements IMessage {
        private int type;
        private BlockPos pos;

        public Packet() {
        }

        public Packet(int type, AdvertTileEntity tileEntity) {
            this.type = type;
            if (type == ADVERTMANAGER) {
                return;
            }
            this.pos = tileEntity.func_174877_v();
        }

        public void fromBytes(ByteBuf buf) {
            this.type = buf.readInt();
            if (this.type == ADVERTMANAGER) {
                return;
            }
            this.pos = BlockPos.func_177969_a((long)buf.readLong());
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.type);
            if (this.type == ADVERTMANAGER) {
                return;
            }
            buf.writeLong(this.pos.func_177986_g());
        }
    }
}

