/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.network;

import com.google.common.io.Files;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import net.malisis.advert.MalisisAdvert;
import net.malisis.advert.advert.Advert;
import net.malisis.advert.advert.ClientAdvert;
import net.malisis.advert.advert.ServerAdvert;
import net.malisis.core.network.IMalisisMessageHandler;
import net.malisis.core.network.MalisisMessage;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

@MalisisMessage
public class AdvertDownloadMessage
implements IMalisisMessageHandler<IMessage, IMessage> {
    public AdvertDownloadMessage() {
        MalisisAdvert.network.registerMessage((IMessageHandler)this, Query.class, Side.SERVER);
        MalisisAdvert.network.registerMessage((IMessageHandler)this, Response.class, Side.CLIENT);
    }

    public void process(IMessage message, MessageContext ctx) {
        if (message instanceof Query && ctx.side == Side.SERVER) {
            this.processQuery((Query)message, ctx);
        }
        if (message instanceof Response && ctx.side == Side.CLIENT) {
            this.processResponse((Response)message, ctx);
        }
    }

    private void processQuery(Query message, MessageContext ctx) {
        ServerAdvert advert = ServerAdvert.get(message.id);
        if (advert == null) {
            return;
        }
        AdvertDownloadMessage.sendImageData(advert, ctx.getServerHandler().field_147369_b);
    }

    private void processResponse(Response message, MessageContext ctx) {
        ClientAdvert.setPending(false);
        ClientAdvert advert = ClientAdvert.get(message.id);
        if (advert == null) {
            return;
        }
        if (message.error != null) {
            advert.setError(message.error);
            return;
        }
        advert.setTexture(message.data, message.size);
    }

    public static void queryDownload(Advert advert) {
        Query packet = new Query(advert);
        MalisisAdvert.network.sendToServer((IMessage)packet);
    }

    public static void sendImageData(ServerAdvert advert, EntityPlayerMP player) {
        if (!(advert.getFile() != null && advert.getFile().exists() || advert.getError() != null)) {
            advert.downloadAdvert(player);
            return;
        }
        Response packet = new Response(advert);
        MalisisAdvert.network.sendTo((IMessage)packet, player);
    }

    public static class Query
    implements IMessage {
        private int id;

        public Query(Advert advert) {
            this.id = advert.getId();
        }

        public Query() {
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
        }
    }

    public static class Response
    implements IMessage {
        private int id;
        private long size;
        private String error;
        private byte[] data = new byte[0];

        public Response(ServerAdvert advert) {
            this.id = advert.getId();
            this.size = advert.getSize();
            if (advert.getError() != null) {
                this.error = advert.getError();
            } else {
                try {
                    this.data = Files.toByteArray((File)advert.getFile());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public Response() {
        }

        public void fromBytes(ByteBuf buf) {
            this.id = buf.readInt();
            this.size = buf.readLong();
            if (buf.readBoolean()) {
                this.error = ByteBufUtils.readUTF8String((ByteBuf)buf);
            } else {
                this.data = new byte[buf.readableBytes()];
                buf.readBytes(this.data);
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.id);
            buf.writeLong(this.size);
            buf.writeBoolean(this.error != null);
            if (this.error != null) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.error);
            } else {
                buf.writeBytes(this.data);
            }
        }
    }
}

