/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.model;

import net.malisis.advert.model.AdvertModel;
import net.malisis.advert.renderer.AdvertRenderer;
import net.malisis.advert.tileentity.AdvertTileEntity;
import net.malisis.core.MalisisCore;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.AnimationRenderer;
import net.malisis.core.renderer.animation.transformation.ChainedTransformation;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.animation.transformation.Rotation;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.icon.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BillboardModel
extends AdvertModel<AdvertModel.IModelVariant> {
    @SideOnly(value=Side.CLIENT)
    private Icon boardIcon;
    @SideOnly(value=Side.CLIENT)
    private Icon platformIcon;
    private Shape foot;
    private Shape billboard;
    private Shape platform;
    private ShiftedRotations transform;
    private AnimationRenderer ar;

    public BillboardModel() {
        this.name = this.id = "billboard";
        this.availableSlots = 3;
        float border = 0.125f;
        this.width = 10.0f - 2.0f * border;
        this.height = 5.0f - 2.0f * border;
        this.objFile = new ResourceLocation("malisisadvert", "models/billboard.obj");
        this.placeHolder = new ResourceLocation("malisisadvert", "textures/blocks/MA105.png");
        if (MalisisCore.isClient()) {
            this.boardIcon = Icon.from((String)"malisisadvert:blocks/board");
            this.platformIcon = Icon.from((String)"malisisadvert:blocks/platform");
        }
    }

    @Override
    public void loadModelFile() {
        super.loadModelFile();
        this.foot = this.model.getShape("Foot");
        this.billboard = this.model.getShape("Board");
        this.platform = this.model.getShape("Platform");
        this.ar = new AnimationRenderer();
        int speed = 20;
        int delay = 100;
        Rotation r1 = (Rotation)((Rotation)new Rotation(0.0f, -120.0f).aroundAxis(0.0f, 1.0f, 0.0f).forTicks(speed, delay)).movement(1);
        Rotation r2 = (Rotation)((Rotation)new Rotation(-120.0f, -240.0f).aroundAxis(0.0f, 1.0f, 0.0f).forTicks(speed, delay)).movement(1);
        Rotation r3 = (Rotation)((Rotation)new Rotation(-240.0f, -360.0f).aroundAxis(0.0f, 1.0f, 0.0f).forTicks(speed, delay)).movement(1);
        this.transform = new ShiftedRotations(r1, r2, r3);
        this.transform.loop(-1);
    }

    @Override
    public AdvertModel.IModelVariant defaultVariant(boolean wallMounted) {
        return null;
    }

    @Override
    public AxisAlignedBB[] getBoundingBox(AdvertModel.IModelVariant variant) {
        AxisAlignedBB foot = new AxisAlignedBB(0.125, 0.0, 0.25, 0.875, 5.0, 0.75);
        AxisAlignedBB billboard = new AxisAlignedBB(-4.5, 5.0, 0.125, 5.5, 10.0, 0.875);
        AxisAlignedBB platform = new AxisAlignedBB(-4.5, 5.0625, 0.875, 5.5, 5.125, 1.6875);
        return new AxisAlignedBB[]{foot, billboard, platform};
    }

    @Override
    public int getGuiComponent(MalisisGui gui, UIContainer<?> container, AdvertModel.IModelVariant variant, boolean wallMounted) {
        return 0;
    }

    @Override
    public AdvertModel.IModelVariant getVariantFromGui(UIContainer<?> container) {
        return null;
    }

    @Override
    public void renderBlock(AdvertRenderer renderer, AdvertTileEntity tileEntity, RenderParameters rp, AdvertModel.IModelVariant variant) {
        this.loadModelFile();
        rp.icon.set((Object)this.boardIcon);
        renderer.drawShape(this.foot, rp);
        renderer.drawShape(this.billboard, rp);
        rp.icon.set((Object)this.platformIcon);
        renderer.drawShape(this.platform, rp);
    }

    @Override
    public void renderTileEntity(AdvertRenderer renderer, AdvertTileEntity tileEntity, RenderParameters rp, AdvertModel.IModelVariant variant) {
        if (tileEntity.getSelection(1) == null && tileEntity.getSelection(2) == null) {
            Shape s = this.model.getShape("Plane");
            s.applyMatrix();
            renderer.renderAdvertFace(s.getFaces()[0], tileEntity.getSelection(0));
            return;
        }
        for (int i = 0; i <= 19; ++i) {
            Shape s = this.model.getShape("Prism" + i);
            this.ar.animate((ITransformable)s, (Transformation)this.transform.shift(i));
            s.applyMatrix();
            for (int f = 0; f < 3; ++f) {
                renderer.renderAdvertFace(s.getFaces()[f], tileEntity.getSelection(2 - f));
            }
        }
    }

    public class ShiftedRotations
    extends ChainedTransformation {
        private float shift;
        private float first;

        public ShiftedRotations(Rotation ... rotations) {
            super(new Transformation[0]);
            this.shift = 0.48f;
            this.first = -4.55463f;
            this.addTransformations((Transformation[])rotations);
        }

        public ShiftedRotations shift(int n) {
            for (Transformation r : this.listTransformations) {
                ((Rotation)r).offset(this.first + this.shift * (float)n, 0.0f, 0.16895998f).delay(100);
            }
            return this;
        }
    }
}

