/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.gui.manager;

import com.google.common.eventbus.Subscribe;
import net.malisis.advert.advert.ClientAdvert;
import net.malisis.advert.gui.AdvertView;
import net.malisis.advert.gui.manager.AdvertForm;
import net.malisis.advert.gui.manager.AdvertList;
import net.malisis.advert.network.AdvertDeleteMessage;
import net.malisis.advert.network.AdvertSaveMessage;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.ComponentPosition;
import net.malisis.core.client.gui.GuiTexture;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.container.UIListContainer;
import net.malisis.core.client.gui.component.container.UIPanel;
import net.malisis.core.client.gui.component.container.UITabGroup;
import net.malisis.core.client.gui.component.container.UIWindow;
import net.malisis.core.client.gui.component.decoration.UIImage;
import net.malisis.core.client.gui.component.interaction.UIButton;
import net.malisis.core.client.gui.component.interaction.UITab;
import net.malisis.core.renderer.icon.GuiIcon;
import net.malisis.core.renderer.icon.Icon;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;

public class AdvertManagerGui
extends MalisisGui {
    public static ResourceLocation iconsRl = new ResourceLocation("malisisadvert", "textures/gui/advertmanager.png");
    public static GuiTexture icons = new GuiTexture(iconsRl, 96, 96);
    public static GuiIcon addIcon = icons.getIcon(0, 0, 32, 32);
    public static GuiIcon refreshIcon = icons.getIcon(64, 0, 32, 32);
    public static GuiIcon editIcon = icons.getIcon(0, 32, 32, 32);
    public static GuiIcon viewIcon = icons.getIcon(32, 32, 32, 32);
    public static ClientAdvert advert;
    private AdvertList advertList;
    private UITabGroup tabs;
    private UIPanel formCont;
    private AdvertForm advertForm;
    private AdvertView advertView;
    private UIContainer<?> advertViewCont;
    private UITab tabEdit;
    private UITab tabView;
    private int width = 400;
    private int height = 250;

    public void construct() {
        UIImage imgRefresh = new UIImage((MalisisGui)this, icons, (Icon)refreshIcon).setSize(10, 10);
        UIImage imgAdd = new UIImage((MalisisGui)this, icons, (Icon)addIcon).setSize(10, 10);
        UIButton btnAdd = (UIButton)((UIButton)new UIButton((MalisisGui)this, imgAdd).setPosition(0, 0, Anchor.RIGHT)).setSize(16, 16).register((Object)this);
        btnAdd.setName("advertAdd");
        btnAdd.setTooltip("malisisadvert.gui.add");
        UIButton btnRefresh = (UIButton)((UIButton)new UIButton((MalisisGui)this, imgRefresh).setPosition(-17, 0, Anchor.RIGHT)).setSize(16, 16).register((Object)this);
        btnRefresh.setName("listRefresh");
        btnRefresh.setTooltip("malisisadvert.gui.refresh");
        this.advertList = (AdvertList)new AdvertList(this, 0, this.height - 60).register((Object)this);
        this.advertList.setPosition(0, 20);
        this.advertList.setElementSpacing(1);
        this.advertList.setElements(ClientAdvert.listAdverts());
        this.createForm();
        UIButton btnClose = (UIButton)((UIButton)new UIButton((MalisisGui)this, "malisisadvert.gui.close").setPosition(0, 0, Anchor.BOTTOM | Anchor.CENTER)).register((Object)this);
        btnClose.setName("close");
        UIWindow window = new UIWindow((MalisisGui)this, "malisisadvert.gui.advertmanager", this.width, 250);
        UIImage imgEdit = new UIImage((MalisisGui)this, icons, (Icon)editIcon).setSize(10, 10);
        UIImage imgView = new UIImage((MalisisGui)this, icons, (Icon)viewIcon).setSize(10, 10);
        this.tabs = new UITabGroup((MalisisGui)this, ComponentPosition.RIGHT);
        this.tabView = this.tabs.addTab(new UITab((MalisisGui)this, imgView), this.advertViewCont);
        this.tabEdit = this.tabs.addTab(new UITab((MalisisGui)this, imgEdit), (UIContainer)this.advertForm);
        this.tabs.attachTo((UIContainer)this.formCont, true);
        this.tabs.setActiveTab(this.tabView);
        this.tabs.setVisible(false);
        window.add(new UIComponent[]{this.advertList, this.tabs, this.formCont, btnAdd, btnRefresh, btnClose});
        this.addToScreen((UIComponent)window);
        advert = null;
    }

    private void createForm() {
        this.advertForm = new AdvertForm(this);
        this.advertView = new AdvertView(this, false);
        this.advertViewCont = new UIContainer((MalisisGui)this);
        this.advertViewCont.add(new UIComponent[]{this.advertView});
        this.formCont = new UIPanel((MalisisGui)this);
        ((UIPanel)this.formCont.setSize(this.width / 2 - 8, this.height - 60)).setPosition(0, 20, Anchor.RIGHT);
        this.formCont.setVisible(false);
        this.formCont.add(new UIComponent[]{this.advertForm, this.advertViewCont});
    }

    @Subscribe
    public void onButtonClick(UIButton.ClickEvent event) {
        if (event.isFrom("advertAdd")) {
            this.showForm(true);
            this.selectAdvert(null);
        } else if (event.isFrom("advertSave")) {
            String name = this.advertForm.getName();
            String url = this.advertForm.getUrl();
            if (StringUtils.isEmpty((CharSequence)name) || StringUtils.isEmpty((CharSequence)url)) {
                return;
            }
            if (advert == null) {
                advert = new ClientAdvert(0);
            }
            advert.setInfos(name, url);
            AdvertSaveMessage.save(advert);
            if (advert.getId() != 0) {
                this.selectAdvert(advert);
            } else {
                this.showForm(false);
            }
        } else if (event.isFrom("advertDelete")) {
            if (advert != null) {
                AdvertDeleteMessage.queryDelete(advert);
            }
            this.showForm(false);
            this.selectAdvert(null);
        } else if (event.isFrom("listRefresh")) {
            ClientAdvert.queryAdvertList();
        }
        if (event.isFrom("close")) {
            this.close();
        }
    }

    @Subscribe
    public void onAdvertSelect(UIListContainer.SelectEvent<AdvertList, ClientAdvert> event) {
        this.showForm(event.getSelected() != null);
        this.selectAdvert((ClientAdvert)event.getSelected());
    }

    private void showForm(boolean show) {
        this.formCont.setVisible(show);
        this.tabs.setVisible(show);
        this.advertList.setSize(show ? this.width / 2 - 7 : 0, this.advertList.getHeight());
    }

    public void selectAdvert(ClientAdvert advert) {
        this.setViewTab(advert != null);
        AdvertManagerGui.advert = advert;
        this.advertForm.fillForm(advert);
        this.advertView.setAdvert(advert);
        this.advertList.setSelected(advert);
    }

    public void setViewTab(boolean b) {
        this.tabs.setActiveTab(b ? this.tabView : this.tabEdit);
    }
}

