/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.gui.manager;

import net.malisis.advert.advert.ClientAdvert;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIListContainer;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.renderer.font.FontOptions;
import net.malisis.core.renderer.font.MalisisFont;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.io.FileUtils;
import org.lwjgl.opengl.GL11;

public class AdvertList
extends UIListContainer<AdvertList, ClientAdvert> {
    private MalisisFont font = MalisisFont.minecraftFont;
    private FontOptions nameOptions = FontOptions.builder().color(0xFFFFFF).shadow().build();
    private FontOptions nameHoverOptions = FontOptions.builder().color(0xFFFF99).shadow().build();
    private FontOptions fontOptions = FontOptions.builder().scale(0.6666667f).color(0x444444).build();
    private FontOptions hoverFontOptions = FontOptions.builder().scale(0.6666667f).color(0x666666).build();
    private UILabel emptyLabel;

    public AdvertList(MalisisGui gui) {
        super(gui);
        this.emptyLabel = new UILabel(gui);
        this.emptyLabel.setParent((UIComponent)this);
    }

    public AdvertList(MalisisGui gui, int width, int height) {
        this(gui);
        this.setSize(width, height);
    }

    public int getElementHeight(ClientAdvert element) {
        return 20;
    }

    public void drawEmpty(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.emptyLabel.setText(TextFormatting.ITALIC + (ClientAdvert.isPending() ? "malisisadvert.gui.querylist" : "malisisadvert.gui.noad"));
        this.emptyLabel.draw(renderer, mouseX, mouseY, partialTick);
    }

    public void drawElementBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick, ClientAdvert advert, boolean isHovered) {
        if (!this.isSelected(advert)) {
            return;
        }
        renderer.disableTextures();
        int color = 0xBBBBEE;
        this.rp.colorMultiplier.set((Object)color);
        this.shape.resetState();
        this.shape.setSize(this.getContentWidth(), this.getElementHeight(advert));
        this.shape.translate(1, 1);
        renderer.drawShape(this.shape, this.rp);
        renderer.next(2);
        GL11.glLineWidth((float)2.0f);
        this.shape.resetState();
        this.shape.setSize(this.getContentWidth(), this.getElementHeight(advert));
        this.shape.translate(1, 1);
        this.rp.colorMultiplier.set((Object)0);
        renderer.drawShape(this.shape, this.rp);
        renderer.next(7);
        renderer.enableTextures();
    }

    public void drawElementForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick, ClientAdvert advert, boolean isHovered) {
        int x = 3;
        renderer.drawText(this.font, advert.getName(), (float)x, 3.0f, 0.0f, isHovered ? this.nameHoverOptions : this.nameOptions);
        x = (int)((float)x + (this.font.getStringWidth(advert.getName(), this.nameOptions) + 6.0f));
        FontOptions options = isHovered ? this.hoverFontOptions : this.fontOptions;
        x = Math.max(70, x);
        String dim = advert.getWidth() + "x" + advert.getHeight();
        renderer.drawText(this.font, dim, (float)x, 6.0f, 0.0f, options);
        x = (int)((float)x + (this.font.getStringWidth(dim, options) + 3.0f));
        String size = FileUtils.byteCountToDisplaySize((long)advert.getSize());
        renderer.drawText(this.font, "(" + size + ")", (float)x, 6.0f, 0.0f, options);
        String url = this.font.clipString(advert.getUrl(), this.getWidth() - 6, options, true);
        renderer.drawText(this.font, url, 3.0f, 14.0f, 0.0f, options);
    }
}

