/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.gui.manager;

import net.malisis.advert.advert.Advert;
import net.malisis.advert.gui.manager.AdvertManagerGui;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.decoration.UIImage;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.client.gui.component.interaction.UIButton;
import net.malisis.core.client.gui.component.interaction.UITextField;
import net.malisis.core.renderer.icon.GuiIcon;
import net.malisis.core.renderer.icon.Icon;

public class AdvertForm
extends UIContainer<AdvertForm> {
    private static GuiIcon deleteIcon = AdvertManagerGui.icons.getIcon(32, 0, 32, 32);
    private static GuiIcon saveIcon = AdvertManagerGui.icons.getIcon(0, 64, 32, 32);
    private UITextField tfName;
    private UITextField tfUrl;

    public AdvertForm(MalisisGui gui) {
        super(gui);
        this.createForm(gui);
        this.createSideButtons(gui);
    }

    private void createForm(MalisisGui gui) {
        UILabel lblName = new UILabel(gui, "malisisadvert.gui.advertname");
        UILabel lblUrl = (UILabel)new UILabel(gui, "malisisadvert.gui.adverturl").setPosition(0, 30);
        this.tfName = ((UITextField)new UITextField(gui, null).setPosition(0, 10)).setSize(-20, 12);
        this.tfUrl = ((UITextField)new UITextField(gui, null).setPosition(0, 40)).setSize(-20, 12);
        this.add(new UIComponent[]{lblName, this.tfName, lblUrl, this.tfUrl});
    }

    private void createSideButtons(MalisisGui gui) {
        UIImage imgDelete = new UIImage(gui, AdvertManagerGui.icons, (Icon)deleteIcon).setSize(10, 10);
        UIImage imgSave = new UIImage(gui, AdvertManagerGui.icons, (Icon)saveIcon).setSize(10, 10);
        int y = 10;
        UIButton btnSave = (UIButton)((UIButton)new UIButton(gui, imgSave).setPosition(0, y, Anchor.RIGHT)).setSize(16, 16).register((Object)gui);
        btnSave.setName("advertSave");
        btnSave.setTooltip("malisisadvert.gui.save");
        UIButton btnDelete = (UIButton)((UIButton)new UIButton(gui, imgDelete).setPosition(0, y + 17, Anchor.RIGHT)).setSize(16, 16).register((Object)gui);
        btnDelete.setName("advertDelete");
        btnDelete.setTooltip("malisisadvert.gui.delete");
        this.add(new UIComponent[]{btnSave, btnDelete});
    }

    public void fillForm(Advert advert) {
        this.tfName.setText(advert != null ? advert.getName() : "");
        this.tfUrl.setText(advert != null ? advert.getUrl() : "");
    }

    public String getName() {
        return this.tfName.getText();
    }

    public String getUrl() {
        return this.tfUrl.getText();
    }
}

