/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.block;

import com.google.common.collect.Lists;
import java.util.List;
import net.malisis.advert.MalisisAdvert;
import net.malisis.advert.network.AdvertGuiMessage;
import net.malisis.advert.renderer.AdvertRenderer;
import net.malisis.advert.tileentity.AdvertTileEntity;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.renderer.DefaultRenderer;
import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.EntityUtils;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.core.util.chunkcollision.IChunkCollidable;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@MalisisRendered(block=AdvertRenderer.class, item=DefaultRenderer.Block.class)
public class AdvertBlock
extends MalisisBlock
implements ITileEntityProvider,
IChunkCollidable {
    public static final PropertyBool WALL = PropertyBool.func_177716_a((String)"wall");

    public AdvertBlock() {
        super(Material.field_151573_f);
        this.func_149752_b(6000.0f);
        this.func_149711_c(6000.0f);
        this.setName("advertBlock");
        this.func_149647_a(MalisisAdvert.tab);
        this.setTexture("malisisadvert:blocks/MA");
        this.addComponent((IComponent)new DirectionalComponent(DirectionalComponent.ALL, (state, side, placer) -> side == EnumFacing.UP ? EntityUtils.getEntityFacing((Entity)placer).func_176734_d() : side));
    }

    protected List<IProperty<?>> getProperties() {
        return Lists.newArrayList((Object[])new IProperty[]{WALL});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, ItemStack itemStack) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, itemStack).func_177226_a((IProperty)WALL, (Comparable)Boolean.valueOf(facing != EnumFacing.UP));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        AdvertTileEntity te = (AdvertTileEntity)((Object)TileEntityUtils.getTileEntity(AdvertTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (te == null) {
            return;
        }
        te.setWallMounted((Boolean)state.func_177229_b((IProperty)WALL));
        te.setModelContainer(null);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        AdvertTileEntity te = (AdvertTileEntity)((Object)TileEntityUtils.getTileEntity(AdvertTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (te == null || !player.func_70003_b(0, "malisisadvert")) {
            return true;
        }
        AdvertGuiMessage.openSelection((EntityPlayerMP)player, te);
        return true;
    }

    public AxisAlignedBB[] getBoundingBoxes(IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        if (type == BoundingBoxType.PLACEDBOUNDINGBOX) {
            return AABBUtils.identities();
        }
        AdvertTileEntity te = (AdvertTileEntity)((Object)TileEntityUtils.getTileEntity(AdvertTileEntity.class, (IBlockAccess)world, (BlockPos)pos));
        if (te == null) {
            return AABBUtils.identities();
        }
        return te.getModelContainer().getBoundingBox();
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new AdvertTileEntity();
    }

    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a((IProperty)WALL, (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    public int func_176201_c(IBlockState state) {
        return super.func_176201_c(state) + ((Boolean)state.func_177229_b((IProperty)WALL) != false ? 8 : 0);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int blockRange() {
        return 5;
    }
}

