/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.advert.advert;

import com.google.common.io.Files;
import io.netty.buffer.ByteBuf;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import net.malisis.advert.MalisisAdvert;
import net.malisis.advert.advert.Advert;
import net.malisis.advert.network.AdvertDownloadMessage;
import net.malisis.advert.network.AdvertListMessage;
import net.malisis.core.client.gui.GuiTexture;
import net.malisis.core.util.Silenced;
import net.malisis.core.util.Timer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.apache.commons.lang3.StringUtils;

public class ClientAdvert
extends Advert {
    private static SortedMap<Integer, ClientAdvert> adverts = new TreeMap<Integer, ClientAdvert>();
    private static boolean pending = false;
    private static Timer timer = new Timer();
    private GuiTexture texture;

    public ClientAdvert(int id) {
        super(id);
    }

    @Override
    public void setHash(String hash) {
        if (StringUtils.equals((CharSequence)this.hash, (CharSequence)hash) && this.texture != null) {
            this.texture.delete();
            this.texture = null;
        }
        super.setHash(hash);
    }

    public GuiTexture getTexture() {
        if (this.texture == null && this.getError() == null) {
            if (this.file != null && this.file.exists()) {
                this.setTexture((byte[])Silenced.get(() -> Files.toByteArray((File)this.file)), this.size);
            } else {
                this.downloadFile();
            }
        }
        return this.texture;
    }

    public void setTexture(byte[] data, long size) {
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(data));
            if (image == null) {
                this.setError("Could not read image.");
                return;
            }
            this.writeFile(data);
            this.texture = new GuiTexture(image, this.name);
            this.size = size;
            this.width = image.getWidth();
            this.height = image.getHeight();
        }
        catch (IOException e) {
            MalisisAdvert.log.error("Could not set the texture for {}", new Object[]{this, e});
            this.setError("Could not read image.");
        }
    }

    @Override
    public void delete() {
        super.delete();
        if (this.texture != null) {
            this.texture.delete();
        }
        adverts.remove(this.id);
    }

    @Override
    public void save() {
        super.save();
        adverts.put(this.id, this);
    }

    @Override
    public void downloadFile() {
        if (ClientAdvert.isPending()) {
            return;
        }
        ClientAdvert.setPending(true);
        AdvertDownloadMessage.queryDownload(this);
    }

    public static ClientAdvert get(int id) {
        return ClientAdvert.get(id, false);
    }

    public static ClientAdvert get(int id, boolean create) {
        ClientAdvert advert = (ClientAdvert)adverts.get(id);
        if (advert == null) {
            if (create) {
                advert = new ClientAdvert(id);
            } else if (!ClientAdvert.isPending()) {
                MalisisAdvert.log.error("Cannot find Advert \"{}\" for client", new Object[]{id});
            }
        }
        return advert;
    }

    public static Collection<ClientAdvert> listAdverts() {
        return adverts.values();
    }

    public static void setPending(boolean b) {
        pending = b;
        if (pending) {
            timer.start();
        }
    }

    public static boolean isPending() {
        if (timer.elapsedTime() > 5000L) {
            pending = false;
        }
        return pending;
    }

    public static void queryAdvertList() {
        if (ClientAdvert.isPending()) {
            return;
        }
        ClientAdvert.setPending(true);
        adverts.clear();
        AdvertListMessage.queryList();
    }

    public static void setAdvertList(ClientAdvert[] ads) {
        for (ClientAdvert advert : ads) {
            adverts.put(advert.getId(), advert);
        }
    }

    public static ClientAdvert fromBytes(ByteBuf buf) {
        int id = buf.readInt();
        ClientAdvert advert = ClientAdvert.get(id, true);
        advert.setInfos(ByteBufUtils.readUTF8String((ByteBuf)buf), ByteBufUtils.readUTF8String((ByteBuf)buf));
        advert.setHash(ByteBufUtils.readUTF8String((ByteBuf)buf));
        advert.setData(buf.readLong(), buf.readInt(), buf.readInt());
        return advert;
    }

    static {
        ClientAdvert.queryAdvertList();
    }
}

