/*
 * Decompiled with CFR 0.152.
 */
package mcmultipart.capabilities;

import java.util.HashSet;
import mcmultipart.capabilities.CapabilityWrapperRegistry;
import mcmultipart.capabilities.ISlottedCapabilityProvider;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.ISlottedPart;
import mcmultipart.multipart.PartSlot;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class MultipartCapabilityHelper {
    public static boolean hasCapability(IMultipartContainer container, Capability<?> capability, EnumFacing side) {
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (face == side || face.func_176734_d() == side || !MultipartCapabilityHelper.hasCapability(container, capability, side, face)) continue;
            return true;
        }
        return MultipartCapabilityHelper.hasCapability(container, capability, side, null);
    }

    public static <T> T getCapability(IMultipartContainer container, Capability<T> capability, EnumFacing side) {
        HashSet<T> implementations = new HashSet<T>();
        for (EnumFacing face : EnumFacing.field_82609_l) {
            T impl;
            if (face == side || face.func_176734_d() == side || (impl = MultipartCapabilityHelper.getCapability(container, capability, side, face)) == null) continue;
            implementations.add(impl);
        }
        T impl = MultipartCapabilityHelper.getCapability(container, capability, side, null);
        if (impl != null) {
            implementations.add(impl);
        }
        if (implementations.isEmpty()) {
            return null;
        }
        if (implementations.size() == 1) {
            return (T)implementations.iterator().next();
        }
        return CapabilityWrapperRegistry.wrap(capability, implementations);
    }

    public static boolean hasCapability(IMultipartContainer container, Capability<?> capability, EnumFacing side, EnumFacing face) {
        if (container == null) {
            return false;
        }
        if (side != null) {
            ISlottedPart iSlottedPart;
            PartSlot slot = PartSlot.getFaceSlot(side);
            ISlottedPart iSlottedPart2 = container.getPartInSlot(slot);
            if (iSlottedPart2 != null) {
                return iSlottedPart2 instanceof ISlottedCapabilityProvider ? ((ISlottedCapabilityProvider)((Object)iSlottedPart2)).hasCapability(capability, slot, side) : (iSlottedPart2 instanceof ICapabilityProvider ? ((ICapabilityProvider)iSlottedPart2).hasCapability(capability, side) : false);
            }
            slot = PartSlot.getEdgeSlot(side, face);
            ISlottedPart iSlottedPart3 = container.getPartInSlot(slot);
            if (iSlottedPart3 != null) {
                return iSlottedPart3 instanceof ISlottedCapabilityProvider ? ((ISlottedCapabilityProvider)((Object)iSlottedPart3)).hasCapability(capability, slot, side) : (iSlottedPart3 instanceof ICapabilityProvider ? ((ICapabilityProvider)iSlottedPart3).hasCapability(capability, side) : false);
            }
            slot = PartSlot.getFaceSlot(face);
            ISlottedPart iSlottedPart4 = container.getPartInSlot(slot);
            if (iSlottedPart4 != null) {
                return iSlottedPart4 instanceof ISlottedCapabilityProvider ? ((ISlottedCapabilityProvider)((Object)iSlottedPart4)).hasCapability(capability, slot, side) : (iSlottedPart4 instanceof ICapabilityProvider ? ((ICapabilityProvider)iSlottedPart4).hasCapability(capability, side) : false);
            }
            if (face == null && (iSlottedPart = container.getPartInSlot(PartSlot.CENTER)) != null && (iSlottedPart instanceof ISlottedCapabilityProvider || iSlottedPart instanceof ICapabilityProvider) && (iSlottedPart instanceof ISlottedCapabilityProvider ? ((ISlottedCapabilityProvider)((Object)iSlottedPart)).hasCapability(capability, slot, side) : iSlottedPart instanceof ICapabilityProvider && ((ICapabilityProvider)iSlottedPart).hasCapability(capability, side))) {
                return true;
            }
        }
        for (IMultipart iMultipart : container.getParts()) {
            if (side != null && iMultipart instanceof ISlottedPart && !((ISlottedPart)iMultipart).getSlotMask().isEmpty() || !(iMultipart instanceof ICapabilityProvider) || !((ICapabilityProvider)iMultipart).hasCapability(capability, side)) continue;
            return true;
        }
        return false;
    }

    public static <T> T getCapability(IMultipartContainer container, Capability<T> capability, EnumFacing side, EnumFacing face) {
        ISlottedPart part;
        if (container == null) {
            return null;
        }
        if (side != null) {
            PartSlot slot = PartSlot.getFaceSlot(side);
            part = container.getPartInSlot(slot);
            if (part != null) {
                return (T)(part instanceof ISlottedCapabilityProvider ? (Object)((ISlottedCapabilityProvider)((Object)part)).getCapability(capability, slot, side) : (part instanceof ICapabilityProvider ? ((ICapabilityProvider)part).getCapability(capability, side) : null));
            }
            slot = PartSlot.getEdgeSlot(side, face);
            part = container.getPartInSlot(slot);
            if (part != null) {
                return (T)(part instanceof ISlottedCapabilityProvider ? (Object)((ISlottedCapabilityProvider)((Object)part)).getCapability(capability, slot, side) : (part instanceof ICapabilityProvider ? ((ICapabilityProvider)part).getCapability(capability, side) : null));
            }
            slot = PartSlot.getFaceSlot(face);
            part = container.getPartInSlot(slot);
            if (part != null) {
                return (T)(part instanceof ISlottedCapabilityProvider ? (Object)((ISlottedCapabilityProvider)((Object)part)).getCapability(capability, slot, side) : (part instanceof ICapabilityProvider ? ((ICapabilityProvider)part).getCapability(capability, side) : null));
            }
        }
        HashSet<Object> implementations = new HashSet<Object>();
        if (face == null && side != null && (part = container.getPartInSlot(PartSlot.CENTER)) != null) {
            Object object;
            Object object2 = part instanceof ISlottedCapabilityProvider ? (Object)((ISlottedCapabilityProvider)((Object)part)).getCapability(capability, PartSlot.CENTER, side) : (object = part instanceof ICapabilityProvider ? ((ICapabilityProvider)part).getCapability(capability, side) : null);
            if (object != null) {
                implementations.add(object);
            }
        }
        for (IMultipart iMultipart : container.getParts()) {
            Object impl;
            if (side != null && iMultipart instanceof ISlottedPart && !((ISlottedPart)iMultipart).getSlotMask().isEmpty() || !(iMultipart instanceof ICapabilityProvider) || !((ICapabilityProvider)iMultipart).hasCapability(capability, side) || (impl = ((ICapabilityProvider)iMultipart).getCapability(capability, side)) == null) continue;
            implementations.add(impl);
        }
        if (implementations.isEmpty()) {
            return null;
        }
        if (implementations.size() == 1) {
            return (T)implementations.iterator().next();
        }
        return CapabilityWrapperRegistry.wrap(capability, implementations);
    }
}

