/*
 * Decompiled with CFR 0.152.
 */
package wailafeatures.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class AuthorIdent {
    private static Map<String, String> authorMap = new HashMap<String, String>();

    public static void init() {
        for (ModContainer mod : Loader.instance().getModList()) {
            if (mod == null || mod.getModId() == null || mod.getMetadata() == null) continue;
            authorMap.put(mod.getModId().toLowerCase(), mod.getMetadata().getAuthorList());
        }
        authorMap.put("minecraft", "Mojang");
    }

    public static String nameFromItem(Item item) {
        String author = authorMap.get(item.getRegistryName().func_110624_b().toLowerCase());
        return author == null ? "<Unknown>" : author;
    }

    public static String nameFromEntity(Entity entity) {
        String author = "Mojang";
        EntityRegistry.EntityRegistration reg = EntityRegistry.instance().lookupModSpawn(entity.getClass(), true);
        if (reg != null) {
            author = authorMap.get(reg.getContainer().getModId());
        }
        return author;
    }
}

