/*
 * Decompiled with CFR 0.152.
 */
package wailafeatures.config;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import wailafeatures.config.Settings;
import wailafeatures.util.TranslationHelper;

public class ConfigHandler {
    public static Configuration config;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            ConfigHandler.loadConfig();
        }
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("wailafeatures")) {
            ConfigHandler.loadConfig();
        }
    }

    private static void loadConfig() {
        Settings.debugMode = config.getBoolean(TranslationHelper.translateToLocal("wailafeatures.config.debug.title"), "general", false, TranslationHelper.translateToLocal("wailafeatures.config.debug.description"));
        Settings.authorIdent = config.getBoolean(TranslationHelper.translateToLocal("wailafeatures.config.authorIdent.title"), "general", true, TranslationHelper.translateToLocal("wailafeatures.config.authorIdent.description"));
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.addAll(new ConfigElement(config.getCategory("general")).getChildElements());
        return list;
    }
}

