/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.trap;

import net.darkhax.bookshelf.item.ItemBlockBasic;
import net.darkhax.darkutils.features.Feature;
import net.darkhax.darkutils.features.material.FeatureMaterial;
import net.darkhax.darkutils.features.trap.BlockTrap;
import net.darkhax.darkutils.features.trap.TrapType;
import net.darkhax.darkutils.libs.ModUtils;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class FeatureTrap
extends Feature {
    public static Block blockTrap;
    public boolean craftPoison = true;
    public boolean craftWeakness = true;
    public boolean craftHarming = true;
    public boolean craftSlowness = true;
    public boolean craftFire = true;
    public boolean craftWither = true;

    @Override
    public void onPreInit() {
        blockTrap = new BlockTrap();
        ModUtils.registerBlock(blockTrap, (ItemBlock)new ItemBlockBasic(blockTrap, TrapType.getTypes()), "trap_tile");
    }

    @Override
    public void setupConfiguration(Configuration config) {
        this.craftPoison = config.getBoolean("craftPoison", this.configName, true, "Should the poison trap be craftable?");
        this.craftWeakness = config.getBoolean("craftWeakness", this.configName, true, "Should the weakness trap be craftable?");
        this.craftHarming = config.getBoolean("craftHarming", this.configName, true, "Should the harming trap be craftable?");
        this.craftSlowness = config.getBoolean("craftSlowness", this.configName, true, "Should the slowness trap be craftable?");
        this.craftFire = config.getBoolean("craftFire", this.configName, true, "Should the fire trap be craftable?");
        this.craftWither = config.getBoolean("craftWither", this.configName, true, "Should the wither trap be craftable?");
    }

    @Override
    public void setupRecipes() {
        if (this.craftPoison) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockTrap, 1, 0), new Object[]{"sis", Character.valueOf('s'), "stone", Character.valueOf('i'), Items.field_151070_bp}));
        }
        if (this.craftWeakness) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockTrap, 1, 1), new Object[]{"sis", Character.valueOf('s'), "stone", Character.valueOf('i'), Items.field_151071_bq}));
        }
        if (this.craftHarming) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockTrap, 1, 2), new Object[]{"sis", Character.valueOf('s'), "stone", Character.valueOf('i'), Items.field_151040_l}));
        }
        if (this.craftSlowness) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockTrap, 1, 3), new Object[]{"sis", Character.valueOf('s'), "stone", Character.valueOf('i'), Blocks.field_150425_aM}));
        }
        if (this.craftFire) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockTrap, 1, 4), new Object[]{"sis", Character.valueOf('s'), "stone", Character.valueOf('i'), Items.field_151033_d}));
        }
        if (this.craftWither) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockTrap, 1, 5), new Object[]{"sis", Character.valueOf('s'), "stone", Character.valueOf('i'), ModUtils.validateCrafting(FeatureMaterial.itemMaterial)}));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientPreInit() {
        ModUtils.registerBlockInvModel(blockTrap, "trap", TrapType.getTypes());
    }
}

