/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.shulkerpearl;

import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ShulkerDataHandler {
    @CapabilityInject(value=ICustomData.class)
    public static final Capability<ICustomData> CUSTOM_DATA = null;

    public static void init() {
        CapabilityManager.INSTANCE.register(ICustomData.class, (Capability.IStorage)new Storage(), Default.class);
        MinecraftForge.EVENT_BUS.register((Object)new ShulkerDataHandler());
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent.Entity event) {
        if (event.getEntity() instanceof EntityShulker) {
            event.addCapability(new ResourceLocation("darkutils", "shulker_info"), (ICapabilityProvider)new Provider());
        }
    }

    public static ICustomData getData(Entity entity) {
        return (ICustomData)entity.getCapability(CUSTOM_DATA, EnumFacing.DOWN);
    }

    public static class Provider
    implements ICapabilitySerializable<NBTTagCompound> {
        ICustomData instance = (ICustomData)CUSTOM_DATA.getDefaultInstance();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CUSTOM_DATA;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(this.hasCapability(capability, facing) ? CUSTOM_DATA.cast((Object)this.instance) : null);
        }

        public NBTTagCompound serializeNBT() {
            return (NBTTagCompound)CUSTOM_DATA.getStorage().writeNBT(CUSTOM_DATA, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            CUSTOM_DATA.getStorage().readNBT(CUSTOM_DATA, (Object)this.instance, null, (NBTBase)nbt);
        }
    }

    public static class Storage
    implements Capability.IStorage<ICustomData> {
        public NBTBase writeNBT(Capability<ICustomData> capability, ICustomData instance, EnumFacing side) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("cooldown", instance.getCooldown());
            return tag;
        }

        public void readNBT(Capability<ICustomData> capability, ICustomData instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound tag = (NBTTagCompound)nbt;
            instance.setCooldown(tag.func_74762_e("cooldown"));
        }
    }

    public static class Default
    implements ICustomData {
        private int cooldown = 0;

        @Override
        public int getCooldown() {
            return this.cooldown;
        }

        @Override
        public void setCooldown(int cooldown) {
            this.cooldown = cooldown;
        }
    }

    public static interface ICustomData {
        public int getCooldown();

        public void setCooldown(int var1);
    }
}

