/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.features.chests;

import net.darkhax.bookshelf.block.BlockBasicChest;
import net.darkhax.darkutils.features.Feature;
import net.darkhax.darkutils.features.chests.StateMapChest;
import net.darkhax.darkutils.libs.ModUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class FeatureChests
extends Feature {
    @SideOnly(value=Side.CLIENT)
    private static StateMapperBase stateMap;
    public static final BlockChest.Type TYPE_GLACIAL;
    public static final BlockChest.Type TYPE_GLASS;
    public static final BlockChest.Type TYPE_JUNGLE;
    public static final BlockChest.Type TYPE_MAGIC;
    public static final BlockChest.Type TYPE_NETHER;
    public static final BlockChest.Type TYPE_ROYAL;
    public static final BlockChest.Type TYPE_SANDSTONE;
    public static final BlockChest.Type TYPE_PRISMARINE;
    public static Block glacial;
    public static Block glass;
    public static Block jungle;
    public static Block magic;
    public static Block nether;
    public static Block royal;
    public static Block sandstone;
    public static Block prismarine;
    public static boolean craftGlacial;
    public static boolean craftGlass;
    public static boolean craftJungle;
    public static boolean craftMagic;
    public static boolean craftNether;
    public static boolean craftRoyal;
    public static boolean craftSandstone;
    public static boolean craftPrismarine;

    @Override
    public void onPreInit() {
        glacial = this.createChest(new BlockBasicChest("darkutils", "glacial", TYPE_GLACIAL).func_149711_c(2.5f), "chest_glacial");
        glass = this.createChest(new BlockBasicChest("darkutils", "glass", TYPE_GLASS).func_149711_c(2.5f), "chest_glass");
        jungle = this.createChest(new BlockBasicChest("darkutils", "jungle", TYPE_JUNGLE).func_149711_c(2.5f), "chest_jungle");
        magic = this.createChest(new BlockBasicChest("darkutils", "magic", TYPE_MAGIC).func_149711_c(2.5f), "chest_magic");
        nether = this.createChest(new BlockBasicChest("darkutils", "nether", TYPE_NETHER).func_149711_c(2.5f), "chest_nether");
        royal = this.createChest(new BlockBasicChest("darkutils", "royal", TYPE_ROYAL).func_149711_c(2.5f), "chest_royal");
        sandstone = this.createChest(new BlockBasicChest("darkutils", "sandstone", TYPE_SANDSTONE).func_149711_c(2.5f), "chest_sandstone");
        prismarine = this.createChest(new BlockBasicChest("darkutils", "prismarine", TYPE_PRISMARINE).func_149711_c(2.5f), "chest_prismarine");
    }

    @Override
    public void setupConfiguration(Configuration config) {
        craftGlacial = config.getBoolean("Craft Glacial Chest", this.configName, true, "Should the glacial chest be craftable??");
        craftGlass = config.getBoolean("Craft Glass Chest", this.configName, true, "Should the glass chest be craftable??");
        craftJungle = config.getBoolean("Craft Jungle Chest", this.configName, true, "Should the jungle chest be craftable??");
        craftMagic = config.getBoolean("Craft Magic Chest", this.configName, true, "Should the magic chest be craftable??");
        craftNether = config.getBoolean("Craft Nether Chest", this.configName, true, "Should the nether chest be craftable??");
        craftRoyal = config.getBoolean("Craft Royal Chest", this.configName, true, "Should the royal chest be craftable??");
        craftSandstone = config.getBoolean("Craft Sandstone Chest", this.configName, true, "Should the sandstone chest be craftable??");
        craftPrismarine = config.getBoolean("Craft Prismarine Chest", this.configName, true, "Should the prismarine chest be craftable??");
    }

    @Override
    public void setupRecipes() {
        if (craftGlacial) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(glacial, new Object[]{"xyx", "ycy", "xyx", Character.valueOf('x'), Blocks.field_150433_aE, Character.valueOf('y'), Blocks.field_150432_aD, Character.valueOf('c'), "chest"}));
        }
        if (craftGlass) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(glass, new Object[]{"xyx", "ycy", "xyx", Character.valueOf('x'), "blockGlass", Character.valueOf('y'), "paneGlass", Character.valueOf('c'), "chest"}));
        }
        if (craftJungle) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(jungle, new Object[]{"xyx", "ycy", "xyx", Character.valueOf('x'), "treeLeaves", Character.valueOf('y'), "treeSapling", Character.valueOf('c'), "chest"}));
        }
        if (craftMagic) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(magic, new Object[]{"xyx", "ycy", "xyx", Character.valueOf('x'), "ingotGold", Character.valueOf('y'), new ItemStack(Blocks.field_150325_L, 1, 11), Character.valueOf('c'), "chest"}));
        }
        if (craftNether) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(nether, new Object[]{"xqx", "ycy", "xyx", Character.valueOf('x'), "netherrack", Character.valueOf('q'), "gemQuartz", Character.valueOf('y'), "ingotBrickNether", Character.valueOf('c'), "chest"}));
        }
        if (craftRoyal) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(royal, new Object[]{"xyx", "ycy", "xyx", Character.valueOf('x'), "ingotGold", Character.valueOf('y'), new ItemStack(Blocks.field_150325_L, 1, 14), Character.valueOf('c'), "chest"}));
        }
        if (craftSandstone) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(sandstone, new Object[]{"xxx", "xcx", "xxx", Character.valueOf('x'), "sandstone", Character.valueOf('c'), "chest"}));
        }
        if (craftPrismarine) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(prismarine, new Object[]{"xyx", "ycy", "xyx", Character.valueOf('x'), "gemPrismarine", Character.valueOf('y'), "dustPrismarine", Character.valueOf('c'), "chest"}));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientPreInit() {
        stateMap = new StateMapChest();
        ModUtils.registerBlockInvModel(glacial);
        ModelLoader.setCustomStateMapper((Block)glacial, (IStateMapper)stateMap);
        ModUtils.registerBlockInvModel(glass);
        ModelLoader.setCustomStateMapper((Block)glass, (IStateMapper)stateMap);
        ModUtils.registerBlockInvModel(jungle);
        ModelLoader.setCustomStateMapper((Block)jungle, (IStateMapper)stateMap);
        ModUtils.registerBlockInvModel(magic);
        ModelLoader.setCustomStateMapper((Block)magic, (IStateMapper)stateMap);
        ModUtils.registerBlockInvModel(nether);
        ModelLoader.setCustomStateMapper((Block)nether, (IStateMapper)stateMap);
        ModUtils.registerBlockInvModel(royal);
        ModelLoader.setCustomStateMapper((Block)royal, (IStateMapper)stateMap);
        ModUtils.registerBlockInvModel(sandstone);
        ModelLoader.setCustomStateMapper((Block)sandstone, (IStateMapper)stateMap);
        ModUtils.registerBlockInvModel(prismarine);
        ModelLoader.setCustomStateMapper((Block)prismarine, (IStateMapper)stateMap);
    }

    private Block createChest(Block block, String id) {
        ModUtils.registerBlock(block, id);
        OreDictionary.registerOre((String)"chest", (Block)block);
        return block;
    }

    static {
        TYPE_GLACIAL = (BlockChest.Type)EnumHelper.addEnum(BlockChest.Type.class, (String)"DARKUTILS_GLACIAL", (Class[])new Class[0], (Object[])new Object[0]);
        TYPE_GLASS = (BlockChest.Type)EnumHelper.addEnum(BlockChest.Type.class, (String)"DARKUTILS_GLASS", (Class[])new Class[0], (Object[])new Object[0]);
        TYPE_JUNGLE = (BlockChest.Type)EnumHelper.addEnum(BlockChest.Type.class, (String)"DARKUTILS_JUNGLE", (Class[])new Class[0], (Object[])new Object[0]);
        TYPE_MAGIC = (BlockChest.Type)EnumHelper.addEnum(BlockChest.Type.class, (String)"DARKUTILS_MAGIC", (Class[])new Class[0], (Object[])new Object[0]);
        TYPE_NETHER = (BlockChest.Type)EnumHelper.addEnum(BlockChest.Type.class, (String)"DARKUTILS_NETHER", (Class[])new Class[0], (Object[])new Object[0]);
        TYPE_ROYAL = (BlockChest.Type)EnumHelper.addEnum(BlockChest.Type.class, (String)"DARKUTILS_ROYAL", (Class[])new Class[0], (Object[])new Object[0]);
        TYPE_SANDSTONE = (BlockChest.Type)EnumHelper.addEnum(BlockChest.Type.class, (String)"DARKUTILS_SANDSTONE", (Class[])new Class[0], (Object[])new Object[0]);
        TYPE_PRISMARINE = (BlockChest.Type)EnumHelper.addEnum(BlockChest.Type.class, (String)"DARKUTILS_PRISMARINE", (Class[])new Class[0], (Object[])new Object[0]);
    }
}

