/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.manager;

import codechicken.enderstorage.api.AbstractEnderStorage;
import codechicken.enderstorage.api.EnderStoragePlugin;
import codechicken.enderstorage.api.Frequency;
import codechicken.lib.config.ConfigFile;
import com.google.common.collect.ImmutableMap;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class EnderStorageManager {
    private static EnderStorageManager serverManager;
    private static EnderStorageManager clientManager;
    private static ConfigFile config;
    private static HashMap<String, EnderStoragePlugin> plugins;
    private Map<String, AbstractEnderStorage> storageMap;
    private Map<String, List<AbstractEnderStorage>> storageList;
    public final boolean client;
    private File saveDir;
    private File[] saveFiles;
    private int saveTo;
    private List<AbstractEnderStorage> dirtyStorage;
    private NBTTagCompound saveTag;

    public EnderStorageManager(boolean client) {
        this.client = client;
        this.storageMap = Collections.synchronizedMap(new HashMap());
        this.storageList = Collections.synchronizedMap(new HashMap());
        this.dirtyStorage = Collections.synchronizedList(new LinkedList());
        for (String key : plugins.keySet()) {
            this.storageList.put(key, new ArrayList());
        }
        if (!client) {
            this.load();
        }
    }

    private void sendClientInfo(EntityPlayer player) {
        for (Map.Entry<String, EnderStoragePlugin> plugin : plugins.entrySet()) {
            plugin.getValue().sendClientInfo(player, this.storageList.get(plugin.getKey()));
        }
    }

    private void load() {
        this.saveDir = new File(DimensionManager.getCurrentSaveRootDirectory(), "EnderStorage");
        try {
            if (!this.saveDir.exists()) {
                this.saveDir.mkdirs();
            }
            this.saveFiles = new File[]{new File(this.saveDir, "data1.dat"), new File(this.saveDir, "data2.dat"), new File(this.saveDir, "lock.dat")};
            if (this.saveFiles[2].exists() && this.saveFiles[2].length() > 0L) {
                FileInputStream fin = new FileInputStream(this.saveFiles[2]);
                this.saveTo = fin.read() ^ 1;
                fin.close();
                if (this.saveFiles[this.saveTo ^ 1].exists()) {
                    FileInputStream in = new FileInputStream(this.saveFiles[this.saveTo ^ 1]);
                    this.saveTag = CompressedStreamTools.func_74796_a((InputStream)in);
                    in.close();
                } else {
                    this.saveTag = new NBTTagCompound();
                }
            } else {
                this.saveTag = new NBTTagCompound();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void save(boolean force) {
        if (!this.dirtyStorage.isEmpty() || force) {
            for (AbstractEnderStorage inv : this.dirtyStorage) {
                this.saveTag.func_74782_a(inv.freq + ",type=" + inv.type(), (NBTBase)inv.saveToTag());
                inv.setClean();
            }
            this.dirtyStorage.clear();
            try {
                File saveFile = this.saveFiles[this.saveTo];
                if (!saveFile.exists()) {
                    saveFile.createNewFile();
                }
                DataOutputStream dout = new DataOutputStream(new FileOutputStream(saveFile));
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.saveTag, (OutputStream)dout);
                dout.close();
                FileOutputStream fout = new FileOutputStream(this.saveFiles[2]);
                fout.write(this.saveTo);
                fout.close();
                this.saveTo ^= 1;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void reloadManager(boolean client) {
        EnderStorageManager newManager = new EnderStorageManager(client);
        if (client) {
            clientManager = newManager;
        } else {
            serverManager = newManager;
        }
    }

    public File getSaveDir() {
        return this.saveDir;
    }

    public static EnderStorageManager instance(boolean client) {
        EnderStorageManager manager;
        EnderStorageManager enderStorageManager = manager = client ? clientManager : serverManager;
        if (manager == null) {
            EnderStorageManager.reloadManager(client);
            manager = client ? clientManager : serverManager;
        }
        return manager;
    }

    public AbstractEnderStorage getStorage(Frequency freq, String type) {
        String key = freq + ",type=" + type;
        AbstractEnderStorage storage = this.storageMap.get(key);
        if (storage == null) {
            storage = plugins.get(type).createEnderStorage(this, freq);
            if (!this.client && this.saveTag.func_74764_b(key)) {
                storage.loadFromTag(this.saveTag.func_74775_l(key));
            }
            this.storageMap.put(key, storage);
            this.storageList.get(type).add(storage);
        }
        return storage;
    }

    @Deprecated
    public static int getFreqFromColours(int colour1, int colour2, int colour3) {
        return ((colour1 & 0xF) << 8) + ((colour2 & 0xF) << 4) + (colour3 & 0xF);
    }

    @Deprecated
    public static int getFreqFromColours(int[] colours) {
        return ((colours[0] & 0xF) << 8) + ((colours[1] & 0xF) << 4) + (colours[2] & 0xF);
    }

    @Deprecated
    public static int getColourFromFreq(int freq, int colour) {
        switch (colour) {
            case 0: {
                return freq >> 8 & 0xF;
            }
            case 1: {
                return freq >> 4 & 0xF;
            }
            case 2: {
                return freq & 0xF;
            }
        }
        return 0;
    }

    @Deprecated
    public static int[] getColoursFromFreq(int freq) {
        int[] ai = new int[]{freq >> 8 & 0xF, freq >> 4 & 0xF, freq & 0xF};
        return ai;
    }

    @Deprecated
    public static String getOwner(ItemStack stack) {
        String owner = "";
        if (stack.func_77942_o()) {
            owner = stack.func_77978_p().func_74779_i("owner");
        }
        return owner.isEmpty() ? "global" : owner;
    }

    @Deprecated
    public static boolean isOwned(ItemStack stack) {
        return !EnderStorageManager.getOwner(stack).equals("global");
    }

    public static void loadConfig(ConfigFile config2) {
        config = config2;
        for (Map.Entry<String, EnderStoragePlugin> plugin : plugins.entrySet()) {
            plugin.getValue().loadConfig(config.getTag(plugin.getKey()));
        }
    }

    public static void registerPlugin(EnderStoragePlugin plugin) {
        plugins.put(plugin.identifier(), plugin);
        if (config != null) {
            plugin.loadConfig(config.getTag(plugin.identifier()));
        }
        if (serverManager != null) {
            EnderStorageManager.serverManager.storageList.put(plugin.identifier(), new ArrayList());
        }
        if (clientManager != null) {
            EnderStorageManager.clientManager.storageList.put(plugin.identifier(), new ArrayList());
        }
    }

    public static EnderStoragePlugin getPlugin(String identifier) {
        return plugins.get(identifier);
    }

    public static Map<String, EnderStoragePlugin> getPlugins() {
        return ImmutableMap.copyOf(plugins);
    }

    public List<String> getValidKeys(String identifer) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this.saveTag.func_150296_c()) {
            if (!key.endsWith(",type=" + identifer)) continue;
            list.add(key.replace(",type=" + identifer, ""));
        }
        return list;
    }

    public void requestSave(AbstractEnderStorage storage) {
        this.dirtyStorage.add(storage);
    }

    static {
        plugins = new HashMap();
    }

    public static class EnderStorageSaveHandler {
        @SubscribeEvent
        public void onWorldLoad(WorldEvent.Load event) {
            if (event.getWorld().field_72995_K) {
                EnderStorageManager.reloadManager(true);
            }
        }

        @SubscribeEvent
        public void onWorldSave(WorldEvent.Save event) {
            if (!event.getWorld().field_72995_K && EnderStorageManager.instance(false) != null) {
                EnderStorageManager.instance(false).save(false);
            }
        }

        @SubscribeEvent
        public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
            EnderStorageManager.instance(false).sendClientInfo(event.player);
        }

        @SubscribeEvent
        public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            EnderStorageManager.instance(false).sendClientInfo(event.player);
        }
    }
}

