/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.morechickens.core;

import com.gendeathrow.morechickens.core.ModItems;
import com.gendeathrow.morechickens.core.proxies.CommonProxy;
import com.gendeathrow.morechickens.modHelper.BaseMetals;
import com.gendeathrow.morechickens.modHelper.Botania;
import com.gendeathrow.morechickens.modHelper.DraconicEvolution;
import com.gendeathrow.morechickens.modHelper.ExtremeReactors;
import com.gendeathrow.morechickens.modHelper.ImmersiveEngineering;
import com.gendeathrow.morechickens.modHelper.Mekanism;
import com.gendeathrow.morechickens.modHelper.SpecialChickens;
import com.gendeathrow.morechickens.modHelper.TinkersConstruct;
import com.setycz.chickens.ChickensRegistry;
import com.setycz.chickens.ChickensRegistryItem;
import com.setycz.chickens.SpawnType;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.apache.logging.log4j.Logger;

@Mod(modid="morechickens", name="More Chickens", version="1.0.11", dependencies="required-after:chickens@[4.2.2,);after:Botania;after:tconstruct;after:draconicevolution;after:mekanism;after:bigreactors", acceptedMinecraftVersions="[1.10.2]")
public class ChickensMore {
    public static final String MODID = "morechickens";
    public static final String VERSION = "1.0.11";
    public static final String NAME = "More Chickens";
    public static final String PROXY = "com.gendeathrow.morechickens.core.proxies";
    public static final String CHANNELNAME = "morechickens";
    public static final String dependencies = "required-after:chickens@[4.2.2,);after:Botania;after:tconstruct;after:draconicevolution;after:mekanism;after:bigreactors";
    @Mod.Instance(value="morechickens")
    public static ChickensMore instance;
    @SidedProxy(clientSide="com.gendeathrow.morechickens.core.proxies.ClientProxy", serverSide="com.gendeathrow.morechickens.core.proxies.CommonProxy")
    public static CommonProxy proxy;
    public static SimpleNetworkWrapper network;
    public static FMLEventChannel channel;
    public static Logger logger;
    File fileConfig;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        logger.info("More Chickens PreInit...");
        network = NetworkRegistry.INSTANCE.newSimpleChannel("morechickens");
        proxy.preInit(event);
        this.fileConfig = event.getSuggestedConfigurationFile();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) throws IOException {
        logger.info("More Chickens Init...");
        proxy.init(event);
        ModItems.registerItems();
        this.loadConfiguration(this.fileConfig);
        proxy.registerEventHandlers();
        proxy.initRenderers();
    }

    private void loadConfiguration(File configFile) {
        logger.info("More Chickens Loading Config...");
        Configuration configuration = new Configuration(configFile);
        List<ChickensRegistryItem> allChickens = this.generateDefaultChickens();
        for (ChickensRegistryItem chicken : allChickens) {
            boolean enabled = configuration.getBoolean("enabled", chicken.getEntityName(), true, "Is chicken enabled?");
            chicken.setEnabled(enabled);
            float layCoefficient = configuration.getFloat("layCoefficient", chicken.getEntityName(), 1.0f, 0.01f, 100.0f, "Scale time to lay an egg.");
            chicken.setLayCoefficient(layCoefficient);
            ItemStack itemStack = this.loadItemStack(configuration, chicken, "egg", chicken.createLayItem());
            chicken.setLayItem(itemStack);
            ItemStack dropItemStack = this.loadItemStack(configuration, chicken, "drop", chicken.createDropItem());
            chicken.setDropItem(dropItemStack);
            ChickensRegistryItem parent1 = this.getChickenParent(configuration, "parent1", allChickens, chicken, chicken.getParent1());
            ChickensRegistryItem parent2 = this.getChickenParent(configuration, "parent2", allChickens, chicken, chicken.getParent2());
            if (parent1 != null && parent2 != null) {
                chicken.setParentsNew(parent1, parent2);
            } else {
                chicken.setNoParents();
            }
            SpawnType spawnType = SpawnType.valueOf((String)configuration.getString("spawnType", chicken.getEntityName(), chicken.getSpawnType().toString(), "Chicken spawn type, can be: " + String.join((CharSequence)",", SpawnType.names())));
            chicken.setSpawnType(spawnType);
            ChickensRegistry.register((ChickensRegistryItem)chicken);
            proxy.registerChicken(chicken);
        }
        for (ChickensRegistryItem specialChickens : SpecialChickens.init(new ArrayList<ChickensRegistryItem>())) {
            allChickens.add(specialChickens);
            ChickensRegistry.register((ChickensRegistryItem)specialChickens);
            proxy.registerChicken(specialChickens);
        }
        configuration.save();
    }

    private ItemStack loadItemStack(Configuration configuration, ChickensRegistryItem chicken, String prefix, ItemStack defaultItemStack) {
        String itemName = configuration.getString(prefix + "ItemName", chicken.getEntityName(), defaultItemStack.func_77973_b().getRegistryName().toString(), "Item name to be laid/dropped.");
        int itemAmount = configuration.getInt(prefix + "ItemAmount", chicken.getEntityName(), defaultItemStack.field_77994_a, 1, 64, "Item amount to be laid/dropped.");
        int itemMeta = configuration.getInt(prefix + "ItemMeta", chicken.getEntityName(), defaultItemStack.func_77960_j(), Integer.MIN_VALUE, Integer.MAX_VALUE, "Item amount to be laid/dropped.");
        ResourceLocation itemResourceLocation = new ResourceLocation(itemName);
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)itemResourceLocation);
        if (item == null) {
            if (defaultItemStack != null) {
                return defaultItemStack;
            }
            throw new RuntimeException("Cannot find egg item with name: " + itemName);
        }
        return new ItemStack(item, itemAmount, itemMeta);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
    }

    private List<ChickensRegistryItem> generateDefaultChickens() {
        List<ChickensRegistryItem> chickens = new ArrayList<ChickensRegistryItem>();
        ChickensRegistryItem xpChicken = new ChickensRegistryItem(500, "xpChicken", new ResourceLocation("morechickens", "textures/entity/XpChicken.png"), new ItemStack((Item)ModItems.solidXp, 1, 0), 4063006, 4190499).setSpawnType(SpawnType.NONE);
        xpChicken.setParentsNew(ChickensMore.findChicken(chickens, "emeraldchicken"), ChickensMore.findChicken(chickens, "GreenChicken"));
        chickens.add(xpChicken);
        ChickensRegistryItem pShardChicken = new ChickensRegistryItem(501, "pShardChicken", new ResourceLocation("morechickens", "textures/entity/PShardChicken.png"), new ItemStack(Items.field_179562_cC, 1, 0), 4423790, 10472380).setSpawnType(SpawnType.NONE);
        pShardChicken.setParentsNew(ChickensMore.findChicken(chickens, "waterchicken"), ChickensMore.findChicken(chickens, "bluechicken"));
        chickens.add(pShardChicken);
        ChickensRegistryItem pCrystalChicken = new ChickensRegistryItem(502, "pCrystalChicken", new ResourceLocation("morechickens", "textures/entity/PCrystalChicken.png"), new ItemStack(Items.field_179563_cD, 1, 0), 5138785, 14674396).setSpawnType(SpawnType.NONE);
        pCrystalChicken.setParentsNew(ChickensMore.findChicken(chickens, "waterchicken"), ChickensMore.findChicken(chickens, "emeraldchicken"));
        chickens.add(pCrystalChicken);
        chickens = TinkersConstruct.tryRegisterChickens(chickens);
        chickens = DraconicEvolution.tryRegisterChickens(chickens);
        chickens = Botania.tryRegisterChickens(chickens);
        chickens = BaseMetals.tryRegisterChickens(chickens);
        chickens = ImmersiveEngineering.tryRegisterChickens(chickens);
        chickens = Mekanism.tryRegisterChickens(chickens);
        chickens = ExtremeReactors.tryRegisterChickens(chickens);
        return chickens;
    }

    private ChickensRegistryItem getChickenParent(Configuration configuration, String propertyName, Collection<ChickensRegistryItem> allChickens, ChickensRegistryItem chicken, ChickensRegistryItem parent) {
        String parentName = configuration.getString(propertyName, chicken.getEntityName(), parent != null ? parent.getEntityName() : "", "First parent, empty if it's base chicken.");
        return ChickensMore.findChicken(allChickens, parentName);
    }

    public static ChickensRegistryItem findChicken(Collection<ChickensRegistryItem> chickens, String name) {
        for (ChickensRegistryItem chicken : chickens) {
            if (chicken.getEntityName().compareToIgnoreCase(name) != 0) continue;
            return chicken;
        }
        return ChickensMore.findChickenChickensMod(name);
    }

    public static ChickensRegistryItem findChickenChickensMod(String name) {
        for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
            if (chicken.getEntityName().compareToIgnoreCase(name) != 0) continue;
            return chicken;
        }
        return null;
    }
}

