/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.util.compat;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.util.compat.TileTeslaWrapper;
import java.util.HashMap;
import java.util.Map;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;

public final class TeslaUtil {
    private static final Map<TileEntityBase, TileTeslaWrapper[]> TESLA_MAP = new HashMap<TileEntityBase, TileTeslaWrapper[]>();
    @CapabilityInject(value=ITeslaConsumer.class)
    public static Capability<ITeslaConsumer> teslaConsumer;
    @CapabilityInject(value=ITeslaProducer.class)
    public static Capability<ITeslaProducer> teslaProducer;
    @CapabilityInject(value=ITeslaHolder.class)
    public static Capability<ITeslaHolder> teslaHolder;

    public static <T> T wrapTeslaToRF(TileEntityBase tile, Capability<T> capability, EnumFacing facing) {
        boolean hold;
        boolean receive = tile instanceof IEnergyReceiver && capability == teslaConsumer;
        boolean provide = tile instanceof IEnergyProvider && capability == teslaProducer;
        boolean bl = hold = tile instanceof IEnergyHandler && capability == teslaHolder;
        if (receive || provide || hold) {
            return (T)TeslaUtil.getHandler(tile, facing);
        }
        return null;
    }

    public static void doWrappedTeslaRFInteraction(TileEntity tileFrom, TileEntity tileTo, EnumFacing side, int maxTransfer) {
        if (tileTo.hasCapability(teslaConsumer, side.func_176734_d()) && tileFrom.hasCapability(teslaProducer, side)) {
            ITeslaConsumer handlerTo = (ITeslaConsumer)tileTo.getCapability(teslaConsumer, side.func_176734_d());
            ITeslaProducer handlerFrom = (ITeslaProducer)tileFrom.getCapability(teslaProducer, side);
            long drain = handlerFrom.takePower((long)maxTransfer, true);
            if (drain > 0L) {
                long filled = handlerTo.givePower(drain, false);
                handlerFrom.takePower(filled, false);
            }
        }
    }

    private static TileTeslaWrapper getHandler(TileEntityBase tile, EnumFacing facing) {
        EnumFacing properFacing;
        int side;
        TileTeslaWrapper[] handlers = TESLA_MAP.get((Object)tile);
        if (handlers == null || handlers.length != 6) {
            handlers = new TileTeslaWrapper[6];
            TESLA_MAP.put(tile, handlers);
        }
        if (handlers[side = (properFacing = facing == null ? EnumFacing.DOWN : facing).ordinal()] == null) {
            handlers[side] = new TileTeslaWrapper(tile, properFacing);
        }
        return handlers[side];
    }
}

