/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayItem;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityItemViewer
extends TileEntityInventoryBase {
    private final List<GenericItemHandlerInfo> genericInfos = new ArrayList<GenericItemHandlerInfo>();
    private final Map<Integer, SpecificItemHandlerInfo> specificInfos = new HashMap<Integer, SpecificItemHandlerInfo>();
    public TileEntityLaserRelayItem connectedRelay;
    private int lastNetworkChangeAmount = -1;

    public TileEntityItemViewer() {
        super(0, "itemViewer");
    }

    @Override
    protected void getInvWrappers(SidedInvWrapper[] wrappers) {
        for (int i = 0; i < wrappers.length; ++i) {
            final EnumFacing direction = EnumFacing.values()[i];
            wrappers[i] = new SidedInvWrapper(this, direction){

                public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                    SpecificItemHandlerInfo info;
                    if (TileEntityItemViewer.this.func_180462_a(slot, stack, direction) && (info = TileEntityItemViewer.this.getSwitchedIndexHandler(slot)) != null) {
                        return info.handler.insertItem(info.switchedIndex, stack, simulate);
                    }
                    return super.insertItem(slot, stack, simulate);
                }

                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    SpecificItemHandlerInfo info;
                    ItemStack stackIn = TileEntityItemViewer.this.func_70301_a(slot);
                    if (StackUtil.isValid(stackIn) && TileEntityItemViewer.this.func_180461_b(slot, stackIn, direction) && (info = TileEntityItemViewer.this.getSwitchedIndexHandler(slot)) != null) {
                        return info.handler.extractItem(info.switchedIndex, amount, simulate);
                    }
                    return super.extractItem(slot, amount, simulate);
                }
            };
        }
    }

    private List<GenericItemHandlerInfo> getItemHandlerInfos() {
        this.queryAndSaveData();
        return this.genericInfos;
    }

    private void queryAndSaveData() {
        Network network;
        if (this.connectedRelay != null && (network = this.connectedRelay.getNetwork()) != null) {
            if (this.lastNetworkChangeAmount != network.changeAmount) {
                this.clearInfos();
                this.connectedRelay.getItemHandlersInNetwork(network, this.genericInfos);
                if (!this.genericInfos.isEmpty()) {
                    Collections.sort(this.genericInfos);
                    int slotsQueried = 0;
                    for (GenericItemHandlerInfo info : this.genericInfos) {
                        for (IItemHandler handler : info.handlers) {
                            for (int i = 0; i < handler.getSlots(); ++i) {
                                this.specificInfos.put(slotsQueried, new SpecificItemHandlerInfo(handler, i, info.relayInQuestion));
                                ++slotsQueried;
                            }
                        }
                    }
                }
                this.lastNetworkChangeAmount = network.changeAmount;
            }
            return;
        }
        this.clearInfos();
        this.lastNetworkChangeAmount = -1;
    }

    private void clearInfos() {
        if (!this.genericInfos.isEmpty()) {
            this.genericInfos.clear();
        }
        if (!this.specificInfos.isEmpty()) {
            this.specificInfos.clear();
        }
    }

    private SpecificItemHandlerInfo getSwitchedIndexHandler(int i) {
        this.queryAndSaveData();
        return this.specificInfos.get(i);
    }

    @Override
    public boolean shouldSaveDataOnChangeOrWorldStart() {
        return true;
    }

    @Override
    public void saveDataOnChangeOrWorldStart() {
        TileEntityLaserRelayItem tileFound = null;
        if (this.field_145850_b != null) {
            for (int i = 0; i <= 5; ++i) {
                TileEntity tile;
                EnumFacing side = WorldUtil.getDirectionBySidesInOrder(i);
                BlockPos pos = this.func_174877_v().func_177972_a(side);
                if (!this.field_145850_b.func_175667_e(pos) || !((tile = this.field_145850_b.func_175625_s(pos)) instanceof TileEntityLaserRelayItem)) continue;
                if (tileFound != null) {
                    this.connectedRelay = null;
                    return;
                }
                tileFound = (TileEntityLaserRelayItem)tile;
            }
        }
        this.connectedRelay = tileFound;
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        SpecificItemHandlerInfo handler = this.getSwitchedIndexHandler(index);
        if (handler != null && handler.isLoaded() && this.isWhitelisted(handler, stack, true) && ItemStack.func_179545_c((ItemStack)handler.handler.getStackInSlot(handler.switchedIndex), (ItemStack)stack)) {
            ItemStack gaveBack = handler.handler.extractItem(handler.switchedIndex, StackUtil.getStackSize(stack), true);
            return StackUtil.isValid(gaveBack);
        }
        return false;
    }

    private boolean isWhitelisted(SpecificItemHandlerInfo handler, ItemStack stack, boolean output) {
        boolean whitelisted = handler.relayInQuestion.isWhitelisted(stack, output);
        TileEntityLaserRelayItem connected = this.connectedRelay;
        if (connected != null && connected != handler.relayInQuestion) {
            return whitelisted && connected.isWhitelisted(stack, output);
        }
        return whitelisted;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        SpecificItemHandlerInfo handler = this.getSwitchedIndexHandler(index);
        if (handler != null && handler.isLoaded() && this.isWhitelisted(handler, stack, false)) {
            ItemStack gaveBack = handler.handler.insertItem(handler.switchedIndex, stack, true);
            return !ItemStack.func_77989_b((ItemStack)gaveBack, (ItemStack)stack);
        }
        return false;
    }

    @Override
    public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70304_b(i);
        }
    }

    @Override
    public void func_70299_a(int i, ItemStack stack) {
        if (StackUtil.isValid(stack)) {
            SpecificItemHandlerInfo handler = this.getSwitchedIndexHandler(i);
            if (handler != null && handler.isLoaded()) {
                ItemStack toInsert = stack.func_77946_l();
                ItemStack inSlot = handler.handler.getStackInSlot(handler.switchedIndex);
                if (StackUtil.isValid(inSlot)) {
                    toInsert = StackUtil.addStackSize(toInsert, -StackUtil.getStackSize(inSlot));
                }
                handler.handler.insertItem(handler.switchedIndex, toInsert, false);
            }
        } else {
            this.func_70304_b(i);
        }
    }

    @Override
    public int func_70302_i_() {
        int size = 0;
        List<GenericItemHandlerInfo> infos = this.getItemHandlerInfos();
        if (infos != null) {
            for (GenericItemHandlerInfo info : infos) {
                if (!info.isLoaded()) continue;
                for (IItemHandler handler : info.handlers) {
                    size += handler.getSlots();
                }
            }
        }
        return size;
    }

    @Override
    public ItemStack func_70301_a(int i) {
        SpecificItemHandlerInfo handler = this.getSwitchedIndexHandler(i);
        if (handler != null && handler.isLoaded()) {
            return handler.handler.getStackInSlot(handler.switchedIndex);
        }
        return null;
    }

    @Override
    public ItemStack func_70298_a(int i, int j) {
        SpecificItemHandlerInfo handler = this.getSwitchedIndexHandler(i);
        if (handler != null && handler.isLoaded()) {
            return handler.handler.extractItem(handler.switchedIndex, j, false);
        }
        return null;
    }

    @Override
    public ItemStack func_70304_b(int index) {
        SpecificItemHandlerInfo handler = this.getSwitchedIndexHandler(index);
        if (handler != null && handler.isLoaded()) {
            ItemStack stackInSlot = handler.handler.getStackInSlot(handler.switchedIndex);
            if (StackUtil.isValid(stackInSlot)) {
                handler.handler.extractItem(handler.switchedIndex, StackUtil.getStackSize(stackInSlot), false);
            }
            return stackInSlot;
        }
        return null;
    }

    public static class GenericItemHandlerInfo
    implements Comparable<GenericItemHandlerInfo> {
        public final List<IItemHandler> handlers = new ArrayList<IItemHandler>();
        public final TileEntityLaserRelayItem relayInQuestion;

        public GenericItemHandlerInfo(TileEntityLaserRelayItem relayInQuestion) {
            this.relayInQuestion = relayInQuestion;
        }

        public boolean isLoaded() {
            return this.relayInQuestion.func_145830_o() && this.relayInQuestion.func_145831_w().func_175667_e(this.relayInQuestion.func_174877_v());
        }

        @Override
        public int compareTo(GenericItemHandlerInfo other) {
            int otherPrio;
            int thisPrio = this.relayInQuestion.getPriority();
            if (thisPrio == (otherPrio = other.relayInQuestion.getPriority())) {
                return 0;
            }
            if (thisPrio > otherPrio) {
                return -1;
            }
            return 1;
        }
    }

    private static class SpecificItemHandlerInfo {
        public final IItemHandler handler;
        public final int switchedIndex;
        public final TileEntityLaserRelayItem relayInQuestion;

        public SpecificItemHandlerInfo(IItemHandler handler, int switchedIndex, TileEntityLaserRelayItem relayInQuestion) {
            this.handler = handler;
            this.switchedIndex = switchedIndex;
            this.relayInQuestion = relayInQuestion;
        }

        public boolean isLoaded() {
            return this.relayInQuestion.func_145830_o() && this.relayInQuestion.func_145831_w().func_175667_e(this.relayInQuestion.func_174877_v());
        }
    }
}

