/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import de.ellpeck.actuallyadditions.mod.config.values.ConfigStringListValues;
import de.ellpeck.actuallyadditions.mod.tile.ICustomEnergyReceiver;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityItemRepairer
extends TileEntityInventoryBase
implements ICustomEnergyReceiver {
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 1;
    public static final int ENERGY_USE = 5000;
    public final EnergyStorage storage = new EnergyStorage(300000);
    public int nextRepairTick;
    private int lastEnergy;

    public TileEntityItemRepairer() {
        super(2, "repairer");
    }

    public static boolean canBeRepaired(ItemStack stack) {
        Item item;
        if (StackUtil.isValid(stack) && (item = stack.func_77973_b()) != null) {
            if (item.isRepairable()) {
                return true;
            }
            String reg = item.getRegistryName().toString();
            if (reg != null) {
                for (String strg : ConfigStringListValues.REPAIRER_EXTRA_WHITELIST.getValue()) {
                    if (!reg.equals(strg)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("NextRepairTick", this.nextRepairTick);
        }
        super.writeSyncableNBT(compound, type);
        this.storage.writeToNBT(compound);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.nextRepairTick = compound.func_74762_e("NextRepairTick");
        }
        super.readSyncableNBT(compound, type);
        this.storage.readFromNBT(compound);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            ItemStack input = this.slots[0];
            if (!StackUtil.isValid(this.slots[1]) && TileEntityItemRepairer.canBeRepaired(input)) {
                if (input.func_77952_i() <= 0) {
                    this.slots[1] = input.func_77946_l();
                    this.slots[0] = StackUtil.getNull();
                    this.nextRepairTick = 0;
                } else if (this.storage.getEnergyStored() >= 5000) {
                    ++this.nextRepairTick;
                    this.storage.extractEnergy(5000, false);
                    if (this.nextRepairTick >= 4) {
                        this.nextRepairTick = 0;
                        input.func_77964_b(input.func_77952_i() - 1);
                        if (input.func_77942_o() && "tconstruct".equalsIgnoreCase(input.func_77973_b().getRegistryName().func_110624_b())) {
                            NBTTagCompound stats = input.func_77978_p().func_74775_l("Stats");
                            stats.func_82580_o("Broken");
                        }
                    }
                }
            } else {
                this.nextRepairTick = 0;
            }
            if (this.lastEnergy != this.storage.getEnergyStored() && this.sendUpdateWithInterval()) {
                this.lastEnergy = this.storage.getEnergyStored();
            }
        }
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return i == 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @SideOnly(value=Side.CLIENT)
    public int getItemDamageToScale(int i) {
        if (StackUtil.isValid(this.slots[0])) {
            return (this.slots[0].func_77958_k() - this.slots[0].func_77952_i()) * i / this.slots[0].func_77958_k();
        }
        return 0;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return slot == 1;
    }

    @Override
    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }
}

