/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class TileEntityDropper
extends TileEntityInventoryBase {
    private int currentTime;

    public TileEntityDropper() {
        super(9, "dropper");
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.writeSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("CurrentTime", this.currentTime);
        }
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        super.readSyncableNBT(compound, type);
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentTime = compound.func_74762_e("CurrentTime");
        }
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!(this.field_145850_b.field_72995_K || this.isRedstonePowered || this.isPulseMode)) {
            if (this.currentTime > 0) {
                --this.currentTime;
                if (this.currentTime <= 0) {
                    this.doWork();
                }
            } else {
                this.currentTime = 5;
            }
        }
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return true;
    }

    private void doWork() {
        if (StackUtil.isValid(this.removeFromInventory(false))) {
            ItemStack stack = this.removeFromInventory(true);
            stack = StackUtil.setStackSize(stack, 1);
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            WorldUtil.dropItemAtSide(WorldUtil.getDirectionByPistonRotation(state.func_177230_c().func_176201_c(state)), this.field_145850_b, this.field_174879_c, stack);
        }
    }

    public ItemStack removeFromInventory(boolean actuallyDo) {
        for (int i = 0; i < this.slots.length; ++i) {
            if (!StackUtil.isValid(this.slots[i])) continue;
            ItemStack slot = this.slots[i].func_77946_l();
            if (actuallyDo) {
                this.slots[i] = StackUtil.addStackSize(this.slots[i], -1);
                this.func_70296_d();
            }
            return slot;
        }
        return StackUtil.getNull();
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return true;
    }

    @Override
    public boolean isRedstoneToggle() {
        return true;
    }

    @Override
    public void activateOnPulse() {
        this.doWork();
    }
}

