/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import cofh.api.energy.EnergyStorage;
import de.ellpeck.actuallyadditions.mod.tile.ISharingEnergyProvider;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityInventoryBase;
import de.ellpeck.actuallyadditions.mod.util.StackUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCoalGenerator
extends TileEntityInventoryBase
implements ISharingEnergyProvider {
    public static final int PRODUCE = 30;
    public final EnergyStorage storage = new EnergyStorage(60000);
    public int maxBurnTime;
    public int currentBurnTime;
    private int lastEnergy;
    private int lastBurnTime;
    private int lastCurrentBurnTime;
    private int lastCompare;

    public TileEntityCoalGenerator() {
        super(1, "coalGenerator");
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnergyScaled(int i) {
        return this.storage.getEnergyStored() * i / this.storage.getMaxEnergyStored();
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurningScaled(int i) {
        return this.currentBurnTime * i / this.maxBurnTime;
    }

    @Override
    public void writeSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            compound.func_74768_a("BurnTime", this.currentBurnTime);
            compound.func_74768_a("MaxBurnTime", this.maxBurnTime);
        }
        this.storage.writeToNBT(compound);
        super.writeSyncableNBT(compound, type);
    }

    @Override
    public void readSyncableNBT(NBTTagCompound compound, TileEntityBase.NBTType type) {
        if (type != TileEntityBase.NBTType.SAVE_BLOCK) {
            this.currentBurnTime = compound.func_74762_e("BurnTime");
            this.maxBurnTime = compound.func_74762_e("MaxBurnTime");
        }
        this.storage.readFromNBT(compound);
        super.readSyncableNBT(compound, type);
    }

    @Override
    public void updateEntity() {
        super.updateEntity();
        if (!this.field_145850_b.field_72995_K) {
            boolean flag;
            boolean bl = flag = this.currentBurnTime > 0;
            if (this.currentBurnTime > 0) {
                --this.currentBurnTime;
                this.storage.receiveEnergy(30, false);
            }
            if (!this.isRedstonePowered && this.currentBurnTime <= 0 && StackUtil.isValid(this.slots[0]) && TileEntityFurnace.func_145952_a((ItemStack)this.slots[0]) > 0 && this.storage.getEnergyStored() < this.storage.getMaxEnergyStored()) {
                int burnTime;
                this.maxBurnTime = burnTime = TileEntityFurnace.func_145952_a((ItemStack)this.slots[0]);
                this.currentBurnTime = burnTime;
                this.slots[0] = StackUtil.addStackSize(this.slots[0], -1, true);
            }
            if (flag != this.currentBurnTime > 0 || this.lastCompare != this.getComparatorStrength()) {
                this.lastCompare = this.getComparatorStrength();
                this.func_70296_d();
            }
            if ((this.storage.getEnergyStored() != this.lastEnergy || this.currentBurnTime != this.lastCurrentBurnTime || this.lastBurnTime != this.maxBurnTime) && this.sendUpdateWithInterval()) {
                this.lastEnergy = this.storage.getEnergyStored();
                this.lastCurrentBurnTime = this.currentBurnTime;
                this.lastBurnTime = this.currentBurnTime;
            }
        }
    }

    @Override
    public int getComparatorStrength() {
        float calc = (float)this.storage.getEnergyStored() / (float)this.storage.getMaxEnergyStored() * 15.0f;
        return (int)calc;
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        return TileEntityFurnace.func_145952_a((ItemStack)stack) > 0;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return TileEntityFurnace.func_145952_a((ItemStack)this.slots[0]) <= 0;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.storage.extractEnergy(maxReceive, simulate);
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int getEnergyToSplitShare() {
        return this.storage.getEnergyStored();
    }

    @Override
    public boolean doesShareEnergy() {
        return true;
    }

    @Override
    public EnumFacing[] getEnergyShareSides() {
        return EnumFacing.values();
    }
}

