/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.misc;

import de.ellpeck.actuallyadditions.api.laser.IConnectionPair;
import de.ellpeck.actuallyadditions.api.laser.LaserType;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class ConnectionPair
implements IConnectionPair {
    private final BlockPos[] positions = new BlockPos[2];
    private boolean suppressConnectionRender;
    private LaserType type;

    public ConnectionPair() {
    }

    public ConnectionPair(BlockPos firstRelay, BlockPos secondRelay, LaserType type, boolean suppressConnectionRender) {
        this.positions[0] = firstRelay;
        this.positions[1] = secondRelay;
        this.suppressConnectionRender = suppressConnectionRender;
        this.type = type;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        if (compound != null) {
            for (int i = 0; i < this.positions.length; ++i) {
                int anX = compound.func_74762_e("x" + i);
                int aY = compound.func_74762_e("y" + i);
                int aZ = compound.func_74762_e("z" + i);
                this.positions[i] = new BlockPos(anX, aY, aZ);
            }
            this.suppressConnectionRender = compound.func_74767_n("SuppressRender");
            String typeStrg = compound.func_74779_i("Type");
            if (typeStrg != null && !typeStrg.isEmpty()) {
                this.type = LaserType.valueOf(typeStrg);
            }
        }
    }

    @Override
    public BlockPos[] getPositions() {
        return this.positions;
    }

    @Override
    public boolean doesSuppressRender() {
        return this.suppressConnectionRender;
    }

    @Override
    public LaserType getType() {
        return this.type;
    }

    @Override
    public boolean contains(BlockPos relay) {
        for (BlockPos position : this.positions) {
            if (position == null || !position.equals((Object)relay)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return (this.positions[0] == null ? "-" : this.positions[0].toString()) + " | " + (this.positions[1] == null ? "-" : this.positions[1].toString());
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        for (int i = 0; i < this.positions.length; ++i) {
            BlockPos relay = this.positions[i];
            compound.func_74768_a("x" + i, relay.func_177958_n());
            compound.func_74768_a("y" + i, relay.func_177956_o());
            compound.func_74768_a("z" + i, relay.func_177952_p());
        }
        if (this.type != null) {
            compound.func_74778_a("Type", this.type.name());
        }
        compound.func_74757_a("SuppressRender", this.suppressConnectionRender);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectionPair) {
            ConnectionPair pair = (ConnectionPair)obj;
            for (int i = 0; i < this.positions.length; ++i) {
                if (this.positions[i] != pair.positions[i] && (this.positions[i] == null || !this.positions[i].equals((Object)pair.positions[i]))) continue;
                return true;
            }
        }
        return super.equals(obj);
    }
}

