/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.inventory.gui;

import de.ellpeck.actuallyadditions.mod.inventory.gui.GuiInputter;
import de.ellpeck.actuallyadditions.mod.util.AssetUtil;
import java.text.NumberFormat;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.client.config.GuiUtils;

public class FluidDisplay
extends Gui {
    private FluidTank fluidReference;
    private Fluid oldFluid;
    private int x;
    private int y;
    private boolean outline;
    private ResourceLocation resLoc;
    private boolean drawTextNextTo;

    public FluidDisplay(int x, int y, FluidTank fluidReference, boolean outline, boolean drawTextNextTo) {
        this.setData(x, y, fluidReference, outline, drawTextNextTo);
    }

    public FluidDisplay(int x, int y, FluidTank fluidReference) {
        this(x, y, fluidReference, false, false);
    }

    public void setData(int x, int y, FluidTank fluidReference, boolean outline, boolean drawTextNextTo) {
        this.x = x;
        this.y = y;
        this.fluidReference = fluidReference;
        this.outline = outline;
        this.drawTextNextTo = drawTextNextTo;
    }

    public void draw() {
        Fluid fluid;
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_110434_K().func_110577_a(AssetUtil.GUI_INVENTORY_LOCATION);
        int barX = this.x;
        int barY = this.y;
        if (this.outline) {
            this.func_73729_b(this.x, this.y, 52, 163, 26, 93);
            barX += 4;
            barY += 4;
        }
        this.func_73729_b(barX, barY, 0, 171, 18, 85);
        FluidStack stack = this.fluidReference.getFluid();
        Fluid fluid2 = fluid = stack == null ? null : stack.getFluid();
        if (this.resLoc == null || this.oldFluid != fluid) {
            this.oldFluid = fluid;
            if (fluid != null && fluid.getStill() != null) {
                this.resLoc = new ResourceLocation(fluid.getStill().func_110624_b(), "textures/" + fluid.getStill().func_110623_a() + ".png");
            }
        }
        if (stack != null && fluid != null && this.resLoc != null) {
            mc.func_110434_K().func_110577_a(this.resLoc);
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_179118_c();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            int i = this.fluidReference.getFluidAmount() * 83 / this.fluidReference.getCapacity();
            GuiInputter.func_146110_a((int)(barX + 1), (int)(barY + 84 - i), (float)36.0f, (float)172.0f, (int)16, (int)i, (float)16.0f, (float)512.0f);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179121_F();
        }
        if (this.drawTextNextTo) {
            this.func_73731_b(mc.field_71466_p, this.getOverlayText(), barX + 25, barY + 78, 0xFFFFFF);
        }
    }

    public void drawOverlay(int mouseX, int mouseY) {
        if (mouseX >= this.x && mouseY >= this.y && mouseX < this.x + (this.outline ? 26 : 18) && mouseY < this.y + (this.outline ? 93 : 85)) {
            Minecraft mc = Minecraft.func_71410_x();
            GuiUtils.drawHoveringText(Collections.singletonList(this.getOverlayText()), (int)mouseX, (int)mouseY, (int)mc.field_71443_c, (int)mc.field_71440_d, (int)-1, (FontRenderer)mc.field_71466_p);
        }
    }

    private String getOverlayText() {
        NumberFormat format = NumberFormat.getInstance();
        FluidStack stack = this.fluidReference.getFluid();
        String cap = format.format(this.fluidReference.getCapacity());
        return stack == null || stack.getFluid() == null ? "0/" + cap + " mB" : format.format(this.fluidReference.getFluidAmount()) + "/" + cap + " mB " + stack.getLocalizedName();
    }
}

