/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.blocks;

import de.ellpeck.actuallyadditions.mod.blocks.BlockColoredLamp;
import de.ellpeck.actuallyadditions.mod.blocks.InitBlocks;
import de.ellpeck.actuallyadditions.mod.blocks.base.BlockBase;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockLampPowerer
extends BlockBase {
    private static final PropertyInteger META = PropertyInteger.func_177719_a((String)"meta", (int)0, (int)5);

    public BlockLampPowerer(String name) {
        super(Material.field_151576_e, name);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149711_c(1.5f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        this.updateLamp(worldIn, pos);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.updateLamp(world, pos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase player, ItemStack stack) {
        int rotation = BlockPistonBase.func_185647_a((BlockPos)pos, (EntityLivingBase)player).ordinal();
        world.func_180501_a(pos, this.func_176203_a(rotation), 2);
        super.func_180633_a(world, pos, state, player, stack);
    }

    private void updateLamp(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            IBlockState state = world.func_180495_p(pos);
            BlockPos coords = pos.func_177972_a(WorldUtil.getDirectionByPistonRotation(state.func_177230_c().func_176201_c(state)));
            this.updateLampsAtPos(world, coords, world.func_175687_A(pos) > 0, new ArrayList<BlockPos>());
        }
    }

    private void updateLampsAtPos(World world, BlockPos pos, boolean powered, List<BlockPos> updatedAlready) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof BlockColoredLamp) {
            boolean isOn = ((BlockColoredLamp)block).isOn;
            int meta = block.func_176201_c(state);
            if (powered) {
                if (!isOn) {
                    world.func_180501_a(pos, InitBlocks.blockColoredLampOn.func_176203_a(meta), 2);
                }
            } else if (isOn) {
                world.func_180501_a(pos, InitBlocks.blockColoredLamp.func_176203_a(meta), 2);
            }
            this.updateSurrounding(world, pos, powered, updatedAlready);
        }
    }

    private void updateSurrounding(World world, BlockPos pos, boolean powered, List<BlockPos> updatedAlready) {
        for (EnumFacing side : EnumFacing.values()) {
            BlockPos offset = pos.func_177972_a(side);
            if (updatedAlready.contains(offset)) continue;
            updatedAlready.add(pos);
            this.updateLampsAtPos(world, offset, powered, updatedAlready);
        }
    }

    @Override
    public EnumRarity getRarity(ItemStack stack) {
        return EnumRarity.RARE;
    }

    @Override
    protected PropertyInteger getMetaProperty() {
        return META;
    }
}

