/*
 * Decompiled with CFR 0.152.
 */
package com.renevo.nethercore.waila;

import com.renevo.nethercore.blocks.BlockLightRod;
import com.renevo.nethercore.blocks.BlockNetherFurnace;
import com.renevo.nethercore.blocks.NetherCoreBlocks;
import com.renevo.nethercore.item.NetherCoreItems;
import com.renevo.nethercore.tileentity.TileEntityNetherFurnace;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public final class WailaDataProvider
implements IWailaDataProvider {
    public static void callbackRegister(IWailaRegistrar register) {
        WailaDataProvider instance = new WailaDataProvider();
        register.registerStackProvider((IWailaDataProvider)instance, BlockLightRod.class);
        register.registerBodyProvider((IWailaDataProvider)instance, BlockNetherFurnace.class);
    }

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (accessor.getBlock() == NetherCoreBlocks.blockLightRod) {
            return NetherCoreItems.netherRod;
        }
        return new ItemStack(accessor.getBlockState().func_177230_c());
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        TileEntity te;
        if (accessor.getBlock() instanceof BlockNetherFurnace && (te = accessor.getWorld().func_175625_s(accessor.getPosition())) instanceof TileEntityNetherFurnace) {
            TileEntityNetherFurnace furnace = (TileEntityNetherFurnace)te;
            currenttip.add(SpecialChars.ITALIC + Integer.toString(this.getCookProgressScaled(furnace)) + "% Complete");
        }
        return currenttip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return currenttip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        return tag;
    }

    private int getCookProgressScaled(TileEntityNetherFurnace tileFurnace) {
        int cookTime = tileFurnace.func_174887_a_(2);
        int totalCookTime = tileFurnace.func_174887_a_(3);
        return totalCookTime != 0 && cookTime != 0 ? cookTime / totalCookTime : 0;
    }
}

