/*
 * Decompiled with CFR 0.152.
 */
package com.renevo.nethercore.tileentity;

import com.renevo.nethercore.Util;
import com.renevo.nethercore.blocks.BlockNetherFurnace;
import com.renevo.nethercore.inventory.ContainerNetherFurnace;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileEntityNetherFurnace
extends TileEntityLockable
implements ITickable,
ISidedInventory {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{1};
    private ItemStack[] furnaceItemStacks = new ItemStack[2];
    private int furnaceBurnTime = 0;
    private int currentItemBurnTime = 0;
    private int cookTime;
    private int totalCookTime;
    private String furnaceCustomName;
    IItemHandler handlerTop = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
    IItemHandler handlerBottom = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
    IItemHandler handlerSides = new EmptyHandler();

    public int func_70302_i_() {
        return this.furnaceItemStacks.length;
    }

    public ItemStack func_70301_a(int slotIndex) {
        return this.furnaceItemStacks[slotIndex];
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        if (this.furnaceItemStacks[slotIndex] != null) {
            if (this.furnaceItemStacks[slotIndex].field_77994_a <= amount) {
                ItemStack itemstack = this.furnaceItemStacks[slotIndex];
                this.furnaceItemStacks[slotIndex] = null;
                return itemstack;
            }
            ItemStack itemstack = this.furnaceItemStacks[slotIndex].func_77979_a(amount);
            if (this.furnaceItemStacks[slotIndex].field_77994_a == 0) {
                this.furnaceItemStacks[slotIndex] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slotIndex) {
        if (this.furnaceItemStacks[slotIndex] != null) {
            ItemStack itemstack = this.furnaceItemStacks[slotIndex];
            this.furnaceItemStacks[slotIndex] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        boolean canInsert = itemStack != null && itemStack.func_77969_a(this.furnaceItemStacks[slotIndex]) && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)this.furnaceItemStacks[slotIndex]);
        this.furnaceItemStacks[slotIndex] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
        if (slotIndex == 0 && !canInsert) {
            this.totalCookTime = this.getCookTime(itemStack);
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.furnaceCustomName : "container." + Util.prefix("nether_furnace");
    }

    public boolean func_145818_k_() {
        return this.furnaceCustomName != null && this.furnaceCustomName.length() > 0;
    }

    public void setCustomInventoryName(String name) {
        this.furnaceCustomName = name;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList nbttaglist = tagCompound.func_150295_c("Items", 10);
        this.furnaceItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            byte j = nbttagcompound.func_74771_c("Slot");
            if (j < 0 || j >= this.furnaceItemStacks.length) continue;
            this.furnaceItemStacks[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
        }
        this.furnaceBurnTime = tagCompound.func_74765_d("BurnTime");
        this.cookTime = tagCompound.func_74765_d("CookTime");
        this.totalCookTime = tagCompound.func_74765_d("CookTimeTotal");
        this.currentItemBurnTime = this.furnaceBurnTime;
        if (tagCompound.func_150297_b("CustomName", 8)) {
            this.furnaceCustomName = tagCompound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        NBTTagCompound result = super.func_189515_b(tagCompound);
        tagCompound.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        tagCompound.func_74777_a("CookTime", (short)this.cookTime);
        tagCompound.func_74777_a("CookTimeTotal", (short)this.totalCookTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.furnaceItemStacks.length; ++i) {
            if (this.furnaceItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.furnaceItemStacks[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        tagCompound.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            tagCompound.func_74778_a("CustomName", this.furnaceCustomName);
        }
        return result;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    public void func_73660_a() {
        boolean burning = this.isBurning();
        boolean updated = false;
        int burnTime = this.furnaceBurnTime;
        int burnSpeed = this.getBurnSpeed();
        this.currentItemBurnTime = this.furnaceItemStacks[0] != null ? 300 : 0;
        double burnMultiplier = Math.floor((double)burnSpeed / 5.0 * 300.0);
        int n = this.furnaceBurnTime = this.currentItemBurnTime > 0 ? (int)burnMultiplier : 0;
        if (!this.field_145850_b.field_72995_K) {
            if (this.furnaceBurnTime != burnTime) {
                updated = true;
            }
            if (this.isBurning() && this.furnaceItemStacks[0] != null) {
                if (this.isBurning() && this.canSmelt()) {
                    this.cookTime += burnSpeed;
                    if (this.cookTime >= this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime(this.furnaceItemStacks[0]);
                        this.smeltItem();
                        updated = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (burning != this.isBurning()) {
                updated = true;
                BlockNetherFurnace.setState(this.isBurning(), this.field_145850_b, this.field_174879_c);
            }
        }
        if (updated) {
            this.func_70296_d();
        }
    }

    private int getBurnSpeed() {
        int speed = this.field_145850_b.field_73011_w.func_177500_n() ? 1 : 0;
        IBlockState eastBlockState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177974_f());
        IBlockState westBlockState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177976_e());
        IBlockState northBlockState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177978_c());
        IBlockState southBlockState = this.field_145850_b.func_180495_p(this.field_174879_c.func_177968_d());
        if (eastBlockState.func_177230_c() == Blocks.field_150353_l || eastBlockState.func_177230_c() == Blocks.field_150356_k) {
            ++speed;
        }
        if (westBlockState.func_177230_c() == Blocks.field_150353_l || westBlockState.func_177230_c() == Blocks.field_150356_k) {
            ++speed;
        }
        if (northBlockState.func_177230_c() == Blocks.field_150353_l || northBlockState.func_177230_c() == Blocks.field_150356_k) {
            ++speed;
        }
        if (southBlockState.func_177230_c() == Blocks.field_150353_l || southBlockState.func_177230_c() == Blocks.field_150356_k) {
            ++speed;
        }
        return speed;
    }

    public int getCookTime(ItemStack itemStack) {
        return 800;
    }

    private boolean canSmelt() {
        if (this.furnaceItemStacks[0] == null) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.furnaceItemStacks[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.furnaceItemStacks[1] == null) {
            return true;
        }
        if (!this.furnaceItemStacks[1].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.furnaceItemStacks[1].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.furnaceItemStacks[1].func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.furnaceItemStacks[0]);
            if (this.furnaceItemStacks[1] == null) {
                this.furnaceItemStacks[1] = itemstack.func_77946_l();
            } else if (this.furnaceItemStacks[1].func_77973_b() == itemstack.func_77973_b()) {
                this.furnaceItemStacks[1].field_77994_a += itemstack.field_77994_a;
            }
            --this.furnaceItemStacks[0].field_77994_a;
            if (this.furnaceItemStacks[0].field_77994_a <= 0) {
                this.furnaceItemStacks[0] = null;
            }
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemStack) {
        return slotIndex != 2;
    }

    public int[] func_180463_a(EnumFacing facing) {
        if (facing == EnumFacing.DOWN) {
            return slotsBottom;
        }
        if (facing == EnumFacing.UP) {
            return slotsTop;
        }
        return new int[0];
    }

    public boolean func_180462_a(int slotIndex, ItemStack itemStack, EnumFacing facing) {
        return this.func_94041_b(slotIndex, itemStack);
    }

    public boolean func_180461_b(int slotIndex, ItemStack itemStack, EnumFacing facing) {
        return true;
    }

    public String func_174875_k() {
        return Util.resource("nether_furnace");
    }

    public Container func_174876_a(InventoryPlayer inventory, EntityPlayer player) {
        return new ContainerNetherFurnace(inventory, (IInventory)this);
    }

    public int func_174887_a_(int fieldId) {
        switch (fieldId) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int fieldId, int fieldValue) {
        switch (fieldId) {
            case 0: {
                this.furnaceBurnTime = fieldValue;
                break;
            }
            case 1: {
                this.currentItemBurnTime = fieldValue;
                break;
            }
            case 2: {
                this.cookTime = fieldValue;
                break;
            }
            case 3: {
                this.totalCookTime = fieldValue;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.furnaceItemStacks.length; ++i) {
            this.furnaceItemStacks[i] = null;
        }
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (facing == null || capability != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)super.getCapability(capability, facing);
        }
        switch (facing) {
            case DOWN: {
                return (T)this.handlerBottom;
            }
            case UP: {
                return (T)this.handlerTop;
            }
        }
        return (T)this.handlerSides;
    }
}

