/*
 * Decompiled with CFR 0.152.
 */
package com.renevo.nethercore.blocks;

import com.renevo.nethercore.NetherCoreRegistry;
import com.renevo.nethercore.Util;
import com.renevo.nethercore.blocks.BlockCompressedNetherrack;
import com.renevo.nethercore.blocks.BlockDoubleStoneSlab;
import com.renevo.nethercore.blocks.BlockHalfStoneSlab;
import com.renevo.nethercore.blocks.BlockLightRod;
import com.renevo.nethercore.blocks.BlockNetherFurnace;
import com.renevo.nethercore.blocks.BlockNetherGrass;
import com.renevo.nethercore.blocks.BlockNetherOre;
import com.renevo.nethercore.blocks.BlockNetherStairs;
import com.renevo.nethercore.blocks.BlockNetherStone;
import com.renevo.nethercore.blocks.BlockOpaqueGlass;
import com.renevo.nethercore.blocks.BlockStoneSlab;
import com.renevo.nethercore.blocks.BlockStoneWall;
import com.renevo.nethercore.blocks.EnumBlockSlab;
import com.renevo.nethercore.blocks.EnumBlockWall;
import com.renevo.nethercore.item.ItemStoneSlab;
import com.renevo.nethercore.tileentity.TileEntityNetherFurnace;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import slimeknights.mantle.block.EnumBlock;
import slimeknights.mantle.item.ItemBlockMeta;

public final class NetherCoreBlocks {
    public static final SoundType soundTypeNetherStone = SoundType.field_185851_d;
    public static BlockNetherOre blockNetherOre;
    public static BlockCompressedNetherrack blockCompressedNetherrack;
    public static BlockNetherStone blockNetherStone;
    public static BlockNetherStairs blockNetherStoneBrickStairs;
    public static BlockNetherStairs blockNetherStoneCobbleStairs;
    public static BlockNetherStairs blockNetherStoneStairs;
    public static BlockStoneSlab blockNetherHalfSlab;
    public static BlockStoneSlab blockNetherDoubleSlab;
    public static BlockStoneWall blockNetherStoneWall;
    public static BlockNetherGrass blockNetherGrass;
    public static BlockNetherFurnace blockNetherFurnace;
    public static BlockNetherFurnace blockNetherFurnaceLit;
    public static BlockLightRod blockLightRod;
    public static BlockOpaqueGlass blockSoulGlass;
    public static Block blockNetherCoal;

    private NetherCoreBlocks() {
    }

    public static void init() {
        blockNetherOre = NetherCoreBlocks.registerEnumBlock(new BlockNetherOre(), "ore");
        blockCompressedNetherrack = NetherCoreBlocks.registerEnumBlock(new BlockCompressedNetherrack(), "compressed_netherrack");
        blockNetherStone = NetherCoreBlocks.registerEnumBlock(new BlockNetherStone(), "stone");
        blockNetherStoneStairs = NetherCoreBlocks.registerBlock(new BlockNetherStairs(blockNetherStone.func_176223_P().func_177226_a(BlockNetherStone.TYPE, (Comparable)((Object)BlockNetherStone.StoneType.STONE))), "stairs_stone");
        blockNetherStoneCobbleStairs = NetherCoreBlocks.registerBlock(new BlockNetherStairs(blockNetherStone.func_176223_P().func_177226_a(BlockNetherStone.TYPE, (Comparable)((Object)BlockNetherStone.StoneType.COBBLE))), "stairs_stone_cobble");
        blockNetherStoneBrickStairs = NetherCoreBlocks.registerBlock(new BlockNetherStairs(blockNetherStone.func_176223_P().func_177226_a(BlockNetherStone.TYPE, (Comparable)((Object)BlockNetherStone.StoneType.BRICK))), "stairs_stone_brick");
        BlockHalfStoneSlab halfStoneSlab = new BlockHalfStoneSlab();
        BlockDoubleStoneSlab doubleStoneSlab = new BlockDoubleStoneSlab();
        blockNetherHalfSlab = NetherCoreBlocks.registerEnumBlock(halfStoneSlab, halfStoneSlab, doubleStoneSlab, "slab_half_stone");
        blockNetherDoubleSlab = NetherCoreBlocks.registerEnumBlock(doubleStoneSlab, halfStoneSlab, doubleStoneSlab, "slab_double_stone");
        blockNetherStoneWall = NetherCoreBlocks.registerEnumBlock(new BlockStoneWall((Block)blockNetherStone), "wall_stone");
        blockNetherGrass = NetherCoreBlocks.registerBlock(new BlockNetherGrass(), "nether_grass");
        blockNetherFurnace = NetherCoreBlocks.registerBlock(new BlockNetherFurnace(false), "nether_furnace");
        blockNetherFurnaceLit = NetherCoreBlocks.registerBlock(new BlockNetherFurnace(true), "nether_furnace_lit");
        blockLightRod = NetherCoreBlocks.registerBlock(new BlockLightRod(), "nether_rod");
        blockSoulGlass = NetherCoreBlocks.registerBlock(new BlockOpaqueGlass(), "soul_glass");
        blockNetherCoal = NetherCoreBlocks.registerBlock(new Block(Material.field_151576_e, MapColor.field_151645_D).func_149711_c(5.0f).func_149752_b(10.0f).func_149647_a((CreativeTabs)NetherCoreRegistry.tabNetherCore), "nether_coal_block");
        GameRegistry.registerTileEntity(TileEntityNetherFurnace.class, (String)"nether_furnace");
    }

    private static <T extends EnumBlock<?>> T registerEnumBlock(T block, String name) {
        NetherCoreBlocks.registerBlock(block, (ItemBlock)new ItemBlockMeta(block), name);
        ItemBlockMeta.setMappingProperty(block, (IProperty)block.prop);
        return block;
    }

    private static <T extends EnumBlockSlab<?>> T registerEnumBlock(T block, T halfBlock, T fullBlock, String name) {
        if (block == halfBlock) {
            NetherCoreBlocks.registerBlock(block, (ItemBlock)new ItemStoneSlab((Block)block, halfBlock, fullBlock), name);
        } else {
            NetherCoreBlocks.registerBlock(block, (ItemBlock)new ItemBlockMeta(fullBlock), name);
            ItemBlockMeta.setMappingProperty(block, block.prop);
        }
        return block;
    }

    private static <T extends EnumBlockWall<?>> T registerEnumBlock(T block, String name) {
        NetherCoreBlocks.registerBlock(block, (ItemBlock)new ItemBlockMeta(block), name);
        ItemBlockMeta.setMappingProperty(block, block.prop);
        return block;
    }

    private static <T extends Block> T registerBlock(T block, String name) {
        NetherCoreBlocks.registerBlock(block, new ItemBlock(block), name);
        return block;
    }

    protected static <T extends Block> T registerBlock(T block, ItemBlock itemBlock, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Block: %s", name));
        }
        String prefixedName = Util.prefix(name);
        block.func_149663_c(prefixedName);
        itemBlock.func_77655_b(prefixedName);
        NetherCoreBlocks.register(block, name);
        NetherCoreBlocks.register(itemBlock, name);
        return block;
    }

    protected static <T extends IForgeRegistryEntry<?>> T register(T thing, String name) {
        thing.setRegistryName(Util.getResource(name));
        GameRegistry.register(thing);
        return thing;
    }
}

