/*
 * Decompiled with CFR 0.152.
 */
package com.renevo.nethercore.blocks;

import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EnumBlockSlab<E extends Enum<E> & IStringSerializable>
extends BlockSlab {
    private final E[] values;
    public static final PropertyBool SEAMLESS = PropertyBool.func_177716_a((String)"seamless");
    public final PropertyEnum<E> prop;
    private static PropertyEnum<?> tmp;

    public EnumBlockSlab(Material material, PropertyEnum<E> prop, Class<E> clazz) {
        super(EnumBlockSlab.preInit(material, prop));
        this.prop = prop;
        this.values = (Enum[])clazz.getEnumConstants();
    }

    public abstract boolean func_176552_j();

    public abstract Block halfSlab();

    public abstract Block fullSlab();

    public Item func_180660_a(IBlockState blockState, Random random, int fortune) {
        return Item.func_150898_a((Block)this.halfSlab());
    }

    private static Material preInit(Material material, PropertyEnum<?> property) {
        tmp = property;
        return material;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        if (!this.func_176552_j()) {
            for (E type : this.values) {
                list.add(new ItemStack((Block)this, 1, ((IEnumMeta)type).getMeta()));
            }
        }
    }

    protected BlockStateContainer func_180661_e() {
        return this.func_176552_j() ? new BlockStateContainer((Block)this, new IProperty[]{SEAMLESS, this.prop == null ? tmp : this.prop}) : new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, this.prop == null ? tmp : this.prop});
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState blockState = this.func_176223_P().func_177226_a(this.prop, this.fromMeta(meta));
        blockState = this.func_176552_j() ? blockState.func_177226_a((IProperty)SEAMLESS, (Comparable)Boolean.valueOf((meta & 8) != 0)) : blockState.func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        return blockState;
    }

    public int func_176201_c(IBlockState state) {
        int stateMeta = 0;
        int meta = stateMeta | ((IEnumMeta)((Object)((Enum)((Object)state.func_177229_b(this.prop))))).getMeta();
        if (this.func_176552_j()) {
            if (((Boolean)state.func_177229_b((IProperty)SEAMLESS)).booleanValue()) {
                meta |= 8;
            }
        } else if (state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
            meta |= 8;
        }
        return meta;
    }

    public int func_180651_a(IBlockState state) {
        return ((IEnumMeta)((Object)((Enum)((Object)state.func_177229_b(this.prop))))).getMeta();
    }

    protected E fromMeta(int meta) {
        if (meta < 0 || meta >= this.values.length) {
            meta = 0;
        }
        return this.values[meta];
    }

    public IProperty<?> func_176551_l() {
        return this.prop;
    }

    public Comparable<?> func_185674_a(ItemStack itemStack) {
        int meta = itemStack.func_77960_j() & 7;
        Object[] values = this.prop.func_177700_c().toArray();
        if (meta < 0 || meta >= values.length) {
            meta = 0;
        }
        return (Enum)values[meta];
    }

    public String func_150002_b(int meta) {
        return super.func_149739_a() + '.' + ((IStringSerializable)this.fromMeta(meta)).func_176610_l().toLowerCase(Locale.US);
    }

    public static interface IEnumMeta {
        public int getMeta();
    }
}

