/*
 * Decompiled with CFR 0.152.
 */
package com.renevo.nethercore.blocks;

import com.renevo.nethercore.NetherCoreRegistry;
import com.renevo.nethercore.blocks.NetherCoreBlocks;
import com.renevo.nethercore.item.NetherCoreItems;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import slimeknights.mantle.block.EnumBlock;

public class BlockNetherOre
extends EnumBlock<OreTypes> {
    public static final PropertyEnum<OreTypes> TYPE = PropertyEnum.func_177709_a((String)"type", OreTypes.class);

    public BlockNetherOre() {
        this(Material.field_151576_e);
    }

    public BlockNetherOre(Material material) {
        super(material, TYPE, OreTypes.class);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(NetherCoreBlocks.soundTypeNetherStone);
        this.setHarvestLevel("pickaxe", 2);
        this.func_149647_a((CreativeTabs)NetherCoreRegistry.tabNetherCore);
    }

    public boolean isFireSource(World world, BlockPos blockPos, EnumFacing facing) {
        return facing == EnumFacing.UP;
    }

    public int getExpDrop(IBlockState blockState, IBlockAccess world, BlockPos blockPos, int fortune) {
        OreTypes meta = OreTypes.values()[this.func_176201_c(blockState)];
        int xp = 0;
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        switch (meta) {
            case COAL: {
                return MathHelper.func_76136_a((Random)rand, (int)0, (int)2);
            }
            case REDSTONE: {
                return MathHelper.func_76136_a((Random)rand, (int)2, (int)5);
            }
            case LAPIS: {
                return MathHelper.func_76136_a((Random)rand, (int)2, (int)5);
            }
            case DIAMOND: {
                return MathHelper.func_76136_a((Random)rand, (int)3, (int)7);
            }
            case EMERALD: {
                return MathHelper.func_76136_a((Random)rand, (int)3, (int)7);
            }
            case NETHERCOAL: {
                return MathHelper.func_76136_a((Random)rand, (int)1, (int)3);
            }
        }
        return xp;
    }

    public Item func_180660_a(IBlockState blockState, Random random, int p_getItemDropped_3_) {
        OreTypes meta = OreTypes.values()[this.func_176201_c(blockState)];
        switch (meta) {
            case COAL: {
                return Items.field_151044_h;
            }
            case REDSTONE: {
                return Items.field_151137_ax;
            }
            case LAPIS: {
                return Items.field_151100_aR;
            }
            case DIAMOND: {
                return Items.field_151045_i;
            }
            case EMERALD: {
                return Items.field_151166_bC;
            }
            case NETHERCOAL: {
                return NetherCoreItems.netherCoal;
            }
        }
        return Item.func_150898_a((Block)this);
    }

    public int quantityDropped(IBlockState blockState, int bonus, Random random) {
        int dropCount = 1;
        Item dropped = this.func_180660_a(blockState, random, 0);
        if (dropped == Items.field_151100_aR) {
            dropCount = 4 + random.nextInt(5) + this.quantityDroppedWithBonus(4 + random.nextInt(5), bonus, random);
        }
        if (dropped == Items.field_151045_i || dropped == Items.field_151166_bC || dropped == Items.field_151044_h) {
            dropCount = 1 + this.quantityDroppedWithBonus(1, bonus, random);
        }
        if (dropped == Items.field_151137_ax) {
            dropCount = 4 + random.nextInt(2) + this.quantityDroppedWithBonus(4 + random.nextInt(2), bonus, random);
        }
        if (dropped == NetherCoreItems.netherCoal) {
            dropCount = this.quantityDroppedWithBonus(1, bonus, random);
        }
        return dropCount;
    }

    public int func_180651_a(IBlockState blockState) {
        OreTypes meta = OreTypes.values()[this.func_176201_c(blockState)];
        if (meta == OreTypes.LAPIS) {
            return EnumDyeColor.BLUE.func_176767_b();
        }
        if (meta == OreTypes.IRON || meta == OreTypes.GOLD) {
            return super.func_180651_a(blockState);
        }
        return 0;
    }

    public int quantityDroppedWithBonus(int baseRate, int bonus, Random random) {
        if (bonus > 0) {
            int i = random.nextInt(bonus + 2) - 1;
            if (i < 0) {
                i = 0;
            }
            return baseRate * (i + 1);
        }
        return baseRate;
    }

    public boolean canCreatureSpawn(IBlockState blockState, IBlockAccess blockAccess, BlockPos blockPos, EntityLiving.SpawnPlacementType spawnPlacementType) {
        OreTypes meta = OreTypes.values()[this.func_176201_c(blockAccess.func_180495_p(blockPos))];
        return meta != OreTypes.NETHERCOAL;
    }

    public static enum OreTypes implements IStringSerializable,
    EnumBlock.IEnumMeta
    {
        COAL,
        IRON,
        GOLD,
        REDSTONE,
        LAPIS,
        DIAMOND,
        EMERALD,
        NETHERCOAL;

        public final int meta = this.ordinal();

        public String func_176610_l() {
            return this.toString().toLowerCase(Locale.US);
        }

        public int getMeta() {
            return this.meta;
        }
    }
}

