/*
 * Decompiled with CFR 0.152.
 */
package com.renevo.nethercore.blocks;

import com.google.common.base.Predicate;
import com.renevo.nethercore.NetherCore;
import com.renevo.nethercore.NetherCoreRegistry;
import com.renevo.nethercore.blocks.NetherCoreBlocks;
import com.renevo.nethercore.tileentity.TileEntityNetherFurnace;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockNetherFurnace
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    private final boolean isBurning;
    private static boolean keepInventory;

    protected BlockNetherFurnace(boolean isBurning) {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149711_c(3.5f);
        this.func_149672_a(NetherCoreBlocks.soundTypeNetherStone);
        this.isBurning = isBurning;
        if (!this.isBurning) {
            this.func_149647_a((CreativeTabs)NetherCoreRegistry.tabNetherCore);
        }
        if (this.isBurning) {
            this.func_149715_a(0.875f);
        }
    }

    public Item func_180660_a(IBlockState blockState, Random random, int fortune) {
        return Item.func_150898_a((Block)NetherCoreBlocks.blockNetherFurnace);
    }

    public void func_176213_c(World world, BlockPos blockPos, IBlockState blockState) {
        this.setDefaultFacing(world, blockPos, blockState);
    }

    private void setDefaultFacing(World world, BlockPos blockPos, IBlockState blockState) {
        if (!world.field_72995_K) {
            IBlockState blockNorth = world.func_180495_p(blockPos.func_177978_c());
            IBlockState blockSouth = world.func_180495_p(blockPos.func_177968_d());
            IBlockState blockWest = world.func_180495_p(blockPos.func_177976_e());
            IBlockState blockEast = world.func_180495_p(blockPos.func_177974_f());
            EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)FACING);
            if (facing == EnumFacing.NORTH && blockNorth.func_185913_b() && !blockSouth.func_185913_b()) {
                facing = EnumFacing.SOUTH;
            } else if (facing == EnumFacing.SOUTH && blockSouth.func_185913_b() && !blockNorth.func_185913_b()) {
                facing = EnumFacing.NORTH;
            } else if (facing == EnumFacing.WEST && blockWest.func_185913_b() && !blockEast.func_185913_b()) {
                facing = EnumFacing.EAST;
            } else if (facing == EnumFacing.EAST && blockEast.func_185913_b() && !blockWest.func_185913_b()) {
                facing = EnumFacing.WEST;
            }
            world.func_180501_a(blockPos, blockState.func_177226_a((IProperty)FACING, (Comparable)facing), 2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState blockState, World world, BlockPos blockPos, Random random) {
        if (this.isBurning) {
            EnumFacing facing = (EnumFacing)blockState.func_177229_b((IProperty)FACING);
            double x = (double)blockPos.func_177958_n() + 0.5;
            double y = (double)blockPos.func_177956_o() + random.nextDouble() * 6.0 / 16.0;
            double z = (double)blockPos.func_177952_p() + 0.5;
            double offset = 0.52;
            double randomized = random.nextDouble() * 0.6 - 0.3;
            switch (facing) {
                case WEST: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x - offset, y, z + randomized, 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, x - offset, y, z + randomized, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case EAST: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + offset, y, z + randomized, 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, x + offset, y, z + randomized, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case NORTH: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + randomized, y, z - offset, 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, x + randomized, y, z - offset, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case SOUTH: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + randomized, y, z + offset, 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, x + randomized, y, z + offset, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos blockPos, IBlockState blockState, EntityPlayer player, EnumHand hand, ItemStack itemStack, EnumFacing facing, float x, float y, float z) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof TileEntityNetherFurnace) {
            player.openGui((Object)NetherCore.instance, 0, world, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        }
        return true;
    }

    public static void setState(boolean burning, World world, BlockPos blockPos) {
        IBlockState blockState = world.func_180495_p(blockPos);
        TileEntity tileEntity = world.func_175625_s(blockPos);
        keepInventory = true;
        if (burning) {
            world.func_180501_a(blockPos, NetherCoreBlocks.blockNetherFurnaceLit.func_176223_P().func_177226_a((IProperty)FACING, blockState.func_177229_b((IProperty)FACING)), 3);
            world.func_180501_a(blockPos, NetherCoreBlocks.blockNetherFurnaceLit.func_176223_P().func_177226_a((IProperty)FACING, blockState.func_177229_b((IProperty)FACING)), 3);
        } else {
            world.func_180501_a(blockPos, NetherCoreBlocks.blockNetherFurnace.func_176223_P().func_177226_a((IProperty)FACING, blockState.func_177229_b((IProperty)FACING)), 3);
            world.func_180501_a(blockPos, NetherCoreBlocks.blockNetherFurnace.func_176223_P().func_177226_a((IProperty)FACING, blockState.func_177229_b((IProperty)FACING)), 3);
        }
        keepInventory = false;
        if (tileEntity != null) {
            tileEntity.func_145829_t();
            world.func_175690_a(blockPos, tileEntity);
        }
    }

    public TileEntity func_149915_a(World world, int unk) {
        return new TileEntityNetherFurnace();
    }

    public IBlockState func_180642_a(World world, BlockPos blockPos, EnumFacing facing, float x, float y, float z, int unk, EntityLivingBase entity) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)entity.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World world, BlockPos blockPos, IBlockState blockState, EntityLivingBase entity, ItemStack itemStack) {
        TileEntity tileEntity;
        world.func_180501_a(blockPos, blockState.func_177226_a((IProperty)FACING, (Comparable)entity.func_174811_aO().func_176734_d()), 2);
        if (itemStack.func_82837_s() && (tileEntity = world.func_175625_s(blockPos)) instanceof TileEntityNetherFurnace) {
            ((TileEntityNetherFurnace)tileEntity).setCustomInventoryName(itemStack.func_82833_r());
        }
    }

    public void func_180663_b(World world, BlockPos blockPos, IBlockState blockState) {
        TileEntity tileEntity;
        if (!keepInventory && (tileEntity = world.func_175625_s(blockPos)) instanceof TileEntityNetherFurnace) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)blockPos, (IInventory)((TileEntityNetherFurnace)tileEntity));
            world.func_175666_e(blockPos, (Block)this);
        }
        super.func_180663_b(world, blockPos, blockState);
    }

    public boolean func_149740_M(IBlockState blockState) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos blockPos) {
        return Container.func_178144_a((TileEntity)world.func_175625_s(blockPos));
    }

    public EnumBlockRenderType func_149645_b(IBlockState blockState) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState blockState) {
        return ((EnumFacing)blockState.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }
}

