/*
 * Decompiled with CFR 0.152.
 */
package com.renevo.nethercore;

import com.renevo.nethercore.FuelHandler;
import com.renevo.nethercore.blocks.NetherCoreBlocks;
import com.renevo.nethercore.common.Config;
import com.renevo.nethercore.item.NetherCoreItems;
import com.renevo.nethercore.tconstruct.TinkersIntegration;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import slimeknights.mantle.client.CreativeTab;

public final class NetherCoreRegistry {
    public static CreativeTab tabNetherCore = new CreativeTab("NetherCore", new ItemStack(Blocks.field_150424_aL));

    private NetherCoreRegistry() {
    }

    public static void registerSmelting() {
        GameRegistry.addSmelting((ItemStack)NetherCoreItems.netherOreCoal.func_77946_l(), (ItemStack)new ItemStack(Items.field_151044_h, 2), (float)0.0f);
        GameRegistry.addSmelting((ItemStack)NetherCoreItems.netherOreIron.func_77946_l(), (ItemStack)new ItemStack(Blocks.field_150366_p, 2), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)NetherCoreItems.netherOreGold.func_77946_l(), (ItemStack)new ItemStack(Blocks.field_150352_o, 2), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)NetherCoreItems.netherOreRedstone.func_77946_l(), (ItemStack)new ItemStack(Items.field_151137_ax, 2), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)NetherCoreItems.netherOreLapis.func_77946_l(), (ItemStack)new ItemStack(Items.field_151100_aR, 2, EnumDyeColor.BLUE.func_176767_b()), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)NetherCoreItems.netherOreDiamond.func_77946_l(), (ItemStack)new ItemStack(Items.field_151045_i, 2), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)NetherCoreItems.netherOreEmerald.func_77946_l(), (ItemStack)new ItemStack(Items.field_151166_bC, 2), (float)0.2f);
        GameRegistry.addSmelting((ItemStack)NetherCoreItems.stoneCobble, (ItemStack)NetherCoreItems.stone, (float)0.2f);
        GameRegistry.addSmelting((ItemStack)NetherCoreItems.stoneBrick, (ItemStack)NetherCoreItems.stoneBrickCracked, (float)0.0f);
        if (Config.enableSoulGlassRecipe) {
            GameRegistry.addSmelting((Block)Blocks.field_150425_aM, (ItemStack)NetherCoreItems.soulGlass, (float)0.0f);
        }
        if (Config.enableSmeltedNetherStar) {
            GameRegistry.addSmelting((ItemStack)NetherCoreItems.compressedNetherrackOctuple, (ItemStack)new ItemStack(Items.field_151156_bN, 1), (float)10.0f);
        }
    }

    public static void registerOreDictionary() {
        OreDictionary.registerOre((String)"oreNetherCoal", (ItemStack)NetherCoreItems.netherOreCoal.func_77946_l());
        OreDictionary.registerOre((String)"oreNetherIron", (ItemStack)NetherCoreItems.netherOreIron.func_77946_l());
        OreDictionary.registerOre((String)"oreNetherGold", (ItemStack)NetherCoreItems.netherOreGold.func_77946_l());
        OreDictionary.registerOre((String)"oreNetherRedstone", (ItemStack)NetherCoreItems.netherOreRedstone.func_77946_l());
        OreDictionary.registerOre((String)"oreNetherLapis", (ItemStack)NetherCoreItems.netherOreLapis.func_77946_l());
        OreDictionary.registerOre((String)"oreNetherDiamond", (ItemStack)NetherCoreItems.netherOreDiamond.func_77946_l());
        OreDictionary.registerOre((String)"oreNetherEmerald", (ItemStack)NetherCoreItems.netherOreEmerald.func_77946_l());
        OreDictionary.registerOre((String)"oreNetherNetherCoal", (ItemStack)NetherCoreItems.netherOreNetherCoal.func_77946_l());
        OreDictionary.registerOre((String)"cobblestone", (ItemStack)NetherCoreItems.stoneCobble.func_77946_l());
    }

    public static void registerFuels() {
        GameRegistry.registerFuelHandler((IFuelHandler)new FuelHandler());
    }

    public static void registerRecipes() {
        ItemStack result = NetherCoreItems.stoneCobble.func_77946_l();
        result.field_77994_a = 1;
        GameRegistry.addRecipe((ItemStack)result, (Object[])new Object[]{"##", "##", Character.valueOf('#'), Blocks.field_150424_aL});
        result = NetherCoreItems.stoneBrick.func_77946_l();
        result.field_77994_a = 4;
        GameRegistry.addRecipe((ItemStack)result, (Object[])new Object[]{"##", "##", Character.valueOf('#'), NetherCoreItems.stone});
        result = NetherCoreItems.stoneRoad.func_77946_l();
        result.field_77994_a = 4;
        GameRegistry.addRecipe((ItemStack)result, (Object[])new Object[]{"##", "##", Character.valueOf('#'), NetherCoreItems.stoneBrick});
        result = NetherCoreItems.stoneCreeper.func_77946_l();
        result.field_77994_a = 1;
        GameRegistry.addRecipe((ItemStack)result, (Object[])new Object[]{"#", "G", Character.valueOf('#'), NetherCoreItems.stonePaver, Character.valueOf('G'), Items.field_151016_H});
        result = NetherCoreItems.stoneBrickSquare.func_77946_l();
        result.field_77994_a = 8;
        GameRegistry.addRecipe((ItemStack)result, (Object[])new Object[]{"###", "# #", "###", Character.valueOf('#'), NetherCoreItems.stoneBrick});
        result = NetherCoreItems.stoneBrickFancy.func_77946_l();
        result.field_77994_a = 5;
        GameRegistry.addRecipe((ItemStack)result, (Object[])new Object[]{"## ", " # ", " ##", Character.valueOf('#'), NetherCoreItems.stoneBrick});
        result = NetherCoreItems.stonePaver.func_77946_l();
        result.field_77994_a = 7;
        GameRegistry.addRecipe((ItemStack)result, (Object[])new Object[]{"###", " # ", "###", Character.valueOf('#'), NetherCoreItems.stoneBrick});
        if (Config.enableNetherSporeRecipe) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(NetherCoreItems.netherSpore), (Object[])new Object[]{"MGM", "WSW", "BGB", Character.valueOf('M'), Items.field_151064_bs, Character.valueOf('G'), Items.field_151073_bk, Character.valueOf('S'), Items.field_151014_N, Character.valueOf('B'), Items.field_151065_br, Character.valueOf('W'), Items.field_151075_bm});
        }
        if (Config.enableNetherFurnaceRecipe) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)NetherCoreBlocks.blockNetherFurnace), (Object[])new Object[]{"CCC", "CMC", "CCC", Character.valueOf('C'), NetherCoreItems.stoneCobble, Character.valueOf('M'), Items.field_151064_bs});
        }
        result = NetherCoreItems.netherRod.func_77946_l();
        result.field_77994_a = 4;
        GameRegistry.addRecipe((ItemStack)result, (Object[])new Object[]{"R", "B", Character.valueOf('R'), Items.field_151072_bj, Character.valueOf('B'), Blocks.field_150385_bj});
        NetherCoreRegistry.addCompressedRecipe(new ItemStack(NetherCoreItems.netherCoal), NetherCoreItems.netherCoalBlock);
        if (Config.enableCompressedNetherrackRecipes) {
            NetherCoreRegistry.addCompressedRecipe(new ItemStack(Blocks.field_150424_aL), NetherCoreItems.compressedNetherrackSingle);
            NetherCoreRegistry.addCompressedRecipe(NetherCoreItems.compressedNetherrackSingle, NetherCoreItems.compressedNetherrackDouble);
            NetherCoreRegistry.addCompressedRecipe(NetherCoreItems.compressedNetherrackDouble, NetherCoreItems.compressedNetherrackTriple);
            NetherCoreRegistry.addCompressedRecipe(NetherCoreItems.compressedNetherrackTriple, NetherCoreItems.compressedNetherrackQuadruple);
            NetherCoreRegistry.addCompressedRecipe(NetherCoreItems.compressedNetherrackQuadruple, NetherCoreItems.compressedNetherrackQuintuple);
            NetherCoreRegistry.addCompressedRecipe(NetherCoreItems.compressedNetherrackQuintuple, NetherCoreItems.compressedNetherrackSextuple);
            NetherCoreRegistry.addCompressedRecipe(NetherCoreItems.compressedNetherrackSextuple, NetherCoreItems.compressedNetherrackSeptuple);
            NetherCoreRegistry.addCompressedRecipe(NetherCoreItems.compressedNetherrackSeptuple, NetherCoreItems.compressedNetherrackOctuple);
        }
        NetherCoreRegistry.addSlabRecipe(NetherCoreItems.stone, NetherCoreItems.slabStone);
        NetherCoreRegistry.addSlabRecipe(NetherCoreItems.stoneCobble, NetherCoreItems.slabStoneCobble);
        NetherCoreRegistry.addSlabRecipe(NetherCoreItems.stoneBrick, NetherCoreItems.slabStoneBrick);
        NetherCoreRegistry.addSlabRecipe(NetherCoreItems.stoneRoad, NetherCoreItems.slabStoneRoad);
        NetherCoreRegistry.addStairRecipe(NetherCoreItems.stone, NetherCoreItems.stairsStone);
        NetherCoreRegistry.addStairRecipe(NetherCoreItems.stoneCobble, NetherCoreItems.stairsStoneCobble);
        NetherCoreRegistry.addStairRecipe(NetherCoreItems.stoneBrick, NetherCoreItems.stairsStoneBrick);
        NetherCoreRegistry.addWallRecipe(NetherCoreItems.stone, NetherCoreItems.wallStone, false);
        NetherCoreRegistry.addWallRecipe(NetherCoreItems.stoneCobble, NetherCoreItems.wallStoneCobble, false);
        NetherCoreRegistry.addWallRecipe(new ItemStack(Blocks.field_150385_bj), NetherCoreItems.wallNetherBrick, true);
        NetherCoreRegistry.addWallRecipe(new ItemStack(Blocks.field_189879_dh), NetherCoreItems.wallRedNetherBrick, false);
    }

    public static void registerIntegrations() {
        TinkersIntegration.addTinkersSmelting(NetherCoreItems.netherOreIron, FluidRegistry.getFluid((String)"iron"), 576);
        TinkersIntegration.addTinkersSmelting(NetherCoreItems.netherOreGold, FluidRegistry.getFluid((String)"gold"), 576);
    }

    private static void addCompressedRecipe(ItemStack input, ItemStack output) {
        ItemStack decompress = input.func_77946_l();
        decompress.field_77994_a = 9;
        GameRegistry.addRecipe((ItemStack)output.func_77946_l(), (Object[])new Object[]{"###", "###", "###", Character.valueOf('#'), input.func_77946_l()});
        GameRegistry.addRecipe((ItemStack)decompress, (Object[])new Object[]{"#", Character.valueOf('#'), output.func_77946_l()});
    }

    private static void addWallRecipe(ItemStack input, ItemStack output, boolean explicit) {
        ItemStack wall = output.func_77946_l();
        wall.field_77994_a = 6;
        ItemStack block = input.func_77946_l();
        block.field_77994_a = 1;
        if (!explicit) {
            GameRegistry.addRecipe((ItemStack)wall.func_77946_l(), (Object[])new Object[]{"###", "###", Character.valueOf('#'), block.func_77946_l()});
        } else {
            GameRegistry.addRecipe((ItemStack)wall.func_77946_l(), (Object[])new Object[]{"###", "###", "   ", Character.valueOf('#'), block.func_77946_l()});
        }
    }

    private static void addStairRecipe(ItemStack input, ItemStack output) {
        ItemStack stairs = output.func_77946_l();
        stairs.field_77994_a = 4;
        ItemStack block = input.func_77946_l();
        block.field_77994_a = 1;
        GameRegistry.addRecipe((ItemStack)stairs.func_77946_l(), (Object[])new Object[]{"#  ", "## ", "###", Character.valueOf('#'), block.func_77946_l()});
    }

    private static void addSlabRecipe(ItemStack input, ItemStack output) {
        ItemStack slabs = output.func_77946_l();
        slabs.field_77994_a = 6;
        ItemStack block = input.func_77946_l();
        block.field_77994_a = 1;
        GameRegistry.addRecipe((ItemStack)slabs.func_77946_l(), (Object[])new Object[]{"###", Character.valueOf('#'), block.func_77946_l()});
    }
}

