/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.switches.renderer;

import java.util.Set;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.block.component.PowerComponent;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.Vertex;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.EntityUtils;
import net.malisis.core.util.Point;
import net.malisis.core.util.Utils;
import net.malisis.core.util.raytrace.Raytrace;
import net.malisis.switches.MalisisSwitches;
import net.malisis.switches.tileentity.LinkedPowerTileEntity;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import org.apache.commons.lang3.tuple.Pair;

public class SwitchLinkRenderer
extends MalisisRenderer<LinkedPowerTileEntity> {
    private BlockPos linkedPos;
    private Pair<EnumFacing, Point> closest;
    private Icon linkedPosIcon = Icon.from((String)"malisisswitches:blocks/linked_pos");
    private Icon linkedPosPointerIcon = Icon.from((String)"malisisswitches:blocks/linked_pos_pointer");
    private Shape linkedPosCube = new Cube();
    private RenderParameters rp = new RenderParameters();

    public SwitchLinkRenderer() {
        this.registerFor(LinkedPowerTileEntity.class);
    }

    protected void initialize() {
        this.rp.useEnvironmentBrightness.set((Object)false);
        this.rp.brightness.set((Object)0xF000F0);
        this.rp.interpolateUV.set((Object)false);
    }

    public void render() {
        if (!EntityUtils.isEquipped((EntityPlayer)Utils.getClientPlayer(), (Item)MalisisSwitches.Items.powerLinker, (EnumHand)EnumHand.MAIN_HAND)) {
            return;
        }
        Point startPoint = this.posToPoint(this.pos);
        EnumFacing side = DirectionalComponent.getDirection((IBlockState)this.blockState);
        startPoint.x -= (double)(0.5f * (float)side.func_82601_c());
        startPoint.y -= (double)(0.5f * (float)side.func_96559_d());
        startPoint.z -= (double)(0.5f * (float)side.func_82599_e());
        int powerColor = PowerComponent.isPowered((IBlockState)this.blockState) ? 0x339933 : 0x990000;
        Set<BlockPos> linkedPositions = ((LinkedPowerTileEntity)this.tileEntity).linkedPositions();
        this.next(1);
        this.disableTextures();
        GlStateManager.func_179097_i();
        this.rp.colorMultiplier.set((Object)powerColor);
        this.rp.brightness.set((Object)0xF000F0);
        for (BlockPos p : linkedPositions) {
            this.setup(p, startPoint);
            if (this.closest == null) continue;
            this.drawVertex(this.pointToVertex(startPoint), 0, this.rp);
            this.drawVertex(this.pointToVertex((Point)this.closest.getRight()), 1, this.rp);
        }
        this.next(7);
        this.enableTextures();
        this.enableBlending();
        this.rp.icon.set((Object)this.linkedPosPointerIcon);
        for (BlockPos p : linkedPositions) {
            this.setup(p, startPoint);
            if (this.closest == null) continue;
            this.linkedPosCube.resetState();
            Point c = (Point)this.closest.getRight();
            EnumFacing s = (EnumFacing)this.closest.getLeft();
            Face f = this.linkedPosCube.getFace(Face.nameFromDirection((EnumFacing)s));
            if (f == null) continue;
            float x = (float)c.x - (float)this.pos.func_177958_n() - (s.func_176740_k() == EnumFacing.Axis.X ? 0.0f : 0.5f);
            float y = (float)c.y - (float)this.pos.func_177956_o() - (s.func_176740_k() == EnumFacing.Axis.Y ? 0.0f : 0.5f);
            float z = (float)c.z - (float)this.pos.func_177952_p() - (s.func_176740_k() == EnumFacing.Axis.Z ? 0.0f : 0.5f);
            if (s == EnumFacing.SOUTH) {
                z -= (float)s.func_82599_e();
            } else if (s == EnumFacing.EAST) {
                x -= (float)s.func_82601_c();
            } else if (s == EnumFacing.UP) {
                y -= (float)s.func_96559_d();
            }
            f.translate(x, y, z);
            this.drawFace(f, this.rp);
        }
        this.next();
        GlStateManager.func_179126_j();
        this.rp.icon.set((Object)this.linkedPosIcon);
        for (BlockPos p : linkedPositions) {
            this.setup(p, startPoint);
            this.linkedPosCube.resetState();
            this.linkedPosCube.translate((float)this.linkedPos.func_177958_n(), (float)this.linkedPos.func_177956_o(), (float)this.linkedPos.func_177952_p());
            this.linkedPosCube.scale(1.01f);
            this.drawShape(this.linkedPosCube, this.rp);
        }
    }

    private void setup(BlockPos pos, Point startPoint) {
        this.linkedPos = pos.func_177973_b((Vec3i)this.pos);
        this.closest = new Raytrace(startPoint, this.posToPoint(pos)).trace(AABBUtils.identities((BlockPos)pos));
    }

    private Vertex pointToVertex(Point p) {
        return new Vertex(p.x - (double)this.pos.func_177958_n(), p.y - (double)this.pos.func_177956_o(), p.z - (double)this.pos.func_177952_p());
    }

    private Point posToPoint(BlockPos pos) {
        return new Point((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f));
    }
}

