/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.switches.item;

import net.malisis.core.MalisisCore;
import net.malisis.core.item.MalisisItem;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.switches.ILinkedPower;
import net.malisis.switches.MalisisSwitches;
import net.malisis.switches.network.PowerLinkerMessage;
import net.malisis.switches.tileentity.LinkedPowerTileEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PowerLinker
extends MalisisItem {
    public PowerLinker() {
        this.setName("powerLinker");
        this.setTexture("malisisswitches:items/power_linker");
        this.func_77637_a(MalisisSwitches.tab);
    }

    protected NBTTagCompound getNBT(ItemStack itemStack) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return itemStack.func_77978_p();
    }

    public EnumActionResult onItemUseFirst(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (hand == EnumHand.OFF_HAND) {
            return EnumActionResult.PASS;
        }
        this.processClick(itemStack, player, world, pos, side);
        PowerLinkerMessage.sendClick(pos, side);
        return EnumActionResult.SUCCESS;
    }

    public void processClick(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        if (!this.isStartSet(itemStack)) {
            ILinkedPower lp = (ILinkedPower)TileEntityUtils.getTileEntity(ILinkedPower.class, (IBlockAccess)world, (BlockPos)pos);
            if (lp != null) {
                this.setStartPosition(itemStack, pos, world.func_82737_E());
            } else if (world.field_72995_K) {
                MalisisCore.message((Object)"No switch selected.");
            }
            return;
        }
        BlockPos start = this.getStartPosition(itemStack);
        if (start.equals((Object)pos)) {
            return;
        }
        LinkedPowerTileEntity te = (LinkedPowerTileEntity)TileEntityUtils.getTileEntity(LinkedPowerTileEntity.class, (IBlockAccess)world, (BlockPos)start);
        if (te == null) {
            return;
        }
        if (!player.func_70093_af()) {
            te.linkPosition(pos);
        } else if (!te.unlinkPosition(pos)) {
            te.unlinkPosition(pos.func_177972_a(side));
        }
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int p_77663_4_, boolean p_77663_5_) {
        if (!this.isStartSet(itemStack)) {
            return;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184586_b(EnumHand.MAIN_HAND) != itemStack) {
            this.clearStartPosition(itemStack);
        }
    }

    protected boolean isStartSet(ItemStack itemStack) {
        return this.getNBT(itemStack).func_74764_b("start");
    }

    protected boolean setStartPosition(ItemStack itemStack, BlockPos pos, long time) {
        this.getNBT(itemStack).func_74772_a("start", pos.func_177986_g());
        return true;
    }

    protected BlockPos getStartPosition(ItemStack itemStack) {
        return BlockPos.func_177969_a((long)this.getNBT(itemStack).func_74763_f("start"));
    }

    protected boolean clearStartPosition(ItemStack itemStack) {
        this.getNBT(itemStack).func_82580_o("start");
        return true;
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }
}

