/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.switches.block;

import net.malisis.core.MalisisCore;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.block.component.PowerComponent;
import net.malisis.core.renderer.DefaultRenderer;
import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.switches.MalisisSwitches;
import net.malisis.switches.tileentity.LinkedPowerTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@MalisisRendered(block=DefaultRenderer.Block.class, item=DefaultRenderer.Item.class)
public class Switch
extends MalisisBlock
implements ITileEntityProvider {
    private AxisAlignedBB aabb;

    public Switch(String name, float width, float height, float depth) {
        super(Material.field_151573_f);
        this.func_149647_a(MalisisSwitches.tab);
        this.func_149711_c(1.0f);
        this.setName(name);
        this.aabb = new AxisAlignedBB((double)(0.5f - width / 2.0f), (double)(0.5f - height / 2.0f), 0.0, (double)(0.5f + width / 2.0f), (double)(0.5f + height / 2.0f), (double)depth);
        this.addComponent((IComponent)new DirectionalComponent(DirectionalComponent.ALL, DirectionalComponent.IPlacement.BLOCKSIDE));
        this.addComponent((IComponent)new PowerComponent(PowerComponent.InteractionType.RIGHT_CLICK, PowerComponent.ComponentType.PROVIDER));
        if (MalisisCore.isClient()) {
            this.addComponent((IComponent)IIconProvider.create((String)"malisisswitches:blocks/", (String)(name + "_on")).forProperty((IProperty)PowerComponent.getProperty((Block)this)).withValue((Object)false, name + "_off").build());
        }
    }

    public Switch(String name, float width, float height) {
        this(name, width, height, 0.01f);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        super.func_180639_a(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
        LinkedPowerTileEntity te = (LinkedPowerTileEntity)TileEntityUtils.getTileEntity(LinkedPowerTileEntity.class, (IBlockAccess)world, (BlockPos)pos);
        if (te != null) {
            te.setPower(PowerComponent.isPowered((World)world, (BlockPos)pos) ? 15 : 0);
        }
        return true;
    }

    public AxisAlignedBB getBoundingBox(IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        if (type == BoundingBoxType.COLLISION) {
            return null;
        }
        return this.aabb;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return world.isSideSolid(pos.func_177972_a(side.func_176734_d()), side, true);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (!world.isSideSolid(pos.func_177972_a(side), side.func_176734_d(), true)) continue;
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        super.func_189540_a(state, world, pos, neighborBlock);
        EnumFacing dir = DirectionalComponent.getDirection((IBlockState)state);
        if (world.isSideSolid(pos.func_177972_a(dir.func_176734_d()), dir, true)) {
            return;
        }
        this.func_176226_b(world, pos, state, 0);
        world.func_175698_g(pos);
    }

    public int func_176211_b(IBlockState state, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return PowerComponent.isPowered((IBlockState)state) && DirectionalComponent.getDirection((IBlockState)state) == side ? 15 : 0;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new LinkedPowerTileEntity();
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        LinkedPowerTileEntity te = (LinkedPowerTileEntity)TileEntityUtils.getTileEntity(LinkedPowerTileEntity.class, (IBlockAccess)world, (BlockPos)pos);
        if (te != null) {
            te.setPower(0, true);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT_MIPPED;
    }
}

