/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.switches.block;

import net.malisis.core.MalisisCore;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.block.component.PowerComponent;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.IBlockIconProvider;
import net.malisis.core.util.TileEntityUtils;
import net.malisis.switches.MalisisSwitches;
import net.malisis.switches.tileentity.LinkedPowerTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Relay
extends MalisisBlock
implements ITileEntityProvider {
    @SideOnly(value=Side.CLIENT)
    private Icon relaySide;
    @SideOnly(value=Side.CLIENT)
    private Icon relayOff;
    @SideOnly(value=Side.CLIENT)
    private Icon relayOn;

    public Relay() {
        super(Material.field_151594_q);
        this.func_149647_a(MalisisSwitches.tab);
        this.func_149711_c(1.0f);
        this.setName("relay");
        this.addComponent((IComponent)new DirectionalComponent(DirectionalComponent.ALL, DirectionalComponent.IPlacement.BLOCKSIDE));
        this.addComponent((IComponent)new PowerComponent(PowerComponent.InteractionType.REDSTONE, PowerComponent.ComponentType.BOTH));
        if (MalisisCore.isClient()) {
            this.loadIcons();
            this.addComponent((IComponent)((IBlockIconProvider)this::getIcon));
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void loadIcons() {
        this.relaySide = Icon.from((String)"malisisswitches:blocks/relay_side");
        this.relayOff = Icon.from((String)"malisisswitches:blocks/relay_off");
        this.relayOn = Icon.from((String)"malisisswitches:blocks/relay_on");
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(IBlockState state, EnumFacing facing) {
        return facing == EnumFacing.SOUTH || facing == null ? (PowerComponent.isPowered((IBlockState)state) ? this.relayOn : this.relayOff) : this.relaySide;
    }

    public AxisAlignedBB getBoundingBox(IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    }

    public IBlockState getStateFromItemStack(ItemStack itemStack) {
        return this.func_176223_P();
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        side = side.func_176734_d();
        return world.isSideSolid(pos.func_177972_a(side), side);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        for (EnumFacing side : EnumFacing.values()) {
            if (!world.isSideSolid(pos.func_177972_a(side), side)) continue;
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock) {
        super.func_189540_a(state, world, pos, neighborBlock);
        EnumFacing dir = DirectionalComponent.getDirection((IBlockAccess)world, (BlockPos)pos).func_176734_d();
        if (!world.isSideSolid(pos.func_177972_a(dir), dir)) {
            this.func_176226_b(world, pos, this.func_176223_P(), 0);
            world.func_175698_g(pos);
            return;
        }
        LinkedPowerTileEntity te = (LinkedPowerTileEntity)TileEntityUtils.getTileEntity(LinkedPowerTileEntity.class, (IBlockAccess)world, (BlockPos)pos);
        if (te != null) {
            te.setPower(PowerComponent.isPowered((World)world, (BlockPos)pos) ? 15 : 0);
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new LinkedPowerTileEntity();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        LinkedPowerTileEntity te = (LinkedPowerTileEntity)TileEntityUtils.getTileEntity(LinkedPowerTileEntity.class, (IBlockAccess)world, (BlockPos)pos);
        if (te != null) {
            te.setPower(0, true);
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }
}

