/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.network.server;

import gr8pefish.ironbackpacks.capabilities.player.PlayerWearingBackpackCapabilities;
import gr8pefish.ironbackpacks.container.alternateGui.ContainerAlternateGui;
import gr8pefish.ironbackpacks.container.backpack.ContainerBackpack;
import gr8pefish.ironbackpacks.network.NetworkingHandler;
import gr8pefish.ironbackpacks.network.client.ClientCurrentPackMessage;
import gr8pefish.ironbackpacks.util.Logger;
import gr8pefish.ironbackpacks.util.NBTUtils;
import gr8pefish.ironbackpacks.util.helpers.IronBackpacksHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SingleByteMessage
implements IMessage {
    private byte action;

    public SingleByteMessage() {
    }

    public SingleByteMessage(byte action) {
        this.action = action;
    }

    public void fromBytes(ByteBuf buf) {
        this.action = (byte)ByteBufUtils.readVarShort((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeVarShort((ByteBuf)buf, (int)this.action);
    }

    public static class Handler
    implements IMessageHandler<SingleByteMessage, IMessage> {
        public IMessage onMessage(SingleByteMessage message, MessageContext ctx) {
            switch (message.action) {
                case 4: {
                    ContainerBackpack container = (ContainerBackpack)ctx.getServerHandler().field_147369_b.field_71070_bA;
                    container.backpackToInventory();
                    break;
                }
                case 5: {
                    ContainerBackpack container = (ContainerBackpack)ctx.getServerHandler().field_147369_b.field_71070_bA;
                    container.inventoryToBackpack();
                    break;
                }
                case 6: {
                    ContainerBackpack container = (ContainerBackpack)ctx.getServerHandler().field_147369_b.field_71070_bA;
                    container.hotbarToBackpack();
                    break;
                }
                case 7: {
                    ContainerBackpack container = (ContainerBackpack)ctx.getServerHandler().field_147369_b.field_71070_bA;
                    container.sort();
                    break;
                }
                case 12: {
                    ContainerBackpack container = (ContainerBackpack)ctx.getServerHandler().field_147369_b.field_71070_bA;
                    container.getInventoryBackpack().toggleSortType();
                    break;
                }
                case 8: {
                    ContainerAlternateGui altContainer = (ContainerAlternateGui)ctx.getServerHandler().field_147369_b.field_71070_bA;
                    altContainer.changeAdvFilterSlots("left");
                    break;
                }
                case 9: {
                    ContainerAlternateGui altContainer = (ContainerAlternateGui)ctx.getServerHandler().field_147369_b.field_71070_bA;
                    altContainer.changeAdvFilterSlots("right");
                    break;
                }
                case 1: {
                    ContainerAlternateGui altContainer = (ContainerAlternateGui)ctx.getServerHandler().field_147369_b.field_71070_bA;
                    altContainer.removeSlotsInRow(1);
                    break;
                }
                case 2: {
                    ContainerAlternateGui altContainer = (ContainerAlternateGui)ctx.getServerHandler().field_147369_b.field_71070_bA;
                    altContainer.removeSlotsInRow(2);
                    break;
                }
                case 3: {
                    ContainerAlternateGui altContainer = (ContainerAlternateGui)ctx.getServerHandler().field_147369_b.field_71070_bA;
                    altContainer.removeSlotsInRow(3);
                    break;
                }
                case 10: {
                    IronBackpacksHelper.equipBackpackFromKeybinding((EntityPlayer)ctx.getServerHandler().field_147369_b);
                    break;
                }
                case 11: {
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    ItemStack backpackStack = PlayerWearingBackpackCapabilities.getEquippedBackpack((EntityLivingBase)player);
                    if (backpackStack == null) break;
                    NBTUtils.setUUID(backpackStack);
                    PlayerWearingBackpackCapabilities.setCurrentBackpack((EntityLivingBase)player, backpackStack);
                    NetworkingHandler.network.sendTo((IMessage)new ClientCurrentPackMessage(backpackStack), player);
                    backpackStack.func_77957_a(player.field_70170_p, (EntityPlayer)player, EnumHand.MAIN_HAND);
                    break;
                }
                default: {
                    Logger.error("Error in sending message for Iron Backpacks in SingleByteMessage");
                }
            }
            return null;
        }
    }
}

