/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.network.client;

import gr8pefish.ironbackpacks.IronBackpacks;
import gr8pefish.ironbackpacks.capabilities.player.PlayerDeathBackpackCapabilities;
import gr8pefish.ironbackpacks.capabilities.player.PlayerWearingBackpackCapabilities;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ClientEquippedPackPlayerSensitiveMessage
implements IMessage {
    private ItemStack stack;
    private int entityID;

    public ClientEquippedPackPlayerSensitiveMessage() {
    }

    public ClientEquippedPackPlayerSensitiveMessage(int entityID, ItemStack stack) {
        this.stack = stack;
        this.entityID = entityID;
    }

    public void fromBytes(ByteBuf buf) {
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.entityID = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
        buf.writeInt(this.entityID);
    }

    public static class Handler
    implements IMessageHandler<ClientEquippedPackPlayerSensitiveMessage, IMessage> {
        public IMessage onMessage(ClientEquippedPackPlayerSensitiveMessage message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                World world = IronBackpacks.proxy.getClientWorld();
                EntityPlayer targetEntity = (EntityPlayer)world.func_73045_a(message.entityID);
                if (targetEntity != null) {
                    PlayerWearingBackpackCapabilities.setEquippedBackpack((EntityLivingBase)targetEntity, message.stack);
                    PlayerDeathBackpackCapabilities.setEquippedBackpack((EntityLivingBase)targetEntity, null);
                }
            });
            return null;
        }
    }
}

