/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.items.upgrades;

import gr8pefish.ironbackpacks.api.client.gui.button.ButtonNames;
import gr8pefish.ironbackpacks.api.register.ItemIUpgradeRegistry;
import gr8pefish.ironbackpacks.container.backpack.InventoryBackpack;
import gr8pefish.ironbackpacks.registry.GuiButtonRegistry;
import gr8pefish.ironbackpacks.registry.ItemRegistry;
import gr8pefish.ironbackpacks.util.helpers.IronBackpacksHelper;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class UpgradeMethods {
    public static boolean hasAdditionalUpgradesUpgrade(ArrayList<ItemStack> upgrades) {
        boolean hasUpgrade = false;
        for (ItemStack stack : upgrades) {
            if (!ItemIUpgradeRegistry.getItemIUpgrade(stack.func_77952_i()).equals(ItemRegistry.buttonUpgrade)) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasButtonUpgrade(ArrayList<ItemStack> upgrades) {
        boolean hasUpgrade = false;
        for (ItemStack stack : upgrades) {
            if (!ItemIUpgradeRegistry.isInstanceOfIUpgrade(stack) || !ItemIUpgradeRegistry.getItemIUpgrade(stack.func_77952_i()).equals(ItemRegistry.buttonUpgrade)) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasDamageBarUpgrade(ArrayList<ItemStack> upgrades) {
        boolean hasUpgrade = false;
        for (ItemStack stack : upgrades) {
            if (!ItemIUpgradeRegistry.isInstanceOfIUpgrade(stack) || stack.func_77952_i() >= ItemIUpgradeRegistry.getIPackSize() || !ItemIUpgradeRegistry.getItemIUpgrade(stack.func_77952_i()).equals(ItemRegistry.damageBarUpgrade)) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasDepthUpgrade(ArrayList<ItemStack> upgrades) {
        boolean hasUpgrade = false;
        for (ItemStack stack : upgrades) {
            if (!ItemIUpgradeRegistry.isInstanceOfIUpgrade(stack) || !ItemIUpgradeRegistry.getItemIUpgrade(stack.func_77952_i()).equals(ItemRegistry.depthUpgrade)) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasEternityUpgrade(ArrayList<ItemStack> upgrades) {
        boolean hasUpgrade = false;
        for (ItemStack stack : upgrades) {
            if (!ItemIUpgradeRegistry.isInstanceOfIUpgrade(stack) || !ItemIUpgradeRegistry.getItemIUpgrade(stack.func_77952_i()).equals(ItemRegistry.eternityUpgrade)) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasRenamingUpgrade(ArrayList<ItemStack> upgrades) {
        boolean hasUpgrade = false;
        for (ItemStack stack : upgrades) {
            if (!ItemIUpgradeRegistry.isInstanceOfIUpgrade(stack) || !ItemIUpgradeRegistry.getItemIUpgrade(stack.func_77952_i()).equals(ItemRegistry.renamingUpgrade)) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasNestingUpgrade(ArrayList<ItemStack> upgrades) {
        boolean hasUpgrade = false;
        for (ItemStack stack : upgrades) {
            if (!ItemIUpgradeRegistry.isInstanceOfIConflictingUpgrade(stack) || !ItemIUpgradeRegistry.getItemIConflictingUpgrade(stack.func_77952_i()).equals(ItemRegistry.nestingUpgrade)) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasNestingAdvancedUpgrade(ArrayList<ItemStack> upgrades) {
        boolean hasUpgrade = false;
        for (ItemStack stack : upgrades) {
            if (!ItemIUpgradeRegistry.isInstanceOfIConflictingUpgrade(stack) || !ItemIUpgradeRegistry.getItemIConflictingUpgrade(stack.func_77952_i()).equals(ItemRegistry.nestingAdvancedUpgrade)) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasQuickDepositUpgrade(ArrayList<ItemStack> upgrades) {
        boolean hasUpgrade = false;
        for (ItemStack stack : upgrades) {
            if (!ItemIUpgradeRegistry.isInstanceOfIConflictingUpgrade(stack) || !ItemIUpgradeRegistry.getItemIConflictingUpgrade(stack.func_77952_i()).equals(ItemRegistry.quickDepositUpgrade)) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasQuickDepositPreciseUpgrade(ArrayList<ItemStack> upgrades) {
        boolean hasUpgrade = false;
        for (ItemStack stack : upgrades) {
            if (!ItemIUpgradeRegistry.isInstanceOfIConflictingUpgrade(stack) || !ItemIUpgradeRegistry.getItemIConflictingUpgrade(stack.func_77952_i()).equals(ItemRegistry.quickDepositPreciseUpgrade)) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasCraftingUpgrade(ArrayList<ItemStack> upgrades) {
        boolean hasUpgrade = false;
        for (ItemStack stack : upgrades) {
            if (!ItemIUpgradeRegistry.isInstanceOfIConfigurableUpgrade(stack) || !ItemIUpgradeRegistry.getItemIConfingurableUpgrade(stack.func_77952_i()).equals(ItemRegistry.craftingUpgrade)) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasCraftingSmallUpgrade(ArrayList<ItemStack> upgrades) {
        boolean hasUpgrade = false;
        for (ItemStack stack : upgrades) {
            if (!ItemIUpgradeRegistry.isInstanceOfIConfigurableUpgrade(stack) || !ItemIUpgradeRegistry.getItemIConfingurableUpgrade(stack.func_77952_i()).equals(ItemRegistry.craftingSmallUpgrade)) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasCraftingTinyUpgrade(ArrayList<ItemStack> upgrades) {
        boolean hasUpgrade = false;
        for (ItemStack stack : upgrades) {
            if (!ItemIUpgradeRegistry.isInstanceOfIConfigurableUpgrade(stack) || !ItemIUpgradeRegistry.getItemIConfingurableUpgrade(stack.func_77952_i()).equals(ItemRegistry.craftingTinyUpgrade)) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasFilterBasicUpgrade(ArrayList<ItemStack> upgrades) {
        boolean hasUpgrade = false;
        for (ItemStack stack : upgrades) {
            if (!ItemIUpgradeRegistry.isInstanceOfIConfigurableUpgrade(stack) || !ItemIUpgradeRegistry.getItemIConfingurableUpgrade(stack.func_77952_i()).equals(ItemRegistry.filterBasicUpgrade)) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasFilterFuzzyUpgrade(ArrayList<ItemStack> upgrades) {
        boolean hasUpgrade = false;
        for (ItemStack stack : upgrades) {
            if (!ItemIUpgradeRegistry.isInstanceOfIConfigurableUpgrade(stack) || !ItemIUpgradeRegistry.getItemIConfingurableUpgrade(stack.func_77952_i()).equals(ItemRegistry.filterFuzzyUpgrade)) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasFilterOreDictUpgrade(ArrayList<ItemStack> upgrades) {
        boolean hasUpgrade = false;
        for (ItemStack stack : upgrades) {
            if (!ItemIUpgradeRegistry.isInstanceOfIConfigurableUpgrade(stack) || !ItemIUpgradeRegistry.getItemIConfingurableUpgrade(stack.func_77952_i()).equals(ItemRegistry.filterOreDictUpgrade)) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasFilterModSpecificUpgrade(ArrayList<ItemStack> upgrades) {
        boolean hasUpgrade = false;
        for (ItemStack stack : upgrades) {
            if (!ItemIUpgradeRegistry.isInstanceOfIConfigurableUpgrade(stack) || !ItemIUpgradeRegistry.getItemIConfingurableUpgrade(stack.func_77952_i()).equals(ItemRegistry.filterModSpecificUpgrade)) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasFilterVoidUpgrade(ArrayList<ItemStack> upgrades) {
        boolean hasUpgrade = false;
        for (ItemStack stack : upgrades) {
            if (!ItemIUpgradeRegistry.isInstanceOfIConfigurableUpgrade(stack) || !ItemIUpgradeRegistry.getItemIConfingurableUpgrade(stack.func_77952_i()).equals(ItemRegistry.filterVoidUpgrade)) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasFilterAdvancedUpgrade(ArrayList<ItemStack> upgrades) {
        boolean hasUpgrade = false;
        for (ItemStack stack : upgrades) {
            if (!ItemIUpgradeRegistry.isInstanceOfIConfigurableUpgrade(stack) || !ItemIUpgradeRegistry.getItemIConfingurableUpgrade(stack.func_77952_i()).equals(ItemRegistry.filterAdvancedUpgrade)) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasFilterMiningUpgrade(ArrayList<ItemStack> upgrades) {
        boolean hasUpgrade = false;
        for (ItemStack stack : upgrades) {
            if (!ItemIUpgradeRegistry.isInstanceOfIConfigurableUpgrade(stack) || !ItemIUpgradeRegistry.getItemIConfingurableUpgrade(stack.func_77952_i()).equals(ItemRegistry.filterMiningUpgrade)) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static boolean hasRestockingUpgrade(ArrayList<ItemStack> upgrades) {
        boolean hasUpgrade = false;
        for (ItemStack stack : upgrades) {
            if (!ItemIUpgradeRegistry.isInstanceOfIConfigurableUpgrade(stack) || !ItemIUpgradeRegistry.getItemIConfingurableUpgrade(stack.func_77952_i()).equals(ItemRegistry.restockingUpgrade)) continue;
            hasUpgrade = true;
            break;
        }
        return hasUpgrade;
    }

    public static int getAlternateGuiUpgradeSlots(ArrayList<ItemStack> upgrades) {
        return UpgradeMethods.getAltGuiUpgradesApplied(upgrades) * 9;
    }

    public static int getAltGuiUpgradesApplied(ArrayList<ItemStack> upgrades) {
        int counter = 0;
        for (ItemStack upgrade : upgrades) {
            if (!ItemIUpgradeRegistry.isInstanceOfIConfigurableUpgrade(upgrade)) continue;
            ++counter;
        }
        return counter;
    }

    public static boolean areUpgradesFunctionallyEquivalent(ItemStack upgrade1, ItemStack upgrade2) {
        return upgrade1.func_77973_b().equals(upgrade2.func_77973_b()) && upgrade1.func_77952_i() == upgrade2.func_77952_i();
    }

    public static ArrayList<ItemStack> getBasicFilterItems(ItemStack stack) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("FilterBasic")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("FilterBasic", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                returnArray.add(ItemStack.func_77949_a((NBTTagCompound)stackTag));
            }
        }
        return returnArray;
    }

    public static ArrayList<ItemStack> getFuzzyFilterItems(ItemStack stack) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("FilterFuzzy")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("FilterFuzzy", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                returnArray.add(ItemStack.func_77949_a((NBTTagCompound)stackTag));
            }
        }
        return returnArray;
    }

    public static ArrayList<ItemStack> getOreDictFilterItems(ItemStack stack) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("FilterOreDict")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("FilterOreDict", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                returnArray.add(ItemStack.func_77949_a((NBTTagCompound)stackTag));
            }
        }
        return returnArray;
    }

    public static ArrayList<ItemStack> getModSpecificFilterItems(ItemStack stack) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("FilterModSpecific")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("FilterModSpecific", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                returnArray.add(ItemStack.func_77949_a((NBTTagCompound)stackTag));
            }
        }
        return returnArray;
    }

    public static ArrayList<ItemStack> getVoidFilterItems(ItemStack stack) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("FilterVoid")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("FilterVoid", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                returnArray.add(ItemStack.func_77949_a((NBTTagCompound)stackTag));
            }
        }
        return returnArray;
    }

    public static ArrayList<ItemStack> getMiningFilterItems(ItemStack stack) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("FilterMining")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("FilterMining", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                returnArray.add(ItemStack.func_77949_a((NBTTagCompound)stackTag));
            }
        }
        return returnArray;
    }

    public static ItemStack[] getAdvFilterAllItems(ItemStack stack) {
        ItemStack[] advFilterStacks = new ItemStack[18];
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("FilterAdvAllSlots")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("FilterAdvAllSlots", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                advFilterStacks[stackTag.func_74771_c((String)"Slot")] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
            }
        }
        return advFilterStacks;
    }

    public static byte[] getAdvFilterButtonStates(ItemStack stack) {
        byte[] advFilterButtonStates = new byte[18];
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("FilterAdvButtons")) {
            byte[] bytes = ((NBTTagByteArray)nbtTagCompound.func_74781_a("FilterAdvButtons")).func_150292_c();
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i] == 0) {
                    bytes[i] = (byte)GuiButtonRegistry.getButton(ButtonNames.EXACT).getId();
                }
                advFilterButtonStates[i] = bytes[i];
            }
        }
        return advFilterButtonStates;
    }

    public static ArrayList<ItemStack> getAdvFilterBasicItems(ItemStack[] itemStacks, byte[] buttonStates) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        for (int i = 0; i < itemStacks.length; ++i) {
            if (itemStacks[i] == null || buttonStates[i] != (byte)GuiButtonRegistry.getButton(ButtonNames.EXACT).getId()) continue;
            returnArray.add(itemStacks[i]);
        }
        return returnArray;
    }

    public static ArrayList<ItemStack> getAdvFilterFuzzyItems(ItemStack[] itemStacks, byte[] buttonStates) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        for (int i = 0; i < itemStacks.length; ++i) {
            if (itemStacks[i] == null || buttonStates[i] != (byte)GuiButtonRegistry.getButton(ButtonNames.FUZZY).getId()) continue;
            returnArray.add(itemStacks[i]);
        }
        return returnArray;
    }

    public static ArrayList<ItemStack> getAdvFilterModSpecificItems(ItemStack[] itemStacks, byte[] buttonStates) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        for (int i = 0; i < itemStacks.length; ++i) {
            if (itemStacks[i] == null || buttonStates[i] != (byte)GuiButtonRegistry.getButton(ButtonNames.MOD_SPECIFIC).getId()) continue;
            returnArray.add(itemStacks[i]);
        }
        return returnArray;
    }

    public static ArrayList<ItemStack> getAdvFilterOreDictItems(ItemStack[] itemStacks, byte[] buttonStates) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        for (int i = 0; i < itemStacks.length; ++i) {
            if (itemStacks[i] == null || buttonStates[i] != (byte)GuiButtonRegistry.getButton(ButtonNames.ORE_DICT).getId()) continue;
            returnArray.add(itemStacks[i]);
        }
        return returnArray;
    }

    public static ArrayList<ItemStack> getAdvFilterVoidItems(ItemStack[] itemStacks, byte[] buttonStates) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        for (int i = 0; i < itemStacks.length; ++i) {
            if (itemStacks[i] == null || buttonStates[i] != (byte)GuiButtonRegistry.getButton(ButtonNames.VOID).getId()) continue;
            returnArray.add(itemStacks[i]);
        }
        return returnArray;
    }

    public static ArrayList<ItemStack> getRestockingItems(ItemStack stack) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("Hopper")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("Hopper", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                returnArray.add(ItemStack.func_77949_a((NBTTagCompound)stackTag));
            }
        }
        return returnArray;
    }

    public static ArrayList<ItemStack> getCrafterItems(ItemStack stack) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("Condenser")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("Condenser", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                returnArray.add(ItemStack.func_77949_a((NBTTagCompound)stackTag));
            }
        }
        return returnArray;
    }

    public static ArrayList<ItemStack> getCrafterSmallItems(ItemStack stack) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("CondenserSmall")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("CondenserSmall", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                returnArray.add(ItemStack.func_77949_a((NBTTagCompound)stackTag));
            }
        }
        return returnArray;
    }

    public static ArrayList<ItemStack> getCrafterTinyItems(ItemStack stack) {
        ArrayList<ItemStack> returnArray = new ArrayList<ItemStack>();
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound != null && nbtTagCompound.func_74764_b("CondenserTiny")) {
            NBTTagList tagList = nbtTagCompound.func_150295_c("CondenserTiny", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound stackTag = tagList.func_150305_b(i);
                returnArray.add(ItemStack.func_77949_a((NBTTagCompound)stackTag));
            }
        }
        return returnArray;
    }

    public static boolean transferFromBackpackToInventory(EntityPlayer player, ItemStack backpack, World world, BlockPos pos, EnumFacing side, boolean usePrecise) {
        IItemHandler inv;
        TileEntity targeted = world.func_175625_s(pos);
        if (targeted != null && (inv = UpgradeMethods.getTargetedInventory(targeted, side)) != null) {
            return UpgradeMethods.transferItemsToContainer(player, backpack, inv, usePrecise);
        }
        return false;
    }

    private static IItemHandler getTargetedInventory(TileEntity tile, EnumFacing side) {
        if (tile == null) {
            return null;
        }
        if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        }
        if (tile instanceof ISidedInventory) {
            return new SidedInvWrapper((ISidedInventory)tile, side);
        }
        if (tile instanceof IInventory) {
            return new InvWrapper((IInventory)tile);
        }
        return null;
    }

    private static boolean transferItemsToContainer(EntityPlayer player, ItemStack backpack, IItemHandler transferTo, boolean usePrecise) {
        boolean returnValue = false;
        InventoryBackpack inventoryBackpack = new InventoryBackpack(player, backpack);
        if (transferTo.getSlots() > 0 && !inventoryBackpack.isEmpty()) {
            for (int i = 0; i < inventoryBackpack.func_70302_i_(); ++i) {
                ItemStack stackToMove = inventoryBackpack.func_70301_a(i);
                if (stackToMove == null || stackToMove.field_77994_a <= 0) continue;
                ItemStack remainder = UpgradeMethods.putInFirstValidSlot(transferTo, stackToMove, usePrecise);
                inventoryBackpack.func_70299_a(i, remainder);
                inventoryBackpack.onGuiSaved(player);
                returnValue = true;
            }
        }
        return returnValue;
    }

    private static ItemStack putInFirstValidSlot(IItemHandler transferTo, ItemStack stackToTransfer, boolean usePrecise) {
        for (int i = 0; i < transferTo.getSlots(); ++i) {
            if (stackToTransfer == null) {
                return null;
            }
            if (usePrecise) {
                if (!UpgradeMethods.isStackInInventoryAlready(transferTo, stackToTransfer)) continue;
                stackToTransfer = UpgradeMethods.transferToInv(transferTo, stackToTransfer, i);
                continue;
            }
            stackToTransfer = UpgradeMethods.transferToInv(transferTo, stackToTransfer, i);
        }
        return stackToTransfer;
    }

    private static ItemStack transferToInv(IItemHandler transferTo, ItemStack stackToTransfer, int transferToSlotNumber) {
        if (transferTo instanceof ISidedInventory) {
            ISidedInventory sidedInventory = (ISidedInventory)transferTo;
            EnumFacing[] enumFacings = EnumFacing.values();
            for (int j = 0; j < enumFacings.length; ++j) {
                if (!sidedInventory.func_180462_a(transferToSlotNumber, stackToTransfer, enumFacings[j])) continue;
                ItemStack simulated = transferTo.insertItem(transferToSlotNumber, stackToTransfer, false);
                sidedInventory.func_70296_d();
                return simulated == null ? null : simulated.func_77946_l();
            }
        } else {
            ItemStack originalTransferStack = stackToTransfer.func_77946_l();
            ItemStack simulated = transferTo.insertItem(transferToSlotNumber, stackToTransfer, true);
            if (!IronBackpacksHelper.areItemStacksTheSame(simulated, originalTransferStack)) {
                transferTo.insertItem(transferToSlotNumber, stackToTransfer, false);
                return simulated == null ? null : simulated.func_77946_l();
            }
        }
        return stackToTransfer;
    }

    private static boolean isStackInInventoryAlready(IItemHandler transferTo, ItemStack stackToTransfer) {
        for (int i = 0; i < transferTo.getSlots(); ++i) {
            ItemStack tempStack = transferTo.getStackInSlot(i);
            if (tempStack == null || tempStack.field_77994_a <= 0 || !stackToTransfer.func_77969_a(tempStack) || !ItemStack.func_77970_a((ItemStack)tempStack, (ItemStack)stackToTransfer)) continue;
            return true;
        }
        return false;
    }
}

