/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.container.backpack;

import gr8pefish.ironbackpacks.api.items.backpacks.interfaces.IBackpack;
import gr8pefish.ironbackpacks.capabilities.player.PlayerWearingBackpackCapabilities;
import gr8pefish.ironbackpacks.items.backpacks.ItemBackpack;
import gr8pefish.ironbackpacks.util.NBTUtils;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class InventoryBackpack
implements IInventory {
    private ItemStack backpackStack;
    private EntityPlayer player;
    private ItemStack[] inventory;
    private String sortType;

    public InventoryBackpack(EntityPlayer player, ItemStack backpackStack) {
        this.backpackStack = backpackStack;
        this.player = player;
        this.inventory = new ItemStack[this.func_70302_i_()];
        this.sortType = "id";
        this.readFromNBT(backpackStack.func_77978_p());
    }

    public InventoryBackpack(ItemStack backpackStack, boolean noPlayer) {
        this.backpackStack = backpackStack;
        this.player = null;
        this.inventory = new ItemStack[this.func_70302_i_()];
        this.sortType = "id";
        this.readFromNBT(backpackStack.func_77978_p(), noPlayer);
    }

    public ItemStack getBackpackStack() {
        return this.backpackStack;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void toggleSortType() {
        this.sortType = this.sortType.equals("id") ? "alphabetical" : "id";
        this.save();
    }

    public int func_70302_i_() {
        return ((ItemBackpack)this.backpackStack.func_77973_b()).getSize(this.backpackStack);
    }

    public ItemStack func_70301_a(int slotIndex) {
        return slotIndex >= this.func_70302_i_() ? null : this.inventory[slotIndex];
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        if (this.inventory[slotIndex] != null) {
            if (this.inventory[slotIndex].field_77994_a <= amount) {
                ItemStack itemstack = this.inventory[slotIndex];
                this.inventory[slotIndex] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.inventory[slotIndex].func_77979_a(amount);
            if (this.inventory[slotIndex].field_77994_a == 0) {
                this.inventory[slotIndex] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int slotIndex, ItemStack itemStack) {
        this.inventory[slotIndex] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70005_c_() {
        return ((ItemBackpack)this.backpackStack.func_77973_b()).getName(this.backpackStack);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = null;
        if (this.inventory[index] != null) {
            stack = this.inventory[index];
            this.inventory[index] = null;
        }
        return stack;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack itemStack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = null;
        }
    }

    public int hasStackInInv(Block blockToCheck, int meta) {
        int total = 0;
        for (int i = 0; i < this.inventory.length; ++i) {
            Block backpackItemAsBlock;
            if (this.inventory[i] == null || this.inventory[i].field_77994_a <= 0 || !(backpackItemAsBlock = Block.func_149634_a((Item)this.inventory[i].func_77973_b())).equals(blockToCheck) || this.inventory[i].func_77952_i() != meta) continue;
            total += this.inventory[i].field_77994_a;
        }
        return total;
    }

    public boolean removeOneItem(Block blockToCheck, int meta) {
        for (int i = 0; i < this.inventory.length; ++i) {
            Block backpackItemAsBlock;
            if (this.inventory[i] == null || this.inventory[i].field_77994_a <= 0 || !(backpackItemAsBlock = Block.func_149634_a((Item)this.inventory[i].func_77973_b())).equals(blockToCheck) || this.inventory[i].func_77952_i() != meta) continue;
            --this.inventory[i].field_77994_a;
            if (this.inventory[i].field_77994_a == 0) {
                this.inventory[i] = null;
            }
            this.save();
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.inventory) {
            if (stack == null || stack.field_77994_a <= 0) continue;
            return false;
        }
        return true;
    }

    public void onGuiSaved(EntityPlayer entityPlayer) {
        if (this.backpackStack != null) {
            this.save();
        }
    }

    public void saveWithSideCheck(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            this.onGuiSaved(player);
        }
    }

    public void save() {
        NBTTagCompound nbtTagCompound = this.backpackStack.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
        }
        this.writeToNBT(nbtTagCompound);
        this.backpackStack.func_77982_d(nbtTagCompound);
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        if (!this.player.field_70170_p.field_72995_K) {
            ItemStack tempStack = this.findParentItemStack(this.player);
            ItemStack stackToUse = tempStack == null ? this.backpackStack : tempStack;
            nbtTagCompound = stackToUse.func_77978_p();
            NBTTagList tagList = new NBTTagList();
            for (int i = 0; i < this.inventory.length; ++i) {
                if (this.inventory[i] == null) continue;
                NBTTagCompound tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)i);
                this.inventory[i].func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            nbtTagCompound.func_74782_a("Items", (NBTBase)tagList);
            nbtTagCompound.func_74782_a("SortType", (NBTBase)new NBTTagString(this.sortType));
        }
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        if (!this.player.field_70170_p.field_72995_K) {
            ItemStack tempStack = this.findParentItemStack(this.player);
            ItemStack itemStack = this.backpackStack = tempStack == null ? this.backpackStack : tempStack;
            if (this.backpackStack != null && (nbtTagCompound = this.backpackStack.func_77978_p()) != null) {
                if (nbtTagCompound.func_74764_b("SortType")) {
                    this.sortType = nbtTagCompound.func_74779_i("SortType");
                }
                if (nbtTagCompound.func_74764_b("Items")) {
                    NBTTagList tagList = nbtTagCompound.func_150295_c("Items", 10);
                    this.inventory = new ItemStack[this.func_70302_i_()];
                    for (int i = 0; i < tagList.func_74745_c(); ++i) {
                        NBTTagCompound stackTag = tagList.func_150305_b(i);
                        byte j = stackTag.func_74771_c("Slot");
                        if (i < 0 || i > this.inventory.length) continue;
                        this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
                    }
                }
            }
        } else if (nbtTagCompound.func_74764_b("SortType")) {
            this.sortType = nbtTagCompound.func_74779_i("SortType");
        }
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound, boolean noPlayer) {
        if (noPlayer && this.backpackStack != null && (nbtTagCompound = this.backpackStack.func_77978_p()) != null) {
            if (nbtTagCompound.func_74764_b("SortType")) {
                this.sortType = nbtTagCompound.func_74779_i("SortType");
            }
            if (nbtTagCompound.func_74764_b("Items")) {
                NBTTagList tagList = nbtTagCompound.func_150295_c("Items", 10);
                this.inventory = new ItemStack[this.func_70302_i_()];
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTTagCompound stackTag = tagList.func_150305_b(i);
                    byte j = stackTag.func_74771_c("Slot");
                    if (i < 0 || i > this.inventory.length) continue;
                    this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)stackTag);
                }
            }
        }
    }

    private ItemStack findParentItemStack(EntityPlayer entityPlayer) {
        if (NBTUtils.hasUUID(this.backpackStack)) {
            UUID parentUUID = new UUID(this.backpackStack.func_77978_p().func_74763_f("MostSigUUID"), this.backpackStack.func_77978_p().func_74763_f("LeastSigUUID"));
            for (int i = 0; i < entityPlayer.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemStack = entityPlayer.field_71071_by.func_70301_a(i);
                if (itemStack == null || !(itemStack.func_77973_b() instanceof IBackpack) || !NBTUtils.hasUUID(itemStack) || itemStack.func_77978_p().func_74763_f("MostSigUUID") != parentUUID.getMostSignificantBits() || itemStack.func_77978_p().func_74763_f("LeastSigUUID") != parentUUID.getLeastSignificantBits()) continue;
                return itemStack;
            }
            ItemStack equipped = PlayerWearingBackpackCapabilities.getEquippedBackpack((EntityLivingBase)entityPlayer);
            if (equipped != null && equipped.func_77973_b() instanceof IBackpack && NBTUtils.hasUUID(equipped) && equipped.func_77978_p().func_74763_f("MostSigUUID") == parentUUID.getMostSignificantBits() && equipped.func_77978_p().func_74763_f("LeastSigUUID") == parentUUID.getLeastSignificantBits()) {
                return equipped;
            }
        }
        return null;
    }
}

