/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.container.alternateGui;

import gr8pefish.ironbackpacks.api.client.gui.button.ButtonNames;
import gr8pefish.ironbackpacks.capabilities.player.PlayerWearingBackpackCapabilities;
import gr8pefish.ironbackpacks.config.ConfigHandler;
import gr8pefish.ironbackpacks.container.alternateGui.InventoryAlternateGui;
import gr8pefish.ironbackpacks.container.slot.GhostSlot;
import gr8pefish.ironbackpacks.items.upgrades.UpgradeMethods;
import gr8pefish.ironbackpacks.registry.GuiButtonRegistry;
import gr8pefish.ironbackpacks.util.helpers.IronBackpacksHelper;
import invtweaks.api.container.ChestContainer;
import invtweaks.api.container.InventoryContainer;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

@InventoryContainer
public class ContainerAlternateGui
extends Container {
    private EntityPlayer player;
    private InventoryAlternateGui inventory;
    private int xSize = 0;
    private int ySize = 0;
    private ItemStack stack;
    private int filterAdvSlotIdStart;
    private ArrayList<ItemStack> upgrades;

    public ContainerAlternateGui(InventoryAlternateGui inventoryAlternateGui, int xSize, int ySize) {
        this.player = inventoryAlternateGui.getPlayer();
        this.inventory = inventoryAlternateGui;
        this.xSize = xSize;
        this.ySize = ySize;
        this.stack = inventoryAlternateGui.getBackpackStack();
        this.upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(this.stack);
        this.layoutContainer((IInventory)this.player.field_71071_by, inventoryAlternateGui, xSize, ySize);
        if (UpgradeMethods.hasFilterAdvancedUpgrade(this.upgrades)) {
            this.initFilterSlots();
        }
    }

    public ContainerAlternateGui(InventoryAlternateGui inventoryAlternateGui) {
        this.player = inventoryAlternateGui.getPlayer();
        this.inventory = inventoryAlternateGui;
        this.stack = inventoryAlternateGui.getBackpackStack();
        this.upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(this.stack);
        this.layoutContainer((IInventory)this.player.field_71071_by, inventoryAlternateGui, this.xSize, this.ySize);
        if (UpgradeMethods.hasFilterAdvancedUpgrade(this.upgrades)) {
            this.initFilterSlots();
        }
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public InventoryAlternateGui getInventoryAlternateGui() {
        return this.inventory;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public int getFilterAdvSlotIdStart() {
        return this.filterAdvSlotIdStart;
    }

    private void layoutContainer(IInventory playerInventory, IInventory customInv, int xSize, int ySize) {
        int advFilterRow;
        ItemStack baseBackpack = IronBackpacksHelper.getBackpack(this.player);
        ArrayList<ItemStack> upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(baseBackpack);
        int n = advFilterRow = UpgradeMethods.hasFilterAdvancedUpgrade(upgrades) ? 0 : -1;
        if (UpgradeMethods.hasCraftingUpgrade(upgrades)) {
            ++advFilterRow;
        }
        if (UpgradeMethods.hasCraftingSmallUpgrade(upgrades)) {
            ++advFilterRow;
        }
        if (UpgradeMethods.hasCraftingTinyUpgrade(upgrades)) {
            ++advFilterRow;
        }
        if (UpgradeMethods.hasFilterBasicUpgrade(upgrades)) {
            ++advFilterRow;
        }
        if (UpgradeMethods.hasFilterFuzzyUpgrade(upgrades)) {
            ++advFilterRow;
        }
        if (UpgradeMethods.hasFilterOreDictUpgrade(upgrades)) {
            ++advFilterRow;
        }
        if (UpgradeMethods.hasFilterModSpecificUpgrade(upgrades)) {
            ++advFilterRow;
        }
        if (UpgradeMethods.hasFilterVoidUpgrade(upgrades)) {
            ++advFilterRow;
        }
        this.filterAdvSlotIdStart = advFilterRow * 9;
        int rowCount = (int)Math.floor(customInv.func_70302_i_() / 9);
        int colCount = 9;
        int yStart = ConfigHandler.renamingUpgradeRequired ? (UpgradeMethods.hasRenamingUpgrade(upgrades) ? 18 : 0) : 18;
        for (int row = 0; row < rowCount; ++row) {
            yStart += 36;
            for (int col = 0; col < colCount; ++col) {
                this.func_75146_a(new GhostSlot(customInv, col + row * colCount, 20 + col * 18, yStart));
            }
        }
        int leftCol = (xSize - 162) / 2 + 1;
        for (int playerInvRow = 0; playerInvRow < 3; ++playerInvRow) {
            for (int playerInvCol = 0; playerInvCol < 9; ++playerInvCol) {
                this.func_75146_a(new Slot(playerInventory, playerInvCol + playerInvRow * 9 + 9, leftCol + playerInvCol * 18, ySize - (4 - playerInvRow) * 18 - 10));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.func_75146_a(new Slot(playerInventory, hotbarSlot, leftCol + hotbarSlot * 18, ySize - 24));
        }
    }

    public ItemStack func_82846_b(EntityPlayer p, int i) {
        return null;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (UpgradeMethods.hasFilterAdvancedUpgrade(this.upgrades)) {
            this.saveSlots();
        }
        if (!player.field_70170_p.field_72995_K) {
            this.inventory.onGuiSaved(player);
        }
    }

    public ItemStack func_184996_a(int slot, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (slot >= 0 && this.func_75139_a(slot) != null && this.func_75139_a(slot).func_75216_d() && player.func_184614_ca() != null && this.func_75139_a(slot).func_75211_c().func_77969_a(player.func_184614_ca())) {
            return null;
        }
        if (slot >= 0 && slot < this.inventory.func_70302_i_()) {
            if (player.field_71071_by.func_70445_o() != null) {
                ItemStack usedStack = player.field_71071_by.func_70445_o().func_77946_l();
                usedStack.field_77994_a = 1;
                this.inventory.func_70299_a(slot, usedStack);
                return null;
            }
            this.inventory.func_70299_a(slot, null);
            return null;
        }
        try {
            return super.func_184996_a(slot, dragType, clickTypeIn, player);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void renameBackpack(String toName) {
        this.stack.func_151001_c(ConfigHandler.makeRenamedBackpacksNamesItalic ? toName : "\u00a7r" + toName);
        ItemStack itemStack = PlayerWearingBackpackCapabilities.getCurrentBackpack((EntityLivingBase)this.player);
        if (itemStack == null) {
            itemStack = PlayerWearingBackpackCapabilities.getEquippedBackpack((EntityLivingBase)this.player);
        }
        if (itemStack != null) {
            itemStack.func_151001_c(ConfigHandler.makeRenamedBackpacksNamesItalic ? toName : "\u00a7r" + toName);
        }
    }

    public void removeSlotsInRow(int row) {
        if (row == this.filterAdvSlotIdStart / 9 + 1) {
            Arrays.fill(this.inventory.advFilterStacks, null);
            Arrays.fill(this.inventory.advFilterButtonStates, (byte)GuiButtonRegistry.getButton(ButtonNames.EXACT).getId());
            this.inventory.advFilterButtonStartPoint = 0;
            this.initFilterSlots();
        } else {
            for (int i = (row - 1) * 9; i < row * 9; ++i) {
                this.inventory.func_70299_a(i, null);
            }
        }
    }

    @ChestContainer.RowSizeCallback
    public int getNumColumns() {
        return (int)Math.floor(this.inventory.func_70302_i_() / 9);
    }

    public void initFilterSlots() {
        for (int i = 0; i < 9; ++i) {
            this.func_75139_a(this.filterAdvSlotIdStart + i).func_75215_d(this.inventory.advFilterStacks[this.getWraparoundIndex(i)]);
        }
    }

    public void changeAdvFilterSlots(String side) {
        this.saveSlots();
        int startPoint = this.inventory.advFilterButtonStartPoint--;
        if (side.equals("left")) {
            if (startPoint == 0) {
                this.inventory.advFilterButtonStartPoint = 17;
            }
        } else if (side.equals("right")) {
            this.inventory.advFilterButtonStartPoint = startPoint == 17 ? 0 : ++this.inventory.advFilterButtonStartPoint;
        }
        this.initFilterSlots();
    }

    private void saveSlots() {
        for (int i = 0; i < 9; ++i) {
            this.inventory.advFilterStacks[this.getWraparoundIndex((int)i)] = this.func_75139_a(this.filterAdvSlotIdStart + i).func_75211_c();
        }
    }

    public int getWraparoundIndex(int orderNumber) {
        int startPoint = this.inventory.advFilterButtonStartPoint;
        if (startPoint + orderNumber > 17) {
            return orderNumber + startPoint - 18;
        }
        return startPoint + orderNumber;
    }

    public void setAdvFilterButtonType(int index, int typeToSetTo) {
        this.inventory.advFilterButtonStates[index] = (byte)typeToSetTo;
    }
}

