/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.client.gui.inventory;

import gr8pefish.ironbackpacks.api.client.gui.button.ButtonNames;
import gr8pefish.ironbackpacks.api.register.ItemIUpgradeRegistry;
import gr8pefish.ironbackpacks.client.gui.buttons.TooltipButton;
import gr8pefish.ironbackpacks.config.ConfigHandler;
import gr8pefish.ironbackpacks.container.alternateGui.ContainerAlternateGui;
import gr8pefish.ironbackpacks.container.alternateGui.InventoryAlternateGui;
import gr8pefish.ironbackpacks.items.backpacks.ItemBackpack;
import gr8pefish.ironbackpacks.items.upgrades.UpgradeMethods;
import gr8pefish.ironbackpacks.network.NetworkingHandler;
import gr8pefish.ironbackpacks.network.server.AdvFilterTypesMessage;
import gr8pefish.ironbackpacks.network.server.RenameMessage;
import gr8pefish.ironbackpacks.network.server.SingleByteMessage;
import gr8pefish.ironbackpacks.registry.GuiButtonRegistry;
import gr8pefish.ironbackpacks.util.IronBackpacksConstants;
import gr8pefish.ironbackpacks.util.TextUtils;
import gr8pefish.ironbackpacks.util.helpers.IronBackpacksHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GUIBackpackAlternate
extends GuiContainer {
    private GUI type;
    public ContainerAlternateGui container;
    private EntityPlayer player;
    private ItemStack itemStack;
    private GuiTextField textField;
    private TooltipButton renameButton;
    private TooltipButton infoButton;
    private TooltipButton moveLeft;
    private TooltipButton moveRight;
    private ArrayList<TooltipButton> advFilters = new ArrayList();
    private ArrayList<TooltipButton> tooltipButtons = new ArrayList();
    private TooltipButton[] rowIndeces = new TooltipButton[4];
    private long prevSystemTime;
    private int hoverTime;
    private boolean hasButtonUpgrade;
    private boolean hasNoUpgrades;
    private boolean hasRenamingUpgrade;
    private boolean hasFilterBasicUpgrade;
    private boolean hasFilterFuzzyUpgrade;
    private boolean hasFilterOreDictUpgrade;
    private boolean hasFilterModSpecificUpgrade;
    private boolean hasRestockingUpgrade;
    private boolean hasCraftingUpgrade;
    private boolean hasCraftingSmallUpgrade;
    private boolean hasCraftingTinyUpgrade;
    public boolean hasFilterAdvancedUpgrade;
    private boolean hasFilterMiningUpgrade;
    private boolean hasFilterVoidUpgrade;

    private GUIBackpackAlternate(GUI type, EntityPlayer player, InventoryAlternateGui inv, ArrayList<ItemStack> upgrades, ItemStack backpack) {
        super(type.makeContainer(inv));
        this.player = player;
        this.container = (ContainerAlternateGui)type.makeContainer(inv);
        this.type = type;
        this.field_146999_f = type.xSize;
        this.field_147000_g = type.ySize;
        this.hasNoUpgrades = type.equals((Object)GUI.ZERO);
        this.hasButtonUpgrade = UpgradeMethods.hasButtonUpgrade(upgrades);
        this.hasRenamingUpgrade = ConfigHandler.renamingUpgradeRequired ? UpgradeMethods.hasRenamingUpgrade(upgrades) : true;
        this.hasCraftingUpgrade = UpgradeMethods.hasCraftingUpgrade(upgrades);
        this.hasCraftingSmallUpgrade = UpgradeMethods.hasCraftingSmallUpgrade(upgrades);
        this.hasCraftingTinyUpgrade = UpgradeMethods.hasCraftingTinyUpgrade(upgrades);
        this.hasFilterBasicUpgrade = UpgradeMethods.hasFilterBasicUpgrade(upgrades);
        this.hasFilterFuzzyUpgrade = UpgradeMethods.hasFilterFuzzyUpgrade(upgrades);
        this.hasFilterOreDictUpgrade = UpgradeMethods.hasFilterOreDictUpgrade(upgrades);
        this.hasFilterModSpecificUpgrade = UpgradeMethods.hasFilterModSpecificUpgrade(upgrades);
        this.hasFilterVoidUpgrade = UpgradeMethods.hasFilterVoidUpgrade(upgrades);
        this.hasFilterAdvancedUpgrade = UpgradeMethods.hasFilterAdvancedUpgrade(upgrades);
        this.hasFilterMiningUpgrade = UpgradeMethods.hasFilterMiningUpgrade(upgrades);
        this.hasRestockingUpgrade = UpgradeMethods.hasRestockingUpgrade(upgrades);
        this.itemStack = backpack;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int xStart = (this.field_146294_l - this.field_146999_f) / 2;
        int yStart = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.hasRenamingUpgrade) {
            this.field_146291_p = true;
            this.textField = new GuiTextField(0, this.field_146289_q, xStart + 20, yStart + 21, 103, 12);
            this.textField.func_146193_g(-1);
            this.textField.func_146204_h(-1);
            this.textField.func_146203_f(29);
            Keyboard.enableRepeatEvents((boolean)true);
        }
        this.drawButtons();
    }

    protected void func_146976_a(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(((GUI)this.type).guiResourceList.location);
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x + 12, y, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawInfoStrings();
        this.drawHoveringOverTooltipButton(mouseX, mouseY);
    }

    public void drawButtons() {
        this.field_146292_n.clear();
        this.tooltipButtons.clear();
        Arrays.fill(this.rowIndeces, null);
        int rowIndex = 0;
        if (this.hasRenamingUpgrade) {
            int xStart = (this.field_146294_l - this.field_146999_f) / 2;
            int yStart = (this.field_146295_m - this.field_147000_g) / 2;
            this.renameButton = new TooltipButton(GuiButtonRegistry.getButton(ButtonNames.RENAME), xStart + this.field_146999_f - 57, yStart + 22);
            this.field_146292_n.add(this.renameButton);
            this.tooltipButtons.add(this.renameButton);
        }
        int xStartInfo = (this.field_146294_l - this.field_146999_f) / 2 + this.field_146999_f - 12;
        int yStartInfo = this.hasFilterAdvancedUpgrade && !this.hasFilterMiningUpgrade && !this.hasRestockingUpgrade ? (this.field_146295_m - this.field_147000_g) / 2 + this.field_147000_g + 2 : (this.field_146295_m - this.field_147000_g) / 2 + this.field_147000_g;
        this.infoButton = new TooltipButton(rowIndex, GuiButtonRegistry.getButton(ButtonNames.INFO), xStartInfo - 20, yStartInfo - 92, this.getInfoTooltip());
        this.field_146292_n.add(this.infoButton);
        this.tooltipButtons.add(this.infoButton);
        int yStartButton = (this.field_146295_m - this.field_147000_g) / 2 + (this.hasRenamingUpgrade ? 40 : 21);
        int xStart = (this.field_146294_l - this.field_146999_f) / 2 + this.field_146999_f - 12 - 19;
        if (this.hasButtonUpgrade) {
            if (this.hasCraftingUpgrade) {
                this.rowIndeces[rowIndex] = new TooltipButton(rowIndex, GuiButtonRegistry.getButton(ButtonNames.CLEAR_ROW), xStart, yStartButton, TextUtils.cutLongString(TextUtils.localizeEffect("button.ironbackpacks.clear.condenser.tooltip", new Object[0])));
                this.field_146292_n.add(this.rowIndeces[rowIndex]);
                ++rowIndex;
                yStartButton += 36;
            }
            if (this.hasCraftingSmallUpgrade) {
                this.rowIndeces[rowIndex] = new TooltipButton(rowIndex, GuiButtonRegistry.getButton(ButtonNames.CLEAR_ROW), xStart, yStartButton, TextUtils.cutLongString(TextUtils.localizeEffect("button.ironbackpacks.clear.condenser.small.tooltip", new Object[0])));
                this.field_146292_n.add(this.rowIndeces[rowIndex]);
                ++rowIndex;
                yStartButton += 36;
            }
            if (this.hasCraftingTinyUpgrade) {
                this.rowIndeces[++rowIndex] = new TooltipButton(rowIndex, GuiButtonRegistry.getButton(ButtonNames.CLEAR_ROW), xStart, yStartButton += 36, TextUtils.cutLongString(TextUtils.localizeEffect("button.ironbackpacks.clear.condenser.tiny.tooltip", new Object[0])));
                this.field_146292_n.add(this.rowIndeces[++rowIndex]);
            }
            if (this.hasFilterBasicUpgrade) {
                this.rowIndeces[rowIndex] = new TooltipButton(rowIndex, GuiButtonRegistry.getButton(ButtonNames.CLEAR_ROW), xStart, yStartButton, TextUtils.cutLongString(TextUtils.localizeEffect("button.ironbackpacks.clear.basicFilter.tooltip", new Object[0])));
                this.field_146292_n.add(this.rowIndeces[rowIndex]);
                ++rowIndex;
                yStartButton += 36;
            }
            if (this.hasFilterFuzzyUpgrade) {
                this.rowIndeces[rowIndex] = new TooltipButton(rowIndex, GuiButtonRegistry.getButton(ButtonNames.CLEAR_ROW), xStart, yStartButton, TextUtils.cutLongString(TextUtils.localizeEffect("button.ironbackpacks.clear.fuzzyFilter.tooltip", new Object[0])));
                this.field_146292_n.add(this.rowIndeces[rowIndex]);
                ++rowIndex;
                yStartButton += 36;
            }
            if (this.hasFilterOreDictUpgrade) {
                this.rowIndeces[rowIndex] = new TooltipButton(rowIndex, GuiButtonRegistry.getButton(ButtonNames.CLEAR_ROW), xStart, yStartButton, TextUtils.cutLongString(TextUtils.localizeEffect("button.ironbackpacks.clear.oreDictFilter.tooltip", new Object[0])));
                this.field_146292_n.add(this.rowIndeces[rowIndex]);
                ++rowIndex;
                yStartButton += 36;
            }
            if (this.hasFilterModSpecificUpgrade) {
                this.rowIndeces[rowIndex] = new TooltipButton(rowIndex, GuiButtonRegistry.getButton(ButtonNames.CLEAR_ROW), xStart, yStartButton, TextUtils.cutLongString(TextUtils.localizeEffect("button.ironbackpacks.clear.modSpecificFilter.tooltip", new Object[0])));
                this.field_146292_n.add(this.rowIndeces[rowIndex]);
                ++rowIndex;
                yStartButton += 36;
            }
            if (this.hasFilterVoidUpgrade) {
                this.rowIndeces[rowIndex] = new TooltipButton(rowIndex, GuiButtonRegistry.getButton(ButtonNames.CLEAR_ROW), xStart, yStartButton, TextUtils.cutLongString(TextUtils.localizeEffect("button.ironbackpacks.clear.voidFilter.tooltip", new Object[0])));
                this.field_146292_n.add(this.rowIndeces[rowIndex]);
                ++rowIndex;
                yStartButton += 36;
            }
        } else {
            if (this.hasCraftingUpgrade) {
                yStartButton += 36;
            }
            if (this.hasCraftingSmallUpgrade) {
                yStartButton += 36;
            }
            if (this.hasCraftingTinyUpgrade) {
                yStartButton += 36;
            }
            if (this.hasFilterBasicUpgrade) {
                yStartButton += 36;
            }
            if (this.hasFilterFuzzyUpgrade) {
                yStartButton += 36;
            }
            if (this.hasFilterOreDictUpgrade) {
                yStartButton += 36;
            }
            if (this.hasFilterModSpecificUpgrade) {
                yStartButton += 36;
            }
            if (this.hasFilterVoidUpgrade) {
                yStartButton += 36;
            }
        }
        if (this.hasFilterAdvancedUpgrade) {
            TooltipButton temp;
            this.moveLeft = new TooltipButton(GuiButtonRegistry.getButton(ButtonNames.MOVE_LEFT), this.field_147003_i + 15, yStartButton + 17);
            this.field_146292_n.add(this.moveLeft);
            this.moveRight = new TooltipButton(GuiButtonRegistry.getButton(ButtonNames.MOVE_RIGHT), xStart + 12, yStartButton + 17);
            this.field_146292_n.add(this.moveRight);
            this.tooltipButtons.add(this.moveLeft);
            this.tooltipButtons.add(this.moveRight);
            this.advFilters.clear();
            int xPositionStart = 20;
            if (this.container.getInventoryAlternateGui().getAdvFilterButtonStartPoint() + 9 > 18) {
                int i;
                int overlap = 9 - (18 - this.container.getInventoryAlternateGui().getAdvFilterButtonStartPoint());
                for (i = this.container.getInventoryAlternateGui().getAdvFilterButtonStartPoint(); i < 18; ++i) {
                    temp = new TooltipButton(GuiButtonRegistry.getAdvFilterButtons()[this.container.getInventoryAlternateGui().getAdvFilterButtonStates()[i] - 1], this.field_147003_i + xPositionStart, yStartButton + 31);
                    this.field_146292_n.add(temp);
                    this.advFilters.add(temp);
                    this.tooltipButtons.add(temp);
                    xPositionStart += 18;
                }
                for (i = 0; i < overlap; ++i) {
                    temp = new TooltipButton(GuiButtonRegistry.getAdvFilterButtons()[this.container.getInventoryAlternateGui().getAdvFilterButtonStates()[i] - 1], this.field_147003_i + xPositionStart, yStartButton + 31);
                    this.field_146292_n.add(temp);
                    this.advFilters.add(temp);
                    this.tooltipButtons.add(temp);
                    xPositionStart += 18;
                }
            } else {
                for (int i = this.container.getInventoryAlternateGui().getAdvFilterButtonStartPoint(); i < this.container.getInventoryAlternateGui().getAdvFilterButtonStartPoint() + 9; ++i) {
                    temp = new TooltipButton(GuiButtonRegistry.getAdvFilterButtons()[this.container.getInventoryAlternateGui().getAdvFilterButtonStates()[i] - 1], this.field_147003_i + xPositionStart, yStartButton + 31);
                    this.field_146292_n.add(temp);
                    this.advFilters.add(temp);
                    this.tooltipButtons.add(temp);
                    xPositionStart += 18;
                }
            }
            if (this.hasButtonUpgrade) {
                this.rowIndeces[rowIndex] = new TooltipButton(rowIndex, GuiButtonRegistry.getButton(ButtonNames.CLEAR_ROW), xStart, yStartButton, TextUtils.cutLongString(TextUtils.localizeEffect("button.ironbackpacks.clear.advancedFilter.tooltip", new Object[0])));
                this.field_146292_n.add(this.rowIndeces[rowIndex]);
                ++rowIndex;
            }
            yStartButton += 36;
        }
        if (this.hasButtonUpgrade) {
            if (this.hasFilterMiningUpgrade) {
                this.rowIndeces[rowIndex] = new TooltipButton(rowIndex, GuiButtonRegistry.getButton(ButtonNames.CLEAR_ROW), xStart, yStartButton, TextUtils.cutLongString(TextUtils.localizeEffect("button.ironbackpacks.clear.miningFilter.tooltip", new Object[0])));
                this.field_146292_n.add(this.rowIndeces[rowIndex]);
                ++rowIndex;
                yStartButton += 36;
            }
            if (this.hasRestockingUpgrade) {
                this.rowIndeces[rowIndex] = new TooltipButton(rowIndex, GuiButtonRegistry.getButton(ButtonNames.CLEAR_ROW), xStart, yStartButton, TextUtils.cutLongString(TextUtils.localizeEffect("button.ironbackpacks.clear.hopper.tooltip", new Object[0])));
                this.field_146292_n.add(this.rowIndeces[rowIndex]);
                ++rowIndex;
            }
        }
        for (int i = 0; i <= rowIndex; ++i) {
            if (this.rowIndeces[i] == null) continue;
            this.tooltipButtons.add(this.rowIndeces[i]);
        }
    }

    private void drawInfoStrings() {
        int yStart;
        String displayName = this.itemStack == null ? TextUtils.localize("gui.ironbackpacks.uuidError", new Object[0]) : this.itemStack.func_82833_r();
        this.field_146289_q.func_78276_b(TextUtils.localize(displayName, new Object[0]), 20, 6, 0x404040);
        int counter = this.hasFilterAdvancedUpgrade && !this.hasFilterMiningUpgrade && !this.hasRestockingUpgrade ? 5 : 4;
        this.field_146289_q.func_78276_b(TextUtils.localize("container.inventory", new Object[0]), 20, this.field_147000_g - 96 + counter, 0x404040);
        if (this.hasNoUpgrades) {
            this.field_146289_q.func_78276_b(TextUtils.localize("gui.ironbackpacks.noValidUpgradesFound", new Object[0]), 20, 22, 0x404040);
        }
        int n = yStart = this.hasRenamingUpgrade ? 44 : 25;
        if (this.hasCraftingUpgrade) {
            this.field_146289_q.func_78276_b(TextUtils.localize("item.ironbackpacks.upgrade.crafting.name", new Object[0]), 20, yStart, 0x404040);
            yStart += 36;
        }
        if (this.hasCraftingSmallUpgrade) {
            this.field_146289_q.func_78276_b(TextUtils.localize("item.ironbackpacks.upgrade.craftingSmall.name", new Object[0]), 20, yStart, 0x404040);
            yStart += 36;
        }
        if (this.hasCraftingTinyUpgrade) {
            this.field_146289_q.func_78276_b(TextUtils.localize("item.ironbackpacks.upgrade.craftingTiny.name", new Object[0]), 20, yStart, 0x404040);
            yStart += 36;
        }
        if (this.hasFilterBasicUpgrade) {
            this.field_146289_q.func_78276_b(TextUtils.localize("item.ironbackpacks.upgrade.filterBasic.name", new Object[0]), 20, yStart, 0x404040);
            yStart += 36;
        }
        if (this.hasFilterFuzzyUpgrade) {
            this.field_146289_q.func_78276_b(TextUtils.localize("item.ironbackpacks.upgrade.filterFuzzy.name", new Object[0]), 20, yStart, 0x404040);
            yStart += 36;
        }
        if (this.hasFilterOreDictUpgrade) {
            this.field_146289_q.func_78276_b(TextUtils.localize("item.ironbackpacks.upgrade.filterOreDict.name", new Object[0]), 20, yStart, 0x404040);
            yStart += 36;
        }
        if (this.hasFilterModSpecificUpgrade) {
            this.field_146289_q.func_78276_b(TextUtils.localize("item.ironbackpacks.upgrade.filterModSpecific.name", new Object[0]), 20, yStart, 0x404040);
            yStart += 36;
        }
        if (this.hasFilterVoidUpgrade) {
            this.field_146289_q.func_78276_b(TextUtils.localize("item.ironbackpacks.upgrade.filterVoid.name", new Object[0]), 20, yStart, 0x404040);
            yStart += 36;
        }
        if (this.hasFilterAdvancedUpgrade) {
            this.field_146289_q.func_78276_b(TextUtils.localize("item.ironbackpacks.upgrade.filterAdvanced.name", new Object[0]), 20, yStart, 0x404040);
            yStart += 36;
        }
        if (this.hasFilterMiningUpgrade) {
            this.field_146289_q.func_78276_b(TextUtils.localize("item.ironbackpacks.upgrade.filterMining.name", new Object[0]), 20, yStart, 0x404040);
            yStart += 36;
        }
        if (this.hasRestockingUpgrade) {
            this.field_146289_q.func_78276_b(TextUtils.localize("item.ironbackpacks.upgrade.restocking.name", new Object[0]), 20, yStart, 0x404040);
        }
    }

    private void drawHoveringOverTooltipButton(int mouseX, int mouseY) {
        ScaledResolution scaledResolution = new ScaledResolution(Minecraft.func_71410_x());
        int w = (this.field_146294_l - this.field_146999_f) / 2;
        int h = (this.field_146295_m - this.field_147000_g) / 2;
        TooltipButton curr = null;
        for (TooltipButton button : this.tooltipButtons) {
            if (button == null || !button.mouseInButton(mouseX, mouseY)) continue;
            curr = button;
            break;
        }
        if (curr != null) {
            if (curr.getHoverTime() == 0) {
                GuiUtils.drawHoveringText(curr.getTooltip(), (int)(mouseX - w), (int)(mouseY - h), (int)(scaledResolution.func_78326_a() - w), (int)(scaledResolution.func_78328_b() - h), (int)-1, (FontRenderer)this.field_146289_q);
            } else {
                long systemTime = System.currentTimeMillis();
                if (this.prevSystemTime != 0L) {
                    this.hoverTime = (int)((long)this.hoverTime + (systemTime - this.prevSystemTime));
                }
                this.prevSystemTime = systemTime;
                if (this.hoverTime > curr.getHoverTime()) {
                    GuiUtils.drawHoveringText(curr.getTooltip(), (int)(mouseX - w), (int)(mouseY - h), (int)(scaledResolution.func_78326_a() - w), (int)(scaledResolution.func_78328_b() - h), (int)-1, (FontRenderer)this.field_146289_q);
                }
            }
        } else {
            this.hoverTime = 0;
            this.prevSystemTime = 0L;
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.renameButton) {
            String textToChangeTo = this.textField.func_146179_b();
            if (textToChangeTo.length() > 0) {
                this.container.renameBackpack(textToChangeTo);
                NetworkingHandler.network.sendToServer((IMessage)new RenameMessage(textToChangeTo));
                this.textField.func_146180_a("");
                this.textField.func_146195_b(false);
            }
        } else if (button == this.moveLeft) {
            this.container.changeAdvFilterSlots("left");
            NetworkingHandler.network.sendToServer((IMessage)new SingleByteMessage(8));
            this.drawButtons();
        } else if (button == this.moveRight) {
            this.container.changeAdvFilterSlots("right");
            NetworkingHandler.network.sendToServer((IMessage)new SingleByteMessage(9));
            this.drawButtons();
        } else if (this.advFilters.contains(button)) {
            byte slot = (byte)this.container.getWraparoundIndex(this.advFilters.indexOf(button));
            byte changeTo = (byte)TooltipButton.incrementType(button);
            this.container.setAdvFilterButtonType(slot, changeTo);
            NetworkingHandler.network.sendToServer((IMessage)new AdvFilterTypesMessage(slot, changeTo));
            this.drawButtons();
        } else if (button == this.rowIndeces[0]) {
            this.container.removeSlotsInRow(1);
            NetworkingHandler.network.sendToServer((IMessage)new SingleByteMessage(1));
            this.drawButtons();
        } else if (button == this.rowIndeces[1]) {
            this.container.removeSlotsInRow(2);
            NetworkingHandler.network.sendToServer((IMessage)new SingleByteMessage(2));
            this.drawButtons();
        } else if (button == this.rowIndeces[2]) {
            this.container.removeSlotsInRow(3);
            NetworkingHandler.network.sendToServer((IMessage)new SingleByteMessage(3));
            this.drawButtons();
        }
    }

    protected void func_73869_a(char char1, int int1) throws IOException {
        if (this.hasRenamingUpgrade) {
            if (!this.textField.func_146201_a(char1, int1)) {
                super.func_73869_a(char1, int1);
            }
        } else {
            super.func_73869_a(char1, int1);
        }
    }

    protected void func_73864_a(int int1, int int2, int int3) throws IOException {
        super.func_73864_a(int1, int2, int3);
        if (this.hasRenamingUpgrade) {
            this.textField.func_146192_a(int1, int2, int3);
        }
    }

    public void func_73863_a(int int1, int int2, float float1) {
        super.func_73863_a(int1, int2, float1);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        if (this.hasRenamingUpgrade) {
            this.textField.func_146194_f();
        }
    }

    public void func_146282_l() throws IOException {
        String textToChangeTo;
        super.func_146282_l();
        if (this.hasRenamingUpgrade && this.textField.func_146206_l() && Keyboard.getEventKey() == 28 && (textToChangeTo = this.textField.func_146179_b()).length() > 0) {
            this.container.renameBackpack(textToChangeTo);
            NetworkingHandler.network.sendToServer((IMessage)new RenameMessage(textToChangeTo));
            this.textField.func_146180_a("");
            this.textField.func_146195_b(false);
        }
    }

    public boolean func_146981_a(Slot slot, int mPosX, int mPosY) {
        return (mPosX -= this.field_147003_i) >= slot.field_75223_e - 1 && mPosX < slot.field_75223_e + 16 + 1 && (mPosY -= this.field_147009_r) >= slot.field_75221_f - 1 && mPosY < slot.field_75221_f + 16 + 1;
    }

    private String[] getInfoTooltip() {
        int additionalPossiblePoints;
        String speciality;
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<ItemStack> upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(this.itemStack);
        int totalUpgradePoints = IronBackpacksHelper.getTotalUpgradePointsFromNBT(this.itemStack);
        int upgradesUsed = 0;
        list.add(TextUtils.localizeEffect("tooltip.ironbackpacks.backpack.tier", new Object[0]) + " " + ((ItemBackpack)this.itemStack.func_77973_b()).getTierName(this.itemStack));
        for (ItemStack upgradeStack : upgrades) {
            list.add(TextUtils.localizeEffect("item.ironbackpacks.upgrade." + ItemIUpgradeRegistry.getItemUpgrade(upgradeStack).getName(upgradeStack) + ".name", new Object[0]));
            upgradesUsed += ItemIUpgradeRegistry.getItemUpgrade(upgradeStack).getUpgradeCost(upgradeStack);
        }
        if (upgrades.size() > 0) {
            list.add("");
        }
        if ((speciality = ((ItemBackpack)this.itemStack.func_77973_b()).getSpecialty(null)) != null) {
            list.add(TextUtils.localizeEffect(speciality, new Object[0]));
        }
        list.add(TextUtils.localizeEffect("tooltip.ironbackpacks.backpack.upgrade.used", upgradesUsed, totalUpgradePoints));
        list.add(TextUtils.localizeEffect("tooltip.ironbackpacks.backpack.upgrade.used.alt", UpgradeMethods.getAltGuiUpgradesApplied(upgrades), IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADES_ALLOWED));
        if (ConfigHandler.renamingUpgradeRequired) {
            list.add(TextUtils.localizeEffect("tooltip.ironbackpacks.backpack.upgrade.rename", IronBackpacksConstants.Upgrades.ALT_GUI_UPGRADES_ALLOWED));
        }
        if ((additionalPossiblePoints = ((ItemBackpack)this.itemStack.func_77973_b()).getAdditionalUpgradePoints(null)) > 0) {
            int used = IronBackpacksHelper.getAdditionalUpgradesTimesApplied(this.itemStack) * ConfigHandler.additionalUpgradePointsIncrease;
            list.add(TextUtils.localizeEffect("tooltip.ironbackpacks.backpack.upgrade.used.additionalPoints", used, additionalPossiblePoints));
        }
        return list.toArray(new String[list.size()]);
    }

    public static enum GUI {
        ZERO(200, 132, ResourceList.ZERO),
        ONE(200, 150, ResourceList.ONE),
        TWO(200, 186, ResourceList.TWO),
        THREE(200, 222, ResourceList.THREE),
        RENAMING_ZERO(200, 132, ResourceList.ZERO),
        RENAMING_ONE(200, 168, ResourceList.RENAMING_ONE),
        RENAMING_TWO(200, 204, ResourceList.RENAMING_TWO),
        RENAMING_THREE(200, 240, ResourceList.RENAMING_THREE);

        private int xSize;
        private int ySize;
        private ResourceList guiResourceList;

        private GUI(int xSize, int ySize, ResourceList guiResourceList) {
            this.xSize = xSize;
            this.ySize = ySize;
            this.guiResourceList = guiResourceList;
        }

        public static GUIBackpackAlternate buildGUIAlternate(InventoryAlternateGui inv) {
            ArrayList<ItemStack> upgrades = IronBackpacksHelper.getUpgradesAppliedFromNBT(inv.getBackpackStack());
            GUI gui = ConfigHandler.renamingUpgradeRequired ? (UpgradeMethods.hasRenamingUpgrade(upgrades) ? GUI.values()[UpgradeMethods.getAltGuiUpgradesApplied(upgrades) + 3] : GUI.values()[UpgradeMethods.getAltGuiUpgradesApplied(upgrades)]) : GUI.values()[UpgradeMethods.getAltGuiUpgradesApplied(upgrades) + 4];
            return new GUIBackpackAlternate(gui, inv.getPlayer(), inv, upgrades, inv.getBackpackStack());
        }

        private Container makeContainer(InventoryAlternateGui inv) {
            return new ContainerAlternateGui(inv, this.xSize, this.ySize);
        }
    }

    public static enum ResourceList {
        ZERO(new ResourceLocation("ironbackpacks", "textures/guis/alternateGui/ZERO_alternateGui.png")),
        ONE(new ResourceLocation("ironbackpacks", "textures/guis/alternateGui/ONE_alternateGui.png")),
        TWO(new ResourceLocation("ironbackpacks", "textures/guis/alternateGui/TWO_alternateGui.png")),
        THREE(new ResourceLocation("ironbackpacks", "textures/guis/alternateGui/THREE_alternateGui.png")),
        RENAMING_ONE(new ResourceLocation("ironbackpacks", "textures/guis/alternateGui/RENAMING_ONE_alternateGui.png")),
        RENAMING_TWO(new ResourceLocation("ironbackpacks", "textures/guis/alternateGui/RENAMING_TWO_alternateGui.png")),
        RENAMING_THREE(new ResourceLocation("ironbackpacks", "textures/guis/alternateGui/RENAMING_THREE_alternateGui.png"));

        public final ResourceLocation location;

        private ResourceList(ResourceLocation loc) {
            this.location = loc;
        }
    }
}

