/*
 * Decompiled with CFR 0.152.
 */
package gr8pefish.ironbackpacks.client.gui.inventory;

import gr8pefish.ironbackpacks.api.client.gui.button.ButtonNames;
import gr8pefish.ironbackpacks.client.gui.buttons.TooltipButton;
import gr8pefish.ironbackpacks.container.backpack.ContainerBackpack;
import gr8pefish.ironbackpacks.container.backpack.InventoryBackpack;
import gr8pefish.ironbackpacks.items.backpacks.ItemBackpack;
import gr8pefish.ironbackpacks.items.upgrades.UpgradeMethods;
import gr8pefish.ironbackpacks.network.NetworkingHandler;
import gr8pefish.ironbackpacks.network.server.SingleByteMessage;
import gr8pefish.ironbackpacks.registry.GuiButtonRegistry;
import gr8pefish.ironbackpacks.util.TextUtils;
import gr8pefish.ironbackpacks.util.helpers.IronBackpacksHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GUIBackpack
extends GuiContainer {
    private ContainerBackpack container;
    private ItemStack itemStack;
    private ItemBackpack itemBackpack;
    private TooltipButton backpack_to_inventory_BUTTON;
    private TooltipButton inventory_to_backpack_BUTTON;
    private TooltipButton hotbar_to_backpack_BUTTON;
    private TooltipButton sort_backpack_BUTTON;
    private boolean hasAButtonUpgrade;
    private ArrayList<TooltipButton> tooltipButtons;
    private long prevSystemTime;
    private int hoverTime;
    private EntityPlayer player;

    private GUIBackpack(EntityPlayer player, InventoryBackpack inventoryBackpack) {
        super((Container)new ContainerBackpack(inventoryBackpack, ((ItemBackpack)inventoryBackpack.getBackpackStack().func_77973_b()).getGuiXSize(inventoryBackpack.getBackpackStack()), ((ItemBackpack)inventoryBackpack.getBackpackStack().func_77973_b()).getGuiYSize(inventoryBackpack.getBackpackStack())));
        this.itemStack = inventoryBackpack.getBackpackStack();
        this.itemBackpack = (ItemBackpack)this.itemStack.func_77973_b();
        this.field_146999_f = this.itemBackpack.getGuiXSize(this.itemStack);
        this.field_147000_g = this.itemBackpack.getGuiYSize(this.itemStack);
        this.container = new ContainerBackpack(inventoryBackpack, this.field_146999_f, this.field_147000_g);
        this.field_146291_p = false;
        this.hasAButtonUpgrade = UpgradeMethods.hasButtonUpgrade(IronBackpacksHelper.getUpgradesAppliedFromNBT(this.itemStack));
        this.tooltipButtons = new ArrayList();
    }

    public static GUIBackpack buildGUI(EntityPlayer player, InventoryBackpack backpack) {
        return new GUIBackpack(player, backpack);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.tooltipButtons.clear();
        if (this.hasAButtonUpgrade) {
            int xStart = (this.field_146294_l - this.field_146999_f) / 2 + this.field_146999_f - 12;
            int yStart = (this.field_146295_m - this.field_147000_g) / 2 + this.field_147000_g;
            this.backpack_to_inventory_BUTTON = new TooltipButton(GuiButtonRegistry.getButton(ButtonNames.BACKPACK_TO_INVENTORY), xStart - 20, yStart - 96);
            this.field_146292_n.add(this.backpack_to_inventory_BUTTON);
            this.hotbar_to_backpack_BUTTON = new TooltipButton(GuiButtonRegistry.getButton(ButtonNames.HOTBAR_TO_BACKPACK), xStart - 40, yStart - 96);
            this.field_146292_n.add(this.hotbar_to_backpack_BUTTON);
            this.inventory_to_backpack_BUTTON = new TooltipButton(GuiButtonRegistry.getButton(ButtonNames.INVENTORY_TO_BACKPACK), xStart - 60, yStart - 96);
            this.field_146292_n.add(this.inventory_to_backpack_BUTTON);
            this.sort_backpack_BUTTON = new TooltipButton(GuiButtonRegistry.getButton(ButtonNames.SORT_BACKPACK), xStart - 80, yStart - 96);
            this.field_146292_n.add(this.sort_backpack_BUTTON);
            this.container.getInventoryBackpack().readFromNBT(this.itemStack.func_77978_p());
            this.sort_backpack_BUTTON.setTooltip(this.getUpdatedSortTooltip());
            this.tooltipButtons.add(this.backpack_to_inventory_BUTTON);
            this.tooltipButtons.add(this.hotbar_to_backpack_BUTTON);
            this.tooltipButtons.add(this.inventory_to_backpack_BUTTON);
            this.tooltipButtons.add(this.sort_backpack_BUTTON);
        }
    }

    protected void func_146976_a(float f, int i, int j) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.itemBackpack.getGuiResourceLocation(this.itemStack));
        int x = (this.field_146294_l - this.field_146999_f) / 2;
        int y = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(x + 12, y, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        if (this.itemStack != null) {
            this.field_146289_q.func_78276_b(TextUtils.localize(this.itemStack.func_82833_r(), new Object[0]), 20, 6, 0x404040);
        } else {
            this.field_146289_q.func_78276_b(TextUtils.localize("misc.ironbackpacks.default.equipped.backpack.name", new Object[0]), 20, 6, 0x404040);
        }
        this.field_146289_q.func_78276_b(TextUtils.localize("container.inventory", new Object[0]), 20, this.field_147000_g - 96 + 2, 0x404040);
        int k = (this.field_146294_l - this.field_146999_f) / 2;
        int l = (this.field_146295_m - this.field_147000_g) / 2;
        TooltipButton curr = null;
        for (TooltipButton button : this.tooltipButtons) {
            if (!button.mouseInButton(mouseX, mouseY)) continue;
            curr = button;
            break;
        }
        if (curr != null) {
            long systemTime = System.currentTimeMillis();
            if (this.prevSystemTime != 0L) {
                this.hoverTime = (int)((long)this.hoverTime + (systemTime - this.prevSystemTime));
            }
            this.prevSystemTime = systemTime;
            if (this.hoverTime > curr.getHoverTime()) {
                this.drawHoveringText(curr.getTooltip(), mouseX - k, mouseY - l, this.field_146289_q);
            }
        } else {
            this.hoverTime = 0;
            this.prevSystemTime = 0L;
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.backpack_to_inventory_BUTTON) {
            this.container.backpackToInventory();
            NetworkingHandler.network.sendToServer((IMessage)new SingleByteMessage(4));
        } else if (button == this.inventory_to_backpack_BUTTON) {
            this.container.inventoryToBackpack();
            NetworkingHandler.network.sendToServer((IMessage)new SingleByteMessage(5));
        } else if (button == this.hotbar_to_backpack_BUTTON) {
            this.container.hotbarToBackpack();
            NetworkingHandler.network.sendToServer((IMessage)new SingleByteMessage(6));
        } else if (button == this.sort_backpack_BUTTON) {
            this.container.sort();
            NetworkingHandler.network.sendToServer((IMessage)new SingleByteMessage(7));
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int buttonClicked) throws IOException {
        if (buttonClicked == 1) {
            if (this.getSlotUnderMouse() != null) {
                super.func_73864_a(mouseX, mouseY, buttonClicked);
            } else {
                for (GuiButton button : this.field_146292_n) {
                    if (!button.func_146116_c(this.field_146297_k, mouseX, mouseY) || button != this.sort_backpack_BUTTON) continue;
                    this.container.getInventoryBackpack().toggleSortType();
                    this.sort_backpack_BUTTON.setTooltip(this.getUpdatedSortTooltip());
                    NetworkingHandler.network.sendToServer((IMessage)new SingleByteMessage(12));
                }
            }
        } else {
            super.func_73864_a(mouseX, mouseY, buttonClicked);
        }
    }

    private ArrayList<String> getUpdatedSortTooltip() {
        ArrayList<String> tooltips = new ArrayList<String>();
        if (this.container.getInventoryBackpack().getSortType().equals("alphabetical")) {
            Collections.addAll(tooltips, TextUtils.cutLongString(TextUtils.localizeEffect("button.ironbackpacks.sort.tooltip.alphabetical", new Object[0])));
        } else {
            Collections.addAll(tooltips, TextUtils.cutLongString(TextUtils.localizeEffect("button.ironbackpacks.sort.tooltip.id", new Object[0])));
        }
        return tooltips;
    }
}

